/*
 * Decompiled with CFR 0.152.
 */
package com.loopeer.cardstack;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.view.animation.AccelerateDecelerateInterpolator;
import com.loopeer.cardstack.CardStackView;

public abstract class AnimatorAdapter {
    static final int ANIMATION_DURATION = 400;
    protected CardStackView mCardStackView;
    protected AnimatorSet mSet;

    public AnimatorAdapter(CardStackView cardStackView) {
        this.mCardStackView = cardStackView;
    }

    protected void initAnimatorSet() {
        this.mSet = new AnimatorSet();
        this.mSet.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        this.mSet.setDuration((long)this.getDuration());
    }

    public void itemClick(CardStackView.ViewHolder viewHolder, int position) {
        if (this.mSet != null && this.mSet.isRunning()) {
            return;
        }
        this.initAnimatorSet();
        if (this.mCardStackView.getSelectPosition() == position) {
            this.onItemCollapse(viewHolder);
        } else {
            this.onItemExpand(viewHolder, position);
        }
        if (this.mCardStackView.getChildCount() == 1) {
            this.mSet.end();
        }
    }

    protected abstract void itemExpandAnimatorSet(CardStackView.ViewHolder var1, int var2);

    protected abstract void itemCollapseAnimatorSet(CardStackView.ViewHolder var1);

    private void onItemExpand(final CardStackView.ViewHolder viewHolder, int position) {
        int preSelectPosition = this.mCardStackView.getSelectPosition();
        final CardStackView.ViewHolder preSelectViewHolder = this.mCardStackView.getViewHolder(preSelectPosition);
        if (preSelectViewHolder != null) {
            preSelectViewHolder.onItemExpand(false);
        }
        this.mCardStackView.setSelectPosition(position);
        this.itemExpandAnimatorSet(viewHolder, position);
        this.mSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                super.onAnimationStart(animation);
                AnimatorAdapter.this.mCardStackView.setScrollEnable(false);
                if (preSelectViewHolder != null) {
                    preSelectViewHolder.onAnimationStateChange(0, false);
                }
                viewHolder.onAnimationStateChange(0, true);
            }

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                viewHolder.onItemExpand(true);
                if (preSelectViewHolder != null) {
                    preSelectViewHolder.onAnimationStateChange(1, false);
                }
                viewHolder.onAnimationStateChange(1, true);
            }

            public void onAnimationCancel(Animator animation) {
                super.onAnimationCancel(animation);
                if (preSelectViewHolder != null) {
                    preSelectViewHolder.onAnimationStateChange(2, false);
                }
                viewHolder.onAnimationStateChange(2, true);
            }
        });
        this.mSet.start();
    }

    private void onItemCollapse(final CardStackView.ViewHolder viewHolder) {
        this.itemCollapseAnimatorSet(viewHolder);
        this.mSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                super.onAnimationStart(animation);
                viewHolder.onItemExpand(false);
                AnimatorAdapter.this.mCardStackView.setScrollEnable(true);
                viewHolder.onAnimationStateChange(0, false);
            }

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                AnimatorAdapter.this.mCardStackView.setSelectPosition(-1);
                viewHolder.onAnimationStateChange(1, false);
            }

            public void onAnimationCancel(Animator animation) {
                super.onAnimationCancel(animation);
                viewHolder.onAnimationStateChange(2, false);
            }
        });
        this.mSet.start();
    }

    protected int getCollapseStartTop(int collapseShowItemCount) {
        return this.mCardStackView.getOverlapGapsCollapse() * (this.mCardStackView.getNumBottomShow() - collapseShowItemCount - (this.mCardStackView.getNumBottomShow() - (this.mCardStackView.getChildCount() - this.mCardStackView.getSelectPosition() > this.mCardStackView.getNumBottomShow() ? this.mCardStackView.getNumBottomShow() : this.mCardStackView.getChildCount() - this.mCardStackView.getSelectPosition() - 1)));
    }

    public int getDuration() {
        return this.mCardStackView.getDuration();
    }
}

