/*
 * Decompiled with CFR 0.152.
 */
package com.lomovskiy.android.library.imagepicker;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import androidx.core.content.FileProvider;
import androidx.fragment.app.Fragment;
import com.lomovskiy.android.library.imagepicker.ImageCompressor;
import com.lomovskiy.android.library.imagepicker.PickType;
import java.io.File;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001$B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0010H\u0002J\b\u0010\u0014\u001a\u00020\u0010H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\"\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\r2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J(\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\r2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010\u001e\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010#\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/lomovskiy/android/library/imagepicker/ImagePicker;", "", "context", "Landroid/content/Context;", "destinationPath", "", "compressor", "Lcom/lomovskiy/android/library/imagepicker/ImageCompressor;", "(Landroid/content/Context;Ljava/lang/String;Lcom/lomovskiy/android/library/imagepicker/ImageCompressor;)V", "authority", "dateTimeFormatter", "Ljava/text/SimpleDateFormat;", "rcCamera", "", "rcGallery", "tempPhotoFile", "Ljava/io/File;", "getGalleryIntent", "Landroid/content/Intent;", "getNewPhotoFile", "getNewTempFile", "handleCameraResult", "", "resultCode", "callback", "Lcom/lomovskiy/android/library/imagepicker/ImagePicker$Callback;", "handleGalleryResult", "data", "handleOnActivityResult", "requestCode", "pickFromCamera", "activity", "Landroid/app/Activity;", "fragment", "Landroidx/fragment/app/Fragment;", "pickFromGallery", "Callback", "library_release"})
public final class ImagePicker {
    private final int rcGallery = 997;
    private final int rcCamera = 991;
    private final String authority;
    private final SimpleDateFormat dateTimeFormatter;
    private File tempPhotoFile;
    private final Context context;
    private final String destinationPath;
    private final ImageCompressor compressor;

    public final void pickFromCamera(@NotNull Fragment fragment) throws UnsupportedOperationException {
        File file;
        Intrinsics.checkParameterIsNotNull((Object)fragment, (String)"fragment");
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (intent.resolveActivity(this.context.getPackageManager()) != null) {
            file = this.tempPhotoFile = this.getNewTempFile();
            if (file == null) {
                Intrinsics.throwNpe();
            }
        } else {
            throw (Throwable)new UnsupportedOperationException("Activity for doing this action is not find");
        }
        Uri photoUri = FileProvider.getUriForFile((Context)this.context, (String)this.authority, (File)file);
        intent.putExtra("output", (Parcelable)photoUri);
        fragment.startActivityForResult(intent, this.rcCamera);
    }

    public final void pickFromCamera(@NotNull Activity activity) throws UnsupportedOperationException {
        File file;
        Context context;
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (intent.resolveActivity(this.context.getPackageManager()) != null) {
            this.tempPhotoFile = this.getNewTempFile();
            context = (Context)activity;
            file = this.tempPhotoFile;
            if (file == null) {
                Intrinsics.throwNpe();
            }
        } else {
            throw (Throwable)new UnsupportedOperationException("Activity for doing this action is not find");
        }
        Uri photoUri = FileProvider.getUriForFile((Context)context, (String)this.authority, (File)file);
        intent.putExtra("output", (Parcelable)photoUri);
        activity.startActivityForResult(intent, this.rcCamera);
    }

    public final void pickFromGallery(@NotNull Fragment fragment) {
        Intrinsics.checkParameterIsNotNull((Object)fragment, (String)"fragment");
        fragment.startActivityForResult(this.getGalleryIntent(), this.rcGallery);
    }

    public final void pickFromGallery(@NotNull Activity activity) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        activity.startActivityForResult(this.getGalleryIntent(), this.rcGallery);
    }

    public final void handleOnActivityResult(int requestCode, int resultCode, @Nullable Intent data, @NotNull Callback callback) {
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        if (requestCode == this.rcGallery) {
            this.handleGalleryResult(resultCode, data, callback);
        } else if (requestCode == this.rcCamera) {
            this.handleCameraResult(resultCode, callback);
        }
    }

    private final void handleGalleryResult(int resultCode, Intent data, Callback callback) {
        switch (resultCode) {
            case -1: {
                try {
                    this.tempPhotoFile = this.getNewTempFile();
                    Intent intent = data;
                    if (intent == null) {
                        Intrinsics.throwNpe();
                    }
                    Uri uri = intent.getData();
                    if (uri == null) {
                        Intrinsics.throwNpe();
                    }
                    Uri uri2 = uri;
                    File file = this.tempPhotoFile;
                    if (file == null) {
                        Intrinsics.throwNpe();
                    }
                    InputStream inputStream = this.context.getContentResolver().openInputStream(uri2);
                    if (inputStream == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"context.contentResolver.openInputStream(uri)!!");
                    FilesKt.writeBytes((File)file, (byte[])ByteStreamsKt.readBytes((InputStream)inputStream));
                    File photoFile = this.getNewPhotoFile();
                    if (this.compressor == null) {
                        File file2 = this.tempPhotoFile;
                        if (file2 == null) {
                            Intrinsics.throwNpe();
                        }
                        FilesKt.writeBytes((File)photoFile, (byte[])FilesKt.readBytes((File)file2));
                    } else {
                        File file3 = this.tempPhotoFile;
                        if (file3 == null) {
                            Intrinsics.throwNpe();
                        }
                        this.compressor.compress(file3, photoFile);
                    }
                    File file4 = this.tempPhotoFile;
                    if (file4 == null) {
                        Intrinsics.throwNpe();
                    }
                    file4.delete();
                    callback.onSuccess(photoFile, PickType.Gallery.INSTANCE);
                }
                catch (Exception e) {
                    callback.onFailure(e, PickType.Gallery.INSTANCE);
                }
                break;
            }
            case 0: {
                callback.onCancel(PickType.Gallery.INSTANCE);
                break;
            }
        }
    }

    private final void handleCameraResult(int resultCode, Callback callback) {
        switch (resultCode) {
            case -1: {
                try {
                    File photoFile = this.getNewPhotoFile();
                    if (this.compressor == null) {
                        File file = this.tempPhotoFile;
                        if (file == null) {
                            Intrinsics.throwNpe();
                        }
                        FilesKt.writeBytes((File)photoFile, (byte[])FilesKt.readBytes((File)file));
                    } else {
                        File file = this.tempPhotoFile;
                        if (file == null) {
                            Intrinsics.throwNpe();
                        }
                        this.compressor.compress(file, photoFile);
                    }
                    File file = this.tempPhotoFile;
                    if (file == null) {
                        Intrinsics.throwNpe();
                    }
                    file.delete();
                    callback.onSuccess(photoFile, PickType.Camera.INSTANCE);
                }
                catch (Exception e) {
                    callback.onFailure(e, PickType.Camera.INSTANCE);
                }
                break;
            }
            case 0: {
                callback.onCancel(PickType.Camera.INSTANCE);
                break;
            }
        }
    }

    private final Intent getGalleryIntent() {
        Intent intent = new Intent("android.intent.action.PICK");
        boolean bl = false;
        boolean bl2 = false;
        Intent $this$apply = intent;
        boolean bl3 = false;
        $this$apply.setType("image/*");
        return intent;
    }

    private final File getNewTempFile() {
        return new File("" + this.context.getCacheDir() + '/' + UUID.randomUUID());
    }

    private final File getNewPhotoFile() {
        return new File(this.destinationPath + '/' + UUID.randomUUID() + ".jpg");
    }

    public ImagePicker(@NotNull Context context, @NotNull String destinationPath, @Nullable ImageCompressor compressor) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)destinationPath, (String)"destinationPath");
        this.context = context;
        this.destinationPath = destinationPath;
        this.compressor = compressor;
        this.rcGallery = 997;
        this.rcCamera = 991;
        this.authority = this.context.getPackageName() + ".imagepicker.fileprovider";
        this.dateTimeFormatter = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.getDefault());
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u001c\u0010\u0006\u001a\u00020\u00032\n\u0010\u0007\u001a\u00060\bj\u0002`\t2\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0018\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\r"}, d2={"Lcom/lomovskiy/android/library/imagepicker/ImagePicker$Callback;", "", "onCancel", "", "pickType", "Lcom/lomovskiy/android/library/imagepicker/PickType;", "onFailure", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onSuccess", "file", "Ljava/io/File;", "library_release"})
    public static interface Callback {
        public void onCancel(@NotNull PickType var1);

        public void onFailure(@NotNull Exception var1, @NotNull PickType var2);

        public void onSuccess(@NotNull File var1, @NotNull PickType var2);
    }
}

