/*
 * Decompiled with CFR 0.152.
 */
package com.lomovskiy.imagepicker;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import androidx.exifinterface.media.ExifInterface;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/lomovskiy/imagepicker/ImageCompressor;", "", "requiredWidth", "", "requiredHeight", "requiredQuality", "compressFormat", "Landroid/graphics/Bitmap$CompressFormat;", "(IIILandroid/graphics/Bitmap$CompressFormat;)V", "calculateInSampleSize", "options", "Landroid/graphics/BitmapFactory$Options;", "compress", "", "photoFile", "Ljava/io/File;", "destinationFile", "decodeScaledBitmapFromFile", "Landroid/graphics/Bitmap;", "library_release"})
public final class ImageCompressor {
    private final int requiredWidth;
    private final int requiredHeight;
    private final int requiredQuality;
    private final Bitmap.CompressFormat compressFormat;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void compress(@NotNull File photoFile, @NotNull File destinationFile) {
        Intrinsics.checkParameterIsNotNull((Object)photoFile, (String)"photoFile");
        Intrinsics.checkParameterIsNotNull((Object)destinationFile, (String)"destinationFile");
        File file = destinationFile;
        boolean bl = false;
        FileOutputStream fos = new FileOutputStream(file);
        try {
            this.decodeScaledBitmapFromFile(photoFile, this.requiredHeight, this.requiredWidth).compress(this.compressFormat, this.requiredQuality, (OutputStream)fos);
        }
        finally {
            fos.flush();
            fos.close();
        }
    }

    private final Bitmap decodeScaledBitmapFromFile(File photoFile, int requiredHeight, int requiredWidth) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)photoFile.getAbsolutePath(), (BitmapFactory.Options)options);
        options.inSampleSize = this.calculateInSampleSize(options, requiredWidth, requiredHeight);
        options.inJustDecodeBounds = false;
        Bitmap bitmap = BitmapFactory.decodeFile((String)photoFile.getAbsolutePath(), (BitmapFactory.Options)options);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"BitmapFactory.decodeFile\u2026le.absolutePath, options)");
        Bitmap scaledBitmap = bitmap;
        ExifInterface exifInterface = new ExifInterface(photoFile.getAbsolutePath());
        int orientation = exifInterface.getAttributeInt("Orientation", 0);
        Matrix matrix = new Matrix();
        switch (orientation) {
            case 6: {
                matrix.postRotate(90.0f);
                break;
            }
            case 3: {
                matrix.postRotate(180.0f);
                break;
            }
            case 8: {
                matrix.postRotate(270.0f);
            }
        }
        Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)scaledBitmap, (int)0, (int)0, (int)scaledBitmap.getWidth(), (int)scaledBitmap.getHeight(), (Matrix)matrix, (boolean)true);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"Bitmap.createBitmap(scal\u2026map.height, matrix, true)");
        scaledBitmap = bitmap2;
        return scaledBitmap;
    }

    private final int calculateInSampleSize(BitmapFactory.Options options, int requiredWidth, int requiredHeight) {
        int bitmapHeight = options.outHeight;
        int bitmapWidth = options.outWidth;
        int inSampleSize = 1;
        if (bitmapHeight > requiredHeight || bitmapWidth > requiredWidth) {
            int halfHeight = bitmapHeight / 2;
            int halfWidth = bitmapWidth / 2;
            while (halfHeight / inSampleSize >= requiredHeight && halfWidth / inSampleSize >= requiredWidth) {
                inSampleSize *= 2;
            }
        }
        return inSampleSize;
    }

    public ImageCompressor(int requiredWidth, int requiredHeight, int requiredQuality, @NotNull Bitmap.CompressFormat compressFormat) {
        Intrinsics.checkParameterIsNotNull((Object)compressFormat, (String)"compressFormat");
        this.requiredWidth = requiredWidth;
        this.requiredHeight = requiredHeight;
        this.requiredQuality = requiredQuality;
        this.compressFormat = compressFormat;
    }
}

