/*
 * Decompiled with CFR 0.152.
 */
package com.loginradius.androidsdk.ui;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.loginradius.androidsdk.ui.RequiredFieldsViewGenerator;
import java.util.ArrayList;

public class CountriesDialog
extends Dialog
implements TextWatcher,
AdapterView.OnItemClickListener {
    private ArrayList<String> countries;
    private EditText etSearch;
    private ListView lvCountries;
    private CountriesAdapter adapter;
    private OnCountrySelectedListener listener;

    public CountriesDialog(@NonNull Context context, ArrayList<String> countries) {
        super(context, 16974130);
        this.countries = new ArrayList<String>(countries);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.init();
    }

    private void init() {
        this.setTitle("Select Country");
        this.setCancelable(true);
        this.setView();
    }

    private void setView() {
        Context context = this.getContext();
        RequiredFieldsViewGenerator gtr = new RequiredFieldsViewGenerator(context, 0);
        LinearLayout layout2 = gtr.generateParentContainerView();
        this.etSearch = gtr.generateEditText("search_country", false);
        this.etSearch.addTextChangedListener((TextWatcher)this);
        this.etSearch.setHint((CharSequence)"Search");
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -1);
        params.setMargins(0, gtr.getPx(5), 0, 0);
        this.lvCountries = new ListView(context);
        this.lvCountries.setLayoutParams((ViewGroup.LayoutParams)params);
        this.lvCountries.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        this.adapter = new CountriesAdapter(context, this.countries);
        this.lvCountries.setAdapter((ListAdapter)this.adapter);
        layout2.addView((View)this.etSearch);
        layout2.addView((View)this.lvCountries);
        this.setContentView((View)layout2);
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
    }

    public void afterTextChanged(Editable s) {
        String search = s.toString().trim().toLowerCase();
        this.adapter.filter(search);
    }

    public void setOnCountrySelectedListener(OnCountrySelectedListener listener) {
        this.listener = listener;
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        if (this.listener != null) {
            this.listener.onCountrySelected((String)this.adapter.getItem(position));
        }
        this.dismiss();
    }

    class CountriesAdapter
    extends ArrayAdapter<String> {
        private ArrayList<String> countries;
        private ArrayList<String> list;

        public CountriesAdapter(@NonNull Context context, ArrayList<String> countries) {
            super(context, 17367043, countries);
            this.countries = countries;
            this.list = new ArrayList();
            this.list.addAll(countries);
        }

        @NonNull
        public View getView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
            TextView textView = (TextView)super.getView(position, convertView, parent);
            textView.setTextColor(-16777216);
            return textView;
        }

        private void filter(String text) {
            text = text.toLowerCase();
            this.countries.clear();
            if (text.length() == 0) {
                this.countries.addAll(this.list);
            } else {
                for (String search : this.list) {
                    if (!search.toLowerCase().contains(text)) continue;
                    this.countries.add(search);
                }
            }
            this.notifyDataSetChanged();
        }
    }

    public static interface OnCountrySelectedListener {
        public void onCountrySelected(String var1);
    }
}

