/*
 * Decompiled with CFR 0.152.
 */
package com.loginradius.androidsdk.handler;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.LinkedHashMap;
import java.util.Map;

public class URLHelper {
    public static String URLBuilder(String baseURL, Map<String, String> parameters) {
        StringBuilder sb = new StringBuilder();
        sb.append(baseURL);
        sb.append('?');
        boolean isFirst = true;
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            if (!isFirst) {
                sb.append('&');
            }
            sb.append(entry.getKey());
            sb.append('=');
            sb.append(entry.getValue());
            isFirst = false;
        }
        return sb.toString();
    }

    public static Map<String, String> splitQuery(URL url) throws UnsupportedEncodingException {
        String[] pairs;
        LinkedHashMap<String, String> query_pairs = new LinkedHashMap<String, String>();
        String query = url.getQuery();
        if (query == null) {
            return query_pairs;
        }
        for (String pair : pairs = query.split("&")) {
            int idx = pair.indexOf("=");
            query_pairs.put(URLDecoder.decode(pair.substring(0, idx), "UTF-8"), URLDecoder.decode(pair.substring(idx + 1), "UTF-8"));
        }
        return query_pairs;
    }
}

