/*
 * Decompiled with CFR 0.152.
 */
package com.loginradius.androidsdk.api;

import com.loginradius.androidsdk.handler.ApiInterface;
import com.loginradius.androidsdk.handler.AsyncHandler;
import com.loginradius.androidsdk.handler.ExceptionResponse;
import com.loginradius.androidsdk.handler.RestRequest;
import com.loginradius.androidsdk.helper.LoginRadiusSDK;
import com.loginradius.androidsdk.resource.QueryMapHelper;
import com.loginradius.androidsdk.resource.QueryParams;
import com.loginradius.androidsdk.response.LoginRadiusContactCursorResponse;
import com.loginradius.androidsdk.response.PostAPIResponse;
import com.loginradius.androidsdk.response.album.LoginRadiusAlbum;
import com.loginradius.androidsdk.response.audio.LoginRadiusAudio;
import com.loginradius.androidsdk.response.checkin.LoginRadiusCheckIn;
import com.loginradius.androidsdk.response.company.LoginRadiusCompany;
import com.loginradius.androidsdk.response.event.LoginRadiusEvent;
import com.loginradius.androidsdk.response.following.LoginRadiusFollowing;
import com.loginradius.androidsdk.response.group.LoginRadiusGroup;
import com.loginradius.androidsdk.response.like.LoginRadiusLike;
import com.loginradius.androidsdk.response.mention.LoginRadiusMention;
import com.loginradius.androidsdk.response.page.LoginRadiusPage;
import com.loginradius.androidsdk.response.photo.LoginRadiusPhoto;
import com.loginradius.androidsdk.response.post.LoginRadiusPost;
import com.loginradius.androidsdk.response.status.LoginRadiusStatus;
import com.loginradius.androidsdk.response.video.LoginRadiusVideo;
import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.observers.DisposableObserver;
import io.reactivex.schedulers.Schedulers;

public class SocialAPI {
    private ApiInterface apiService = (ApiInterface)RestRequest.getClient().create(ApiInterface.class);

    public SocialAPI() {
        if (!LoginRadiusSDK.validate()) {
            throw new LoginRadiusSDK.InitializeException();
        }
    }

    public void updateStatus(QueryParams queryParams, final AsyncHandler<PostAPIResponse> handler) {
        this.apiService.getStatusUpdate("api/v2/status", QueryMapHelper.getMapStatusUpdate(queryParams)).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<PostAPIResponse>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(PostAPIResponse response) {
                handler.onSuccess(response);
            }
        });
    }

    public void postMessage(QueryParams queryParams, final AsyncHandler<PostAPIResponse> handler) {
        this.apiService.getMessage("api/v2/message", QueryMapHelper.getMapMessage(queryParams)).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<PostAPIResponse>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(PostAPIResponse response) {
                handler.onSuccess(response);
            }
        });
    }

    public void getAlbum(QueryParams queryParams, final AsyncHandler<LoginRadiusAlbum[]> handler) {
        this.apiService.getAlbum("api/v2/album", queryParams.getAccess_token()).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<LoginRadiusAlbum[]>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(LoginRadiusAlbum[] response) {
                handler.onSuccess(response);
            }
        });
    }

    public void getAudio(QueryParams queryParams, final AsyncHandler<LoginRadiusAudio[]> handler) {
        this.apiService.getAudio("api/v2/audio", queryParams.getAccess_token()).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<LoginRadiusAudio[]>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(LoginRadiusAudio[] response) {
                handler.onSuccess(response);
            }
        });
    }

    public void getCheckIn(QueryParams queryParams, final AsyncHandler<LoginRadiusCheckIn[]> handler) {
        this.apiService.getCheckin("api/v2/checkin", queryParams.getAccess_token()).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<LoginRadiusCheckIn[]>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(LoginRadiusCheckIn[] response) {
                handler.onSuccess(response);
            }
        });
    }

    public void getCompany(QueryParams queryParams, final AsyncHandler<LoginRadiusCompany[]> handler) {
        this.apiService.getCompany("api/v2/company", queryParams.getAccess_token()).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<LoginRadiusCompany[]>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(LoginRadiusCompany[] response) {
                handler.onSuccess(response);
            }
        });
    }

    public void getContact(QueryParams queryParams, final AsyncHandler<LoginRadiusContactCursorResponse> handler) {
        this.apiService.getContact("api/v2/contact", queryParams.getAccess_token()).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<LoginRadiusContactCursorResponse>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(LoginRadiusContactCursorResponse response) {
                handler.onSuccess(response);
            }
        });
    }

    public void getEvent(QueryParams queryParams, final AsyncHandler<LoginRadiusEvent[]> handler) {
        this.apiService.getEvent("api/v2/event", queryParams.getAccess_token()).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<LoginRadiusEvent[]>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(LoginRadiusEvent[] response) {
                handler.onSuccess(response);
            }
        });
    }

    public void getFollowing(QueryParams queryParams, final AsyncHandler<LoginRadiusFollowing[]> handler) {
        this.apiService.getFollowing("api/v2/following", queryParams.getAccess_token()).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<LoginRadiusFollowing[]>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(LoginRadiusFollowing[] response) {
                handler.onSuccess(response);
            }
        });
    }

    public void getGroup(QueryParams queryParams, final AsyncHandler<LoginRadiusGroup[]> handler) {
        this.apiService.getGroup("api/v2/group", queryParams.getAccess_token()).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<LoginRadiusGroup[]>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(LoginRadiusGroup[] response) {
                handler.onSuccess(response);
            }
        });
    }

    public void getLike(QueryParams queryParams, final AsyncHandler<LoginRadiusLike[]> handler) {
        this.apiService.getLike("api/v2/like", queryParams.getAccess_token()).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<LoginRadiusLike[]>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(LoginRadiusLike[] response) {
                handler.onSuccess(response);
            }
        });
    }

    public void getMention(QueryParams queryParams, final AsyncHandler<LoginRadiusMention[]> handler) {
        this.apiService.getMention("api/v2/mention", queryParams.getAccess_token()).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<LoginRadiusMention[]>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(LoginRadiusMention[] response) {
                handler.onSuccess(response);
            }
        });
    }

    public void getPage(QueryParams queryParams, final AsyncHandler<LoginRadiusPage> handler) {
        this.apiService.getPage("api/v2/page", QueryMapHelper.getMapPage(queryParams)).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<LoginRadiusPage>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(LoginRadiusPage response) {
                handler.onSuccess(response);
            }
        });
    }

    public void getPhoto(QueryParams queryParams, final AsyncHandler<LoginRadiusPhoto[]> handler) {
        this.apiService.getPhoto("api/v2/photo", QueryMapHelper.getMapPhoto(queryParams)).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<LoginRadiusPhoto[]>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(LoginRadiusPhoto[] response) {
                handler.onSuccess(response);
            }
        });
    }

    public void getPost(QueryParams queryParams, final AsyncHandler<LoginRadiusPost[]> handler) {
        this.apiService.getPost("api/v2/post", queryParams.getAccess_token()).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<LoginRadiusPost[]>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(LoginRadiusPost[] response) {
                handler.onSuccess(response);
            }
        });
    }

    public void getStatus(QueryParams queryParams, final AsyncHandler<LoginRadiusStatus[]> handler) {
        this.apiService.getStatus("api/v2/status", queryParams.getAccess_token()).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<LoginRadiusStatus[]>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(LoginRadiusStatus[] response) {
                handler.onSuccess(response);
            }
        });
    }

    public void getVideo(QueryParams queryParams, final AsyncHandler<LoginRadiusVideo[]> handler) {
        this.apiService.getVideo("api/v2/video", queryParams.getAccess_token()).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<LoginRadiusVideo[]>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(LoginRadiusVideo[] response) {
                handler.onSuccess(response);
            }
        });
    }
}

