/*
 * Decompiled with CFR 0.152.
 */
package com.loginradius.androidsdk.api;

import com.google.gson.JsonObject;
import com.loginradius.androidsdk.handler.ApiInterface;
import com.loginradius.androidsdk.handler.AsyncHandler;
import com.loginradius.androidsdk.handler.ExceptionResponse;
import com.loginradius.androidsdk.handler.RestRequest;
import com.loginradius.androidsdk.helper.LoginRadiusSDK;
import com.loginradius.androidsdk.model.OneTouchLoginEmailModel;
import com.loginradius.androidsdk.model.OneTouchLoginPhoneModel;
import com.loginradius.androidsdk.resource.QueryMapHelper;
import com.loginradius.androidsdk.resource.QueryParams;
import com.loginradius.androidsdk.response.VerifyResponse;
import com.loginradius.androidsdk.response.login.LoginData;
import com.loginradius.androidsdk.response.phone.PhoneDataResponse;
import com.loginradius.androidsdk.response.register.RegisterResponse;
import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.observers.DisposableObserver;
import io.reactivex.schedulers.Schedulers;

public class OneTouchLoginAPI {
    ApiInterface apiService = (ApiInterface)RestRequest.getClient().create(ApiInterface.class);

    public OneTouchLoginAPI() {
        if (!LoginRadiusSDK.validate()) {
            throw new LoginRadiusSDK.InitializeException();
        }
    }

    public void loginByEmail(QueryParams queryParams, OneTouchLoginEmailModel payload, final AsyncHandler<RegisterResponse> handler) {
        this.apiService.getOneTouchLoginByEmail("identity/v2/auth/onetouchlogin/email", QueryMapHelper.getMapOneTouchLoginByEmail(queryParams), payload).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<RegisterResponse>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(RegisterResponse response) {
                handler.onSuccess(response);
            }
        });
    }

    public void loginByPhone(QueryParams queryParams, OneTouchLoginPhoneModel payload, final AsyncHandler<PhoneDataResponse> handler) {
        this.apiService.getOneTouchLoginByPhone("identity/v2/auth/onetouchlogin/phone", QueryMapHelper.getMapOneTouchLoginByPhone(queryParams), payload).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<PhoneDataResponse>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(PhoneDataResponse response) {
                handler.onSuccess(response);
            }
        });
    }

    public void oneTouchEmailVerification(QueryParams queryParams, final AsyncHandler<VerifyResponse> handler) {
        this.apiService.getSmartLoginVerifyToken("identity/v2/auth/email/smartlogin", QueryMapHelper.getMapSmartLoginVerifyToken(queryParams)).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<VerifyResponse>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(VerifyResponse value) {
                handler.onSuccess(value);
            }
        });
    }

    public void oneTouchLoginPing(QueryParams queryParams, final AsyncHandler<LoginData> handler) {
        this.apiService.getSmartLoginPing("identity/v2/auth/login/smartlogin/ping", QueryMapHelper.getMapSmartLoginPing(queryParams)).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<LoginData>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(LoginData response) {
                handler.onSuccess(response);
            }
        });
    }

    public void verifyOTP(QueryParams queryParams, JsonObject json, final AsyncHandler<LoginData> handler) {
        this.apiService.getOneTouchLoginVerifyOtp("identity/v2/auth/onetouchlogin/phone/verify", QueryMapHelper.getMapOneTouchLoginVerifyOTP(queryParams), json).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<LoginData>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(LoginData response) {
                handler.onSuccess(response);
            }
        });
    }
}

