/*
 * Decompiled with CFR 0.152.
 */
package com.loginradius.androidsdk.helper;

import android.accounts.Account;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import com.google.android.gms.auth.GoogleAuthUtil;
import com.google.android.gms.auth.UserRecoverableAuthException;
import com.google.android.gms.auth.api.Auth;
import com.google.android.gms.auth.api.signin.GoogleSignIn;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.GoogleSignInClient;
import com.google.android.gms.auth.api.signin.GoogleSignInOptions;
import com.google.android.gms.auth.api.signin.GoogleSignInResult;
import com.google.android.gms.common.api.Scope;
import com.loginradius.androidsdk.handler.AsyncHandler;
import com.loginradius.androidsdk.helper.LoginRadiusAuthManager;
import com.loginradius.androidsdk.helper.LoginRadiusSDK;
import com.loginradius.androidsdk.helper.ProviderPermissions;
import com.loginradius.androidsdk.response.AccessTokenResponse;

@SuppressLint(value={"InlinedApi"})
public class GoogleSSO
extends Activity {
    private static final int ACCOUNT_CODE = 1601;
    static final int REQUEST_AUTHORIZATION = 2;
    private GoogleSignInClient mGoogleSignInClient;
    private String googleServerClientID = LoginRadiusSDK.getGoogleServerClientID();

    @SuppressLint(value={"NewApi"})
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState == null) {
            GoogleSignInOptions gso = null;
            if (this.googleServerClientID == null) {
                if (LoginRadiusSDK.getGoogleScopes().length == 1) {
                    gso = new GoogleSignInOptions.Builder(GoogleSignInOptions.DEFAULT_SIGN_IN).requestEmail().requestProfile().requestScopes(LoginRadiusSDK.getGoogleScopes()[0], new Scope[0]).build();
                } else if (LoginRadiusSDK.getGoogleScopes().length > 1) {
                    gso = new GoogleSignInOptions.Builder(GoogleSignInOptions.DEFAULT_SIGN_IN).requestEmail().requestProfile().requestScopes(LoginRadiusSDK.getGoogleScopes()[0], LoginRadiusSDK.getGoogleScopes()).build();
                }
            } else if (this.googleServerClientID != null) {
                if (LoginRadiusSDK.getGoogleScopes().length == 1) {
                    gso = new GoogleSignInOptions.Builder(GoogleSignInOptions.DEFAULT_SIGN_IN).requestEmail().requestProfile().requestServerAuthCode(this.googleServerClientID, true).requestScopes(LoginRadiusSDK.getGoogleScopes()[0], new Scope[0]).build();
                } else if (LoginRadiusSDK.getGoogleScopes().length > 1) {
                    gso = new GoogleSignInOptions.Builder(GoogleSignInOptions.DEFAULT_SIGN_IN).requestEmail().requestProfile().requestServerAuthCode(this.googleServerClientID, true).requestScopes(LoginRadiusSDK.getGoogleScopes()[0], LoginRadiusSDK.getGoogleScopes()).build();
                }
            }
            this.mGoogleSignInClient = GoogleSignIn.getClient((Activity)this, gso);
            this.mGoogleSignInClient.signOut();
            this.SignIn();
        }
    }

    private void requestToken(final Account accountName) {
        final Context context = this.getApplicationContext();
        AsyncTask task = new AsyncTask(){

            protected Object doInBackground(Object ... params) {
                String token = null;
                try {
                    token = GoogleAuthUtil.getToken((Context)context, (Account)accountName, (String)ProviderPermissions.SCOPES);
                }
                catch (UserRecoverableAuthException e) {
                    this.cancel(true);
                    GoogleSSO.this.handleRecoverableerror(e);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return token;
            }

            protected void onPostExecute(Object token) {
                GoogleSSO.this.executeForResult((String)token, false);
                GoogleSSO.this.finish();
            }
        };
        task.execute(new Object[]{null});
    }

    private void handleRecoverableerror(UserRecoverableAuthException u) {
        this.startActivityForResult(u.getIntent(), 2);
    }

    private void executeForResult(String token, boolean offline) {
        LoginRadiusAuthManager.getResponseGoogle(token, offline, new AsyncHandler<AccessTokenResponse>(){

            @Override
            public void onSuccess(AccessTokenResponse data) {
                data.provider = "google";
                LoginRadiusAuthManager.asyncHandler.onSuccess(data);
            }

            @Override
            public void onFailure(Throwable error, String response) {
                LoginRadiusAuthManager.asyncHandler.onFailure(error, response);
            }
        });
    }

    private void SignIn() {
        Intent signInIntent = this.mGoogleSignInClient.getSignInIntent();
        this.startActivityForResult(signInIntent, 1601);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 1601 && resultCode == -1) {
            GoogleSignInResult result = Auth.GoogleSignInApi.getSignInResultFromIntent(data);
            GoogleSignInAccount acct = result.getSignInAccount();
            if (this.googleServerClientID == null && result.isSuccess()) {
                this.requestToken(acct.getAccount());
            } else if (this.googleServerClientID != null && result.isSuccess()) {
                this.executeForResult(acct.getServerAuthCode(), true);
                this.finish();
            }
        } else if (resultCode == 0) {
            LoginRadiusAuthManager.asyncHandler.onFailure(new Throwable("GoogleSSO cancelled"), "lr_LOGIN_CANCELLED");
            this.finish();
        } else if (requestCode == 2) {
            Bundle b = data.getExtras();
            String token = b.getString("authtoken");
            this.executeForResult(token, false);
            this.finish();
        }
    }
}

