/*
 * Decompiled with CFR 0.152.
 */
package com.loginradius.androidsdk.activity;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.MenuItem;
import android.view.View;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import com.google.gson.JsonObject;
import com.google.gson.internal.LinkedTreeMap;
import com.loginradius.androidsdk.R;
import com.loginradius.androidsdk.api.AuthenticationAPI;
import com.loginradius.androidsdk.api.ConfigurationAPI;
import com.loginradius.androidsdk.handler.AsyncHandler;
import com.loginradius.androidsdk.handler.JsonDeserializer;
import com.loginradius.androidsdk.handler.URLHelper;
import com.loginradius.androidsdk.helper.ErrorResponse;
import com.loginradius.androidsdk.helper.LoginRadiusSDK;
import com.loginradius.androidsdk.resource.QueryParams;
import com.loginradius.androidsdk.response.AccessTokenResponse;
import com.loginradius.androidsdk.response.UpdateProfileResponse;
import com.loginradius.androidsdk.response.config.ConfigResponse;
import com.loginradius.androidsdk.response.login.LoginData;
import com.loginradius.androidsdk.response.register.RegisterResponse;
import com.loginradius.androidsdk.response.traditionalinterface.UserRegistration;
import com.loginradius.androidsdk.response.userprofile.LoginRadiusUltimateUserProfile;
import com.loginradius.androidsdk.ui.FieldViewUtil;
import com.loginradius.androidsdk.ui.RequiredFieldsViewGenerator;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.schedulers.Schedulers;
import java.util.LinkedHashMap;
import java.util.List;

public class WebViewActivity
extends AppCompatActivity {
    private WebView webView;
    String provider;
    String spinview;
    String encodedURL;
    int fieldsColor;
    boolean isTwitterCancel = false;
    boolean isRequired;
    boolean promptPassword;
    boolean reloadOnError;
    boolean askOptionalOnSocialLogin;
    boolean customScopeEnabled;
    List<UserRegistration> raasSchemaList;
    AccessTokenResponse accessToken;
    RequiredFieldsViewGenerator gtr;
    FieldViewUtil fieldUtil;
    Context context;
    LoginRadiusUltimateUserProfile userProfile;
    String TAG = ((Object)((Object)this)).getClass().getSimpleName();

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_web_view);
        if (!LoginRadiusSDK.validate()) {
            throw new LoginRadiusSDK.InitializeException();
        }
        this.spinview = "false";
        this.webView = (WebView)this.findViewById(R.id.webView1);
        this.context = this.webView.getContext();
        Intent i = this.getIntent();
        this.provider = i.getStringExtra("provider");
        this.isRequired = i.getBooleanExtra("isRequired", true);
        this.fieldsColor = i.getIntExtra("fieldsColor", 0);
        this.reloadOnError = i.getBooleanExtra("reloadOnError", false);
        this.customScopeEnabled = i.getBooleanExtra("customScopeEnabled", false);
        String sitebuilder = "https://" + LoginRadiusSDK.getSiteName();
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("apikey", LoginRadiusSDK.getApiKey());
        params.put("provider", this.provider.toLowerCase());
        params.put("is_access_token", "true");
        params.put("ismobile", "true");
        params.put("is_custom_scope", String.valueOf(this.customScopeEnabled));
        this.encodedURL = sitebuilder + URLHelper.URLBuilder(".hub.loginradius.com/RequestHandlor.aspx", params);
        if (i != null) {
            this.startWebView(this.encodedURL);
        }
    }

    private void startWebView(String url) {
        this.webView.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                if (url.contains("?token")) {
                    Uri uri = Uri.parse((String)url);
                    String Token = uri.getQueryParameter("token");
                    if (Token != null) {
                        String[] temp = Token.split("#");
                        Token = temp[0];
                        WebViewActivity.this.accessToken = new AccessTokenResponse();
                        WebViewActivity.this.accessToken.access_token = Token;
                        WebViewActivity.this.accessToken.provider = WebViewActivity.this.provider;
                        if (WebViewActivity.this.isRequired) {
                            WebViewActivity.this.getRaasSchema();
                        } else {
                            WebViewActivity.this.sendAccessToken(WebViewActivity.this.accessToken);
                        }
                    }
                } else if (url.contains("error=access_denied")) {
                    WebViewActivity.this.finish();
                } else if (url.contains("/socialauth/validate.sauth?denied")) {
                    WebViewActivity.this.finish();
                } else if (url.contains("error=server_error") && WebViewActivity.this.provider.equals("linkedin")) {
                    if (WebViewActivity.this.reloadOnError) {
                        Toast.makeText((Context)WebViewActivity.this.context, (CharSequence)"Your email contains a white space character, please try again with a proper email", (int)0).show();
                        WebViewActivity.this.startWebView(WebViewActivity.this.encodedURL);
                    } else {
                        Intent intent = new Intent();
                        intent.putExtra("error", WebViewActivity.this.getLrError().toString());
                        WebViewActivity.this.setResult(2, intent);
                        WebViewActivity.this.finish();
                    }
                } else {
                    view.loadUrl(url);
                }
                return true;
            }

            public void onPageFinished(WebView view, String url) {
                WebViewActivity.this.isTwitterCancel = false;
                if (url.startsWith("https://api.twitter.com/oauth") && !url.contains("oauth_token")) {
                    WebViewActivity.this.isTwitterCancel = true;
                    WebViewActivity.this.onTwitterFinesh();
                } else {
                    super.onPageFinished(view, url);
                }
            }
        });
        this.webView.getSettings().setJavaScriptEnabled(true);
        this.webView.loadUrl(url);
    }

    private void getRaasSchema() {
        this.gtr = new RequiredFieldsViewGenerator((Context)this, this.fieldsColor);
        this.setContentView((View)this.gtr.generateProgressBar());
        ConfigurationAPI api = new ConfigurationAPI();
        api.getResponse(new AsyncHandler<ConfigResponse>(){

            @Override
            public void onSuccess(ConfigResponse data) {
                WebViewActivity.this.raasSchemaList = data.getRegistrationFormSchema();
                WebViewActivity.this.promptPassword = data.getAskPasswordOnSocialLogin();
                WebViewActivity.this.askOptionalOnSocialLogin = data.getAskOptionalFieldsOnSocialSignup();
                WebViewActivity.this.validateRaasSchema();
            }

            @Override
            public void onFailure(Throwable error, String errorcode) {
                Log.i((String)"lr_api_error", (String)error.getMessage());
                WebViewActivity.this.sendAccessToken(null);
            }
        });
    }

    private void validateRaasSchema() {
        boolean containsRequired = false;
        for (int i = 0; i < this.raasSchemaList.size(); ++i) {
            if (!this.raasSchemaList.get(i).getRules().contains("required") || containsRequired) continue;
            containsRequired = true;
        }
        if (containsRequired) {
            this.getUserProfile();
        } else {
            this.sendAccessToken(this.accessToken);
        }
    }

    private void getUserProfile() {
        AuthenticationAPI api = new AuthenticationAPI();
        QueryParams queryParams = new QueryParams();
        queryParams.setAccess_token(this.accessToken.access_token);
        api.readAllUserProfile(queryParams, new AsyncHandler<LoginRadiusUltimateUserProfile>(){

            @Override
            public void onSuccess(LoginRadiusUltimateUserProfile data) {
                WebViewActivity.this.userProfile = data;
                WebViewActivity.this.setRequiredFieldsView();
            }

            @Override
            public void onFailure(Throwable error, String errorcode) {
                Log.i((String)"lr_api_error", (String)error.getMessage());
                WebViewActivity.this.sendAccessToken(null);
            }
        });
    }

    private void setRequiredFieldsView() {
        Observable observable = Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<ScrollView>(){

            public void subscribe(ObservableEmitter<ScrollView> e) throws Exception {
                e.onNext((Object)WebViewActivity.this.getFieldsView());
                e.onComplete();
            }
        }).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread());
        Observer<ScrollView> observer = new Observer<ScrollView>(){

            public void onSubscribe(Disposable d) {
            }

            public void onNext(ScrollView value) {
                if (value.getChildCount() > 0) {
                    WebViewActivity.this.setContentView((View)value);
                } else {
                    WebViewActivity.this.sendAccessToken(WebViewActivity.this.accessToken);
                }
            }

            public void onError(Throwable e) {
                Log.i((String)"lr_api_error", (String)e.getMessage());
            }

            public void onComplete() {
            }
        };
        observable.subscribe((Observer)observer);
    }

    private ScrollView getFieldsView() {
        this.fieldUtil = new FieldViewUtil();
        boolean isRequiredAdded = false;
        ScrollView svParent = this.gtr.generateParentView();
        final LinearLayout linearContainer = this.gtr.generateParentContainerView();
        svParent.addView((View)linearContainer);
        LinkedTreeMap customFields = null;
        if (this.userProfile.getCustomFields() != null) {
            customFields = (LinkedTreeMap)this.userProfile.getCustomFields();
        }
        TextView tvLabel = this.gtr.generateLabelTextView("Please fill the required fields to continue");
        tvLabel.setGravity(1);
        linearContainer.addView((View)tvLabel);
        for (int i = 0; i < this.raasSchemaList.size(); ++i) {
            UserRegistration userField = this.raasSchemaList.get(i);
            if (userField.getRules() == null) continue;
            if (userField.getRules().contains("required") && !isRequiredAdded) {
                isRequiredAdded = this.fieldUtil.addFieldView(this.gtr, this.userProfile, userField, linearContainer, customFields, this.promptPassword);
                continue;
            }
            this.fieldUtil.addFieldView(this.gtr, this.userProfile, userField, linearContainer, customFields, this.promptPassword);
        }
        if (isRequiredAdded || this.askOptionalOnSocialLogin && this.userProfile.getNoOfLogins() == 1) {
            Button submitButton = this.gtr.generateSubmitButton("Register");
            submitButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    Observable observable = Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe(){

                        public void subscribe(ObservableEmitter e) throws Exception {
                            WebViewActivity.this.startUpdateProcess(linearContainer);
                        }
                    });
                    observable.subscribe();
                }
            });
            linearContainer.addView((View)submitButton);
            return svParent;
        }
        return this.gtr.generateParentView();
    }

    private void startUpdateProcess(LinearLayout linearContainer) {
        Log.i((String)"AccessToken", (String)this.accessToken.access_token);
        if (this.fieldUtil.validateFields(this.gtr, linearContainer)) {
            this.setContentView((View)this.gtr.generateProgressBar());
            AuthenticationAPI api = new AuthenticationAPI();
            QueryParams queryParams = new QueryParams();
            queryParams.setAccess_token(this.accessToken.access_token);
            JsonObject jsonData = this.fieldUtil.getData(this.gtr, linearContainer);
            api.updateProfile(queryParams, jsonData, new AsyncHandler<UpdateProfileResponse>(){

                @Override
                public void onSuccess(UpdateProfileResponse data) {
                    if (WebViewActivity.this.fieldUtil.getPhone() != null) {
                        WebViewActivity.this.showMobileInfoDialog();
                        return;
                    }
                    if (WebViewActivity.this.fieldUtil.getEmail() != null) {
                        WebViewActivity.this.showEmailInfoDialog();
                        return;
                    }
                    WebViewActivity.this.sendAccessToken(WebViewActivity.this.accessToken);
                }

                @Override
                public void onFailure(Throwable error, String errorcode) {
                    ErrorResponse errorResponse = JsonDeserializer.deserializeJson(error.getMessage(), ErrorResponse.class);
                    int errorCode = errorResponse.getErrorCode();
                    Log.i((String)"ErrorCode", (String)String.valueOf(errorCode));
                    switch (errorCode) {
                        case 936: {
                            Toast.makeText((Context)WebViewActivity.this.context, (CharSequence)"Email already exists", (int)0).show();
                            WebViewActivity.this.setRequiredFieldsView();
                            break;
                        }
                        case 1058: {
                            Toast.makeText((Context)WebViewActivity.this.context, (CharSequence)"Mobile number already exists", (int)0).show();
                            WebViewActivity.this.setRequiredFieldsView();
                            break;
                        }
                        case 970: {
                            WebViewActivity.this.showEmailInfoDialog();
                            break;
                        }
                        case 1066: {
                            WebViewActivity.this.showMobileInfoDialog();
                            break;
                        }
                        default: {
                            Toast.makeText((Context)WebViewActivity.this.context, (CharSequence)"Unable to complete the request at the moment", (int)0).show();
                            WebViewActivity.this.setRequiredFieldsView();
                        }
                    }
                }
            });
        }
    }

    private void showMobileInfoDialog() {
        AlertDialog.Builder alert = new AlertDialog.Builder((Context)this);
        alert.setTitle((CharSequence)"Message");
        alert.setMessage((CharSequence)"We've sent an OTP on your mobile number. Please verify your mobile number to login.");
        alert.setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                WebViewActivity.this.setOTPView();
            }
        });
        AlertDialog dialog = alert.create();
        dialog.setCancelable(false);
        dialog.show();
    }

    private void setOTPView() {
        RelativeLayout view = this.gtr.generateOTPLayout();
        Button btnSubmit = (Button)view.findViewWithTag((Object)"submit");
        Button btnResend = (Button)view.findViewWithTag((Object)"resend_otp");
        final EditText etOTP = (EditText)view.findViewWithTag((Object)"otp");
        btnSubmit.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String otp = etOTP.getText().toString().trim();
                if (otp.length() == 0) {
                    etOTP.setError((CharSequence)"Required");
                    etOTP.setBackgroundResource(R.drawable.red_border);
                } else {
                    WebViewActivity.this.submitOTP(otp);
                }
            }
        });
        btnResend.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                WebViewActivity.this.resendOTP();
            }
        });
        this.setContentView((View)view);
    }

    private void resendOTP() {
        this.setContentView((View)this.gtr.generateProgressBar());
        AuthenticationAPI api = new AuthenticationAPI();
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("Phone", this.fieldUtil.getPhone());
        api.resendOtp(null, jsonObject, new AsyncHandler<RegisterResponse>(){

            @Override
            public void onSuccess(RegisterResponse data) {
                Toast.makeText((Context)WebViewActivity.this.context, (CharSequence)"OTP sent to your mobile number", (int)0).show();
                WebViewActivity.this.setOTPView();
            }

            @Override
            public void onFailure(Throwable error, String errorcode) {
                ErrorResponse errorResponse = JsonDeserializer.deserializeJson(error.getMessage(), ErrorResponse.class);
                int errorCode = errorResponse.getErrorCode();
                Log.i((String)"ErrorCode", (String)String.valueOf(errorCode));
                Toast.makeText((Context)WebViewActivity.this.context, (CharSequence)"Unable to complete the request at the moment", (int)0).show();
                WebViewActivity.this.setOTPView();
            }
        });
    }

    private void submitOTP(String otp) {
        this.setContentView((View)this.gtr.generateProgressBar());
        AuthenticationAPI api = new AuthenticationAPI();
        QueryParams queryParams = new QueryParams();
        queryParams.setOtp(otp);
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("Phone", this.fieldUtil.getPhone());
        api.verifyOtp(queryParams, jsonObject, new AsyncHandler<LoginData>(){

            @Override
            public void onSuccess(LoginData data) {
                AccessTokenResponse accessToken = new AccessTokenResponse();
                accessToken.setAccess_token(data.getAccessToken());
                accessToken.setProvider(WebViewActivity.this.provider);
                WebViewActivity.this.sendAccessToken(accessToken);
            }

            @Override
            public void onFailure(Throwable error, String errorcode) {
                ErrorResponse errorResponse = JsonDeserializer.deserializeJson(error.getMessage(), ErrorResponse.class);
                int errorCode = errorResponse.getErrorCode();
                Log.i((String)"ErrorCode", (String)String.valueOf(errorCode));
                if (errorCode == 1067) {
                    Toast.makeText((Context)WebViewActivity.this.context, (CharSequence)"OTP is not correct. Please try again", (int)0).show();
                } else {
                    Toast.makeText((Context)WebViewActivity.this.context, (CharSequence)"Unable to complete the request at the moment", (int)0).show();
                }
                WebViewActivity.this.setOTPView();
            }
        });
    }

    private void showEmailInfoDialog() {
        AlertDialog.Builder alert = new AlertDialog.Builder((Context)this);
        alert.setTitle((CharSequence)"Message");
        alert.setMessage((CharSequence)"We've sent a verification mail on your email address. Please verify your email address to login.");
        alert.setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                WebViewActivity.this.sendAccessToken(null);
            }
        });
        AlertDialog dialog = alert.create();
        dialog.setCancelable(false);
        dialog.show();
    }

    public void onTwitterFinesh() {
        Handler handler = new Handler();
        handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (WebViewActivity.this.isTwitterCancel) {
                    WebViewActivity.this.finish();
                }
            }
        }, 3000L);
    }

    public void onBackPressed() {
        super.onBackPressed();
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.finish();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    private JsonObject getLrError() {
        JsonObject object = new JsonObject();
        object.addProperty("description", "The error occurred at social provider's end. It may occur when the credentials contain white space");
        object.addProperty("errorCode", "1000");
        object.addProperty("message", "An error has occurred at the social identity provider\u2019s end");
        object.addProperty("isProviderError", Boolean.valueOf(true));
        object.addProperty("providerErrorResponse", "linkedin is experiencing an unexpected error at this moment. Please try again in a few minutes");
        return object;
    }

    public void sendAccessToken(AccessTokenResponse accessToken) {
        Intent intent = new Intent();
        if (accessToken != null) {
            intent.putExtra("accesstoken", accessToken.access_token);
            intent.putExtra("provider", accessToken.provider);
        }
        this.setResult(2, intent);
        this.finish();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 2 && data != null) {
            String token = data.getStringExtra("accesstoken");
            String provider = data.getStringExtra("provider");
            Intent intent = new Intent();
            intent.putExtra("accesstoken", token);
            intent.putExtra("provider", provider);
            this.setResult(2, intent);
            this.finish();
        }
    }
}

