/*
 * Decompiled with CFR 0.152.
 */
package com.loginradius.androidsdk.activity;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import com.facebook.CallbackManager;
import com.google.gson.JsonObject;
import com.google.gson.internal.LinkedTreeMap;
import com.loginradius.androidsdk.R;
import com.loginradius.androidsdk.api.AuthenticationAPI;
import com.loginradius.androidsdk.api.ConfigurationAPI;
import com.loginradius.androidsdk.handler.AsyncHandler;
import com.loginradius.androidsdk.handler.JsonDeserializer;
import com.loginradius.androidsdk.helper.ErrorResponse;
import com.loginradius.androidsdk.helper.LoginRadiusAuthManager;
import com.loginradius.androidsdk.helper.LoginRadiusSDK;
import com.loginradius.androidsdk.helper.ProviderPermissions;
import com.loginradius.androidsdk.resource.QueryParams;
import com.loginradius.androidsdk.response.AccessTokenResponse;
import com.loginradius.androidsdk.response.UpdateProfileResponse;
import com.loginradius.androidsdk.response.config.ConfigResponse;
import com.loginradius.androidsdk.response.login.LoginData;
import com.loginradius.androidsdk.response.register.RegisterResponse;
import com.loginradius.androidsdk.response.socialinterface.Provider;
import com.loginradius.androidsdk.response.traditionalinterface.UserRegistration;
import com.loginradius.androidsdk.response.userprofile.LoginRadiusUltimateUserProfile;
import com.loginradius.androidsdk.ui.FieldViewUtil;
import com.loginradius.androidsdk.ui.RequiredFieldsViewGenerator;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.schedulers.Schedulers;
import java.util.List;

public class GoogleNativeActivity
extends AppCompatActivity {
    CallbackManager callManager;
    ProgressBar bar;
    private List<Provider> providers;
    private static final String LOG_TAG = "CheckNetworkStatus";
    private NetworkChangeReceiver receiver;
    private boolean isConnected = false;
    private AccessTokenResponse accessToken;
    private boolean isRequired;
    private boolean promptPassword;
    private boolean askOptionalOnSocialLogin;
    private int fieldsColor;
    RequiredFieldsViewGenerator gtr;
    FieldViewUtil fieldUtil;
    Context context;
    List<UserRegistration> raasSchemaList;
    LoginRadiusUltimateUserProfile userProfile;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_google_native);
        if (!LoginRadiusSDK.validate()) {
            throw new LoginRadiusSDK.InitializeException();
        }
        IntentFilter filter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        this.receiver = new NetworkChangeReceiver();
        this.registerReceiver(this.receiver, filter);
        this.bar = (ProgressBar)this.findViewById(R.id.progressBar);
        this.bar.setVisibility(0);
        LoginRadiusAuthManager.nativeLogin = true;
        Intent i = this.getIntent();
        this.isRequired = i.getBooleanExtra("isRequired", true);
        this.fieldsColor = i.getIntExtra("fieldsColor", 0);
        this.context = this;
        ProviderPermissions.resetPermissions();
        LoginRadiusAuthManager.setCallbackManager(LoginRadiusSDK.getApiKey(), null);
        this.showdialog();
    }

    protected void onDestroy() {
        Log.v((String)LOG_TAG, (String)"onDestory");
        super.onDestroy();
        this.unregisterReceiver(this.receiver);
    }

    public void showdialog() {
        Provider provider = new Provider();
        provider.setName("google");
        LoginRadiusAuthManager.performLogin((Activity)this, provider, new AsyncHandler<AccessTokenResponse>(){

            @Override
            public void onSuccess(AccessTokenResponse data) {
                GoogleNativeActivity.this.accessToken = data;
                ((GoogleNativeActivity)GoogleNativeActivity.this).accessToken.provider = "google";
                if (GoogleNativeActivity.this.isRequired) {
                    GoogleNativeActivity.this.getRaasSchema();
                } else {
                    GoogleNativeActivity.this.sendAccessToken(data.access_token, data.refresh_token);
                }
            }

            @Override
            public void onFailure(Throwable error, String errorcode) {
                if (errorcode.toString().equals("lr_LOGIN_CANCELLED")) {
                    GoogleNativeActivity.this.finish();
                }
            }
        });
    }

    private void getRaasSchema() {
        this.gtr = new RequiredFieldsViewGenerator(this.context, this.fieldsColor);
        this.setContentView((View)this.gtr.generateProgressBar());
        ConfigurationAPI api = new ConfigurationAPI();
        api.getResponse(new AsyncHandler<ConfigResponse>(){

            @Override
            public void onSuccess(ConfigResponse data) {
                GoogleNativeActivity.this.raasSchemaList = data.getRegistrationFormSchema();
                GoogleNativeActivity.this.promptPassword = data.getAskPasswordOnSocialLogin();
                GoogleNativeActivity.this.askOptionalOnSocialLogin = data.getAskOptionalFieldsOnSocialSignup();
                GoogleNativeActivity.this.validateRaasSchema();
            }

            @Override
            public void onFailure(Throwable error, String errorcode) {
                Log.i((String)"lr_api_error", (String)error.getMessage());
                GoogleNativeActivity.this.sendAccessToken(null, null);
            }
        });
    }

    private void validateRaasSchema() {
        boolean containsRequired = false;
        for (int i = 0; i < this.raasSchemaList.size(); ++i) {
            if (!this.raasSchemaList.get(i).getRules().contains("required") || containsRequired) continue;
            containsRequired = true;
        }
        if (containsRequired) {
            this.getUserProfile();
        } else {
            this.sendAccessToken(this.accessToken.access_token, this.accessToken.refresh_token);
        }
    }

    private void getUserProfile() {
        AuthenticationAPI api = new AuthenticationAPI();
        QueryParams queryParams = new QueryParams();
        queryParams.setAccess_token(this.accessToken.access_token);
        api.readAllUserProfile(queryParams, new AsyncHandler<LoginRadiusUltimateUserProfile>(){

            @Override
            public void onSuccess(LoginRadiusUltimateUserProfile data) {
                GoogleNativeActivity.this.userProfile = data;
                GoogleNativeActivity.this.setRequiredFieldsView();
            }

            @Override
            public void onFailure(Throwable error, String errorcode) {
                Log.i((String)"lr_api_error", (String)error.getMessage());
                GoogleNativeActivity.this.sendAccessToken(null, null);
            }
        });
    }

    private void setRequiredFieldsView() {
        Observable observable = Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<ScrollView>(){

            public void subscribe(ObservableEmitter<ScrollView> e) throws Exception {
                e.onNext((Object)GoogleNativeActivity.this.getFieldsView());
                e.onComplete();
            }
        }).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread());
        Observer<ScrollView> observer = new Observer<ScrollView>(){

            public void onSubscribe(Disposable d) {
            }

            public void onNext(ScrollView value) {
                if (value.getChildCount() > 0) {
                    GoogleNativeActivity.this.setContentView((View)value);
                } else {
                    GoogleNativeActivity.this.sendAccessToken(((GoogleNativeActivity)GoogleNativeActivity.this).accessToken.access_token, ((GoogleNativeActivity)GoogleNativeActivity.this).accessToken.refresh_token);
                }
            }

            public void onError(Throwable e) {
                Log.i((String)"lr_api_error", (String)e.getMessage());
            }

            public void onComplete() {
            }
        };
        observable.subscribe((Observer)observer);
    }

    private ScrollView getFieldsView() {
        this.fieldUtil = new FieldViewUtil();
        boolean isRequiredAdded = false;
        ScrollView svParent = this.gtr.generateParentView();
        final LinearLayout linearContainer = this.gtr.generateParentContainerView();
        svParent.addView((View)linearContainer);
        LinkedTreeMap customFields = null;
        if (this.userProfile.getCustomFields() != null) {
            customFields = (LinkedTreeMap)this.userProfile.getCustomFields();
        }
        TextView tvLabel = this.gtr.generateLabelTextView("Please fill the required fields to continue");
        tvLabel.setGravity(1);
        linearContainer.addView((View)tvLabel);
        for (int i = 0; i < this.raasSchemaList.size(); ++i) {
            UserRegistration userField = this.raasSchemaList.get(i);
            if (userField.getRules() == null) continue;
            if (userField.getRules().contains("required") && !isRequiredAdded) {
                isRequiredAdded = this.fieldUtil.addFieldView(this.gtr, this.userProfile, userField, linearContainer, customFields, this.promptPassword);
                continue;
            }
            this.fieldUtil.addFieldView(this.gtr, this.userProfile, userField, linearContainer, customFields, this.promptPassword);
        }
        if (isRequiredAdded || this.askOptionalOnSocialLogin && this.userProfile.getNoOfLogins() == 1) {
            Button submitButton = this.gtr.generateSubmitButton("Register");
            submitButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    Observable observable = Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe(){

                        public void subscribe(ObservableEmitter e) throws Exception {
                            GoogleNativeActivity.this.startUpdateProcess(linearContainer);
                        }
                    });
                    observable.subscribe();
                }
            });
            linearContainer.addView((View)submitButton);
            return svParent;
        }
        return this.gtr.generateParentView();
    }

    private void startUpdateProcess(LinearLayout linearContainer) {
        Log.i((String)"AccessToken", (String)this.accessToken.access_token);
        if (this.fieldUtil.validateFields(this.gtr, linearContainer)) {
            this.setContentView((View)this.gtr.generateProgressBar());
            AuthenticationAPI api = new AuthenticationAPI();
            QueryParams queryParams = new QueryParams();
            queryParams.setAccess_token(this.accessToken.access_token);
            JsonObject jsonData = this.fieldUtil.getData(this.gtr, linearContainer);
            api.updateProfile(queryParams, jsonData, new AsyncHandler<UpdateProfileResponse>(){

                @Override
                public void onSuccess(UpdateProfileResponse data) {
                    if (GoogleNativeActivity.this.fieldUtil.getPhone() != null) {
                        GoogleNativeActivity.this.showMobileInfoDialog();
                        return;
                    }
                    if (GoogleNativeActivity.this.fieldUtil.getEmail() != null) {
                        GoogleNativeActivity.this.showEmailInfoDialog();
                        return;
                    }
                    GoogleNativeActivity.this.sendAccessToken(((GoogleNativeActivity)GoogleNativeActivity.this).accessToken.access_token, ((GoogleNativeActivity)GoogleNativeActivity.this).accessToken.refresh_token);
                }

                @Override
                public void onFailure(Throwable error, String errorcode) {
                    ErrorResponse errorResponse = JsonDeserializer.deserializeJson(error.getMessage(), ErrorResponse.class);
                    int errorCode = errorResponse.getErrorCode();
                    Log.i((String)"ErrorCode", (String)String.valueOf(errorCode));
                    switch (errorCode) {
                        case 936: {
                            Toast.makeText((Context)GoogleNativeActivity.this.context, (CharSequence)"Email already exists", (int)0).show();
                            GoogleNativeActivity.this.setRequiredFieldsView();
                            break;
                        }
                        case 1058: {
                            Toast.makeText((Context)GoogleNativeActivity.this.context, (CharSequence)"Mobile number already exists", (int)0).show();
                            GoogleNativeActivity.this.setRequiredFieldsView();
                            break;
                        }
                        case 970: {
                            GoogleNativeActivity.this.showEmailInfoDialog();
                            break;
                        }
                        case 1066: {
                            GoogleNativeActivity.this.showMobileInfoDialog();
                            break;
                        }
                        default: {
                            Toast.makeText((Context)GoogleNativeActivity.this.context, (CharSequence)"Unable to complete the request at the moment", (int)0).show();
                            GoogleNativeActivity.this.setRequiredFieldsView();
                        }
                    }
                }
            });
        }
    }

    private void showEmailInfoDialog() {
        AlertDialog.Builder alert = new AlertDialog.Builder(this.context);
        alert.setTitle((CharSequence)"Message");
        alert.setMessage((CharSequence)"We've sent a verification mail on your email address. Please verify your email address to login.");
        alert.setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                GoogleNativeActivity.this.sendAccessToken(null, null);
            }
        });
        AlertDialog dialog = alert.create();
        dialog.setCancelable(false);
        dialog.show();
    }

    private void showMobileInfoDialog() {
        AlertDialog.Builder alert = new AlertDialog.Builder(this.context);
        alert.setTitle((CharSequence)"Message");
        alert.setMessage((CharSequence)"We've sent an OTP on your mobile number. Please verify your mobile number to login.");
        alert.setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                GoogleNativeActivity.this.setOTPView();
            }
        });
        AlertDialog dialog = alert.create();
        dialog.setCancelable(false);
        dialog.show();
    }

    private void setOTPView() {
        RelativeLayout view = this.gtr.generateOTPLayout();
        Button btnSubmit = (Button)view.findViewWithTag((Object)"submit");
        Button btnResend = (Button)view.findViewWithTag((Object)"resend_otp");
        final EditText etOTP = (EditText)view.findViewWithTag((Object)"otp");
        btnSubmit.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String otp = etOTP.getText().toString().trim();
                if (otp.length() == 0) {
                    etOTP.setError((CharSequence)"Required");
                    etOTP.setBackgroundResource(R.drawable.red_border);
                } else {
                    GoogleNativeActivity.this.submitOTP(otp);
                }
            }
        });
        btnResend.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                GoogleNativeActivity.this.resendOTP();
            }
        });
        this.setContentView((View)view);
    }

    private void resendOTP() {
        this.setContentView((View)this.gtr.generateProgressBar());
        AuthenticationAPI api = new AuthenticationAPI();
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("Phone", this.fieldUtil.getPhone());
        api.resendOtp(null, jsonObject, new AsyncHandler<RegisterResponse>(){

            @Override
            public void onSuccess(RegisterResponse data) {
                Toast.makeText((Context)GoogleNativeActivity.this.context, (CharSequence)"OTP sent to your mobile number", (int)0).show();
                GoogleNativeActivity.this.setOTPView();
            }

            @Override
            public void onFailure(Throwable error, String errorcode) {
                ErrorResponse errorResponse = JsonDeserializer.deserializeJson(error.getMessage(), ErrorResponse.class);
                int errorCode = errorResponse.getErrorCode();
                Log.i((String)"ErrorCode", (String)String.valueOf(errorCode));
                Toast.makeText((Context)GoogleNativeActivity.this.context, (CharSequence)"Unable to complete the request at the moment", (int)0).show();
                GoogleNativeActivity.this.setOTPView();
            }
        });
    }

    private void submitOTP(String otp) {
        this.setContentView((View)this.gtr.generateProgressBar());
        AuthenticationAPI api = new AuthenticationAPI();
        QueryParams queryParams = new QueryParams();
        queryParams.setOtp(otp);
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("Phone", this.fieldUtil.getPhone());
        api.verifyOtp(queryParams, jsonObject, new AsyncHandler<LoginData>(){

            @Override
            public void onSuccess(LoginData data) {
                GoogleNativeActivity.this.sendAccessToken(data.getAccessToken(), data.getRefreshToken());
            }

            @Override
            public void onFailure(Throwable error, String errorcode) {
                ErrorResponse errorResponse = JsonDeserializer.deserializeJson(error.getMessage(), ErrorResponse.class);
                int errorCode = errorResponse.getErrorCode();
                Log.i((String)"ErrorCode", (String)String.valueOf(errorCode));
                if (errorCode == 1067) {
                    Toast.makeText((Context)GoogleNativeActivity.this.context, (CharSequence)"OTP is not correct. Please try again", (int)0).show();
                } else {
                    Toast.makeText((Context)GoogleNativeActivity.this.context, (CharSequence)"Unable to complete the request at the moment", (int)0).show();
                }
                GoogleNativeActivity.this.setOTPView();
            }
        });
    }

    public void sendAccessToken(String accessToken, String refreshToken) {
        AccessTokenResponse accesstoken = new AccessTokenResponse();
        accesstoken.access_token = accessToken;
        accesstoken.refresh_token = refreshToken;
        accesstoken.provider = "google";
        Intent intent = new Intent();
        intent.putExtra("accesstoken", accessToken);
        intent.putExtra("refreshtoken", refreshToken);
        intent.putExtra("provider", "google");
        this.setResult(2, intent);
        this.finish();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 2 && data != null) {
            String token = data.getStringExtra("accesstoken");
            String provider = data.getStringExtra("provider");
            String refreshtoken = data.getStringExtra("refreshtoken");
            Intent intent = new Intent();
            intent.putExtra("accesstoken", token);
            intent.putExtra("refreshtoken", refreshtoken);
            intent.putExtra("provider", provider);
            this.setResult(2, intent);
            this.finish();
        }
    }

    public class NetworkChangeReceiver
    extends BroadcastReceiver {
        public void onReceive(Context context, Intent intent) {
            Log.v((String)GoogleNativeActivity.LOG_TAG, (String)"Receieved notification about network status");
            this.isNetworkAvailable(context);
        }

        private boolean isNetworkAvailable(Context context) {
            NetworkInfo[] info;
            ConnectivityManager connectivity = (ConnectivityManager)context.getSystemService("connectivity");
            if (connectivity != null && (info = connectivity.getAllNetworkInfo()) != null) {
                for (int i = 0; i < info.length; ++i) {
                    if (info[i].getState() != NetworkInfo.State.CONNECTED) continue;
                    if (!GoogleNativeActivity.this.isConnected) {
                        Log.v((String)GoogleNativeActivity.LOG_TAG, (String)"Now you are connected to Internet!");
                        GoogleNativeActivity.this.isConnected = true;
                    }
                    return true;
                }
            }
            Log.v((String)GoogleNativeActivity.LOG_TAG, (String)"You are not connected to Internet!");
            Toast.makeText((Context)GoogleNativeActivity.this.getApplicationContext(), (CharSequence)"Please Check Your Internet Connection", (int)0).show();
            GoogleNativeActivity.this.isConnected = false;
            return false;
        }
    }
}

