package com.locnavi.map.ui.item;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.locnavi.location.xunjimap.model.bean.LocationRegionData;
import com.locnavi.location.xunjimap.utils.IpsUtils;


import com.locnavi.map.R;
import com.sails.engine.SAILS;

public class LocationShareItem extends BaseRecyclerItemFactory<LocationShareItem.LocationRegionDataRecyclerItem> {

    Context context;
    SAILS sails;

    public LocationShareItem(Context context, SAILS sails) {
        this.context = context;
        this.sails = sails;
    }


    @Override
    public boolean isTarget(Object itemObject) {
        return itemObject instanceof LocationRegionData;
    }

    @Override
    public LocationRegionDataRecyclerItem createBaseItem(ViewGroup parent) {
        return new LocationRegionDataRecyclerItem(parent, this);
    }

    public class LocationRegionDataRecyclerItem extends BaseRecyclerItem<LocationRegionData, LocationShareItem> {

        private TextView tvName;
        private TextView tvFloor;

        protected LocationRegionDataRecyclerItem(ViewGroup parent, LocationShareItem factory) {
            super(LayoutInflater.from(parent.getContext()).inflate(R.layout.ipsmap_item_loc_share, parent, false), factory);
        }

        @Override
        protected void onFindViews(View convertView) {
            tvName = (TextView) convertView.findViewById(R.id.tv_name);
            tvFloor = (TextView) convertView.findViewById(R.id.tv_floor);
        }

        @Override
        protected void onConfigViews(final Context context) {

        }

        @Override
        protected void onSetData(int position, LocationRegionData item) {
            tvName.setText(item.getName());
            String floor = item.getFloorName();
            if (TextUtils.isEmpty(floor)) {
                floor = "??";
            } else {
                floor = IpsUtils.getFloorDescription(sails, floor);
            }
            tvFloor.setText(floor);
            if (position == 0) {
                tvFloor.setBackgroundResource(R.drawable.ipsmap_loc_share_circle_blue);
            } else if (item.isActive()) {
                tvFloor.setBackgroundResource(R.drawable.ipsmap_loc_share_circle_yellow);
            } else {
                tvFloor.setBackgroundResource(R.drawable.ipsmap_loc_share_circle_grey);
            }
        }

    }


}
