package com.locnavi.map.ui.widget;

import android.app.Activity;
import android.content.Context;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.PopupWindow;

import com.locnavi.location.xunjimap.utils.DensityUtils;
import com.locnavi.location.xunjimap.utils.IpsConstants;
import com.locnavi.location.xunjimap.utils.L;
import com.locnavi.map.R;
import com.locnavi.map.ui.utils.StatusBarCompat;


import java.util.List;

public class VerifyCompassDialog {

    private PopupWindow popupWindow;
    private View contentView;
    private LinearLayout llVerifyCompass;
    private CompassView compasView;
    private Button btExit;
    private Context context;
    private int navStatus;
    private boolean show = false;


    public VerifyCompassDialog(Context context) {
        this.context = context;

        LayoutInflater inflater = LayoutInflater.from(context);
        contentView = inflater.inflate(R.layout.ipsmap_dialog_vertify_compass, null);
        llVerifyCompass = (LinearLayout) contentView.findViewById(R.id.ll_verifyCompass);
        compasView = (CompassView) contentView.findViewById(R.id.compas_view);
        btExit = (Button) contentView.findViewById(R.id.bt_exit);
        btExit.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dismiss();
            }
        });

        popupWindow = new PopupWindow(contentView, DensityUtils.getScreenWidth(context),
                DensityUtils.getScreenHeight(context), true);
        popupWindow.setOutsideTouchable(false);
        popupWindow.setAnimationStyle(R.style.IpsmapDialogBottom);

    }

    public boolean isShowing() {
        return popupWindow.isShowing();
    }

    public void show(View view, int navStatus) {
        try {
            this.navStatus = navStatus;
            if (popupWindow == null || popupWindow.isShowing() || view == null) {
                return;
            }
            if (((Activity) context).hasWindowFocus()) {
                popupWindow.showAtLocation(view, Gravity.BOTTOM, 0, 0);
                StatusBarCompat.setColor((Activity) context, context.getResources().getColor(R.color.ipsmap_tvBlack2));
            } else {
                //Toast.makeText(context,"获取不到焦点",Toast.LENGTH_LONG).show();
            }
        } catch (WindowManager.BadTokenException e) {
            L.e(context.getString(R.string.ipsmap_find_error), e.toString());
        }
    }

    public void dismiss() {
        if (popupWindow != null && popupWindow.isShowing()) {
            if (navStatus == IpsConstants.NAV_STATUS_DEFAULT || navStatus == IpsConstants.NAV_STATUS_SHOW_REGION_INFO) {
                StatusBarCompat.setColor((Activity) context, context.getResources().getColor(R.color.ipsmap_colorPrimaryDark));
            } else {
                StatusBarCompat.setColor((Activity) context, context.getResources().getColor(R.color.ipsmap_colorPrimaryTranslucent));
            }
            popupWindow.dismiss();
        }
    }


    public void setParam(float v, float v1, List<Integer> list) {
        if (popupWindow != null && popupWindow.isShowing()) {
            compasView.setSouth(v, v1, list);
            compasView.invalidate();
        }
    }
}
