/*
 * Decompiled with CFR 0.152.
 */
package com.liyu.sqlitetoexcel;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.liyu.sqlitetoexcel.SecurityUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class SQLiteToExcel {
    private static Handler handler = new Handler(Looper.getMainLooper());
    private String protectKey;
    private String encryptKey;
    private String fileName;
    private String filePath;
    private List<String> tables;
    private SQLiteDatabase database;
    private Workbook workbook;

    public String start() {
        if (this.tables == null || this.tables.size() == 0) {
            this.tables = this.getAllTables(this.database);
        }
        try {
            return this.exportTables(this.tables, this.fileName);
        }
        catch (Exception e) {
            if (this.database != null && this.database.isOpen()) {
                this.database.close();
            }
            return null;
        }
    }

    public void start(final ExportListener listener) {
        if (this.tables == null || this.tables.size() == 0) {
            this.tables = this.getAllTables(this.database);
        }
        if (listener != null) {
            listener.onStart();
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                block4: {
                    try {
                        final String filePath = SQLiteToExcel.this.exportTables(SQLiteToExcel.this.tables, SQLiteToExcel.this.fileName);
                        if (listener != null) {
                            handler.post(new Runnable(){

                                @Override
                                public void run() {
                                    listener.onCompleted(filePath);
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        if (SQLiteToExcel.this.database != null && SQLiteToExcel.this.database.isOpen()) {
                            SQLiteToExcel.this.database.close();
                        }
                        if (listener == null) break block4;
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                listener.onError(e);
                            }
                        });
                    }
                }
            }
        }).start();
    }

    private SQLiteToExcel(List<String> tables, String protectKey, String encryptKey, String fileName, String dataBaseName, String filePath) {
        this.protectKey = protectKey;
        this.encryptKey = encryptKey;
        this.fileName = fileName;
        this.filePath = filePath;
        this.tables = tables;
        try {
            this.database = SQLiteDatabase.openOrCreateDatabase((String)dataBaseName, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String exportTables(List<String> tables, String fileName) throws Exception {
        if (!fileName.toLowerCase().endsWith(".xls")) {
            throw new IllegalArgumentException("file name is null or unsupported file format!");
        }
        this.workbook = new HSSFWorkbook();
        for (int i = 0; i < tables.size(); ++i) {
            Sheet sheet = this.workbook.createSheet(tables.get(i));
            this.fillSheet(tables.get(i), sheet);
            if (TextUtils.isEmpty((CharSequence)this.protectKey)) continue;
            sheet.protectSheet(this.protectKey);
        }
        File file = new File(this.filePath, fileName);
        FileOutputStream fos1 = new FileOutputStream(file);
        this.workbook.write((OutputStream)fos1);
        if (fos1 != null) {
            fos1.flush();
            fos1.close();
        }
        this.workbook.close();
        this.database.close();
        if (!TextUtils.isEmpty((CharSequence)this.encryptKey)) {
            SecurityUtil.EncryptFile(file, this.encryptKey);
        }
        return file.getPath();
    }

    private void fillSheet(String table, Sheet sheet) {
        Row headerRow = sheet.createRow(0);
        ArrayList<String> columns = this.getTableColumns(this.database, table);
        for (int i = 0; i < columns.size(); ++i) {
            Cell cellA = headerRow.createCell(i);
            cellA.setCellValue((RichTextString)new HSSFRichTextString("" + columns.get(i)));
        }
        Drawing patriarch = sheet.createDrawingPatriarch();
        Cursor cursor = this.database.rawQuery("select * from " + table, null);
        cursor.moveToFirst();
        int n = 1;
        while (!cursor.isAfterLast()) {
            Row rowA = sheet.createRow(n);
            for (int j = 0; j < columns.size(); ++j) {
                Cell cellA = rowA.createCell(j);
                if (cursor.getType(j) == 4) {
                    HSSFClientAnchor anchor = new HSSFClientAnchor(0, 0, 0, 0, (short)j, n, (short)(j + 1), n + 1);
                    anchor.setAnchorType(3);
                    patriarch.createPicture((ClientAnchor)anchor, this.workbook.addPicture(cursor.getBlob(j), 5));
                    continue;
                }
                String value = cursor.getString(j);
                if (!TextUtils.isEmpty((CharSequence)value) && value.length() >= Short.MAX_VALUE) {
                    value = value.substring(0, 32766);
                }
                cellA.setCellValue((RichTextString)new HSSFRichTextString(value));
            }
            ++n;
            cursor.moveToNext();
        }
        cursor.close();
    }

    private ArrayList<String> getAllTables(SQLiteDatabase database) {
        ArrayList<String> tables = new ArrayList<String>();
        Cursor cursor = database.rawQuery("select name from sqlite_master where type='table' order by name", null);
        while (cursor.moveToNext()) {
            tables.add(cursor.getString(0));
        }
        cursor.close();
        return tables;
    }

    private ArrayList<String> getTableColumns(SQLiteDatabase database, String table) {
        ArrayList<String> columns = new ArrayList<String>();
        Cursor cursor = database.rawQuery("PRAGMA table_info(" + table + ")", null);
        while (cursor.moveToNext()) {
            columns.add(cursor.getString(1));
        }
        cursor.close();
        return columns;
    }

    public static interface ExportListener {
        public void onStart();

        public void onCompleted(String var1);

        public void onError(Exception var1);
    }

    public static class Builder {
        private String dataBaseName;
        private String filePath;
        private String fileName;
        private String protectKey;
        private String encryptKey;
        private List<String> tables;

        public Builder(Context context) {
            this.filePath = context.getExternalFilesDir(null).getPath();
        }

        public SQLiteToExcel build() {
            if (TextUtils.isEmpty((CharSequence)this.dataBaseName)) {
                throw new IllegalArgumentException("Database name must not be null.");
            }
            if (TextUtils.isEmpty((CharSequence)this.fileName)) {
                throw new IllegalArgumentException("Output file name must not be null.");
            }
            return new SQLiteToExcel(this.tables, this.protectKey, this.encryptKey, this.fileName, this.dataBaseName, this.filePath);
        }

        public Builder setDataBase(String dataBaseName) {
            this.dataBaseName = dataBaseName;
            this.fileName = new File(dataBaseName).getName() + ".xls";
            return this;
        }

        public Builder setFileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public Builder setProtectKey(String protectPassword) {
            this.protectKey = protectPassword;
            return this;
        }

        public Builder setEncryptKey(String encryptKey) {
            this.encryptKey = encryptKey;
            return this;
        }

        public Builder setTables(String ... tables) {
            this.tables = Arrays.asList(tables);
            return this;
        }

        public Builder setPath(String path) {
            this.filePath = path;
            return this;
        }

        public String start() {
            SQLiteToExcel sqliteToExcel = this.build();
            return sqliteToExcel.start();
        }

        public void start(ExportListener listener) {
            SQLiteToExcel sqliteToExcel = this.build();
            sqliteToExcel.start(listener);
        }
    }
}

