/*
 * Decompiled with CFR 0.152.
 */
package com.liyu.sqlitetoexcel;

import android.content.ContentValues;
import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.os.Handler;
import android.os.Looper;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelToSqlite {
    private static Handler handler = new Handler(Looper.getMainLooper());
    private Context mContext;
    private SQLiteDatabase database;
    private String mDbName;

    public ExcelToSqlite(Context context, String dbName) {
        System.setProperty("org.apache.poi.javax.xml.stream.XMLInputFactory", "com.fasterxml.aalto.stax.InputFactoryImpl");
        System.setProperty("org.apache.poi.javax.xml.stream.XMLOutputFactory", "com.fasterxml.aalto.stax.OutputFactoryImpl");
        System.setProperty("org.apache.poi.javax.xml.stream.XMLEventFactory", "com.fasterxml.aalto.stax.EventFactoryImpl");
        this.mContext = context;
        this.mDbName = dbName;
        try {
            this.database = SQLiteDatabase.openOrCreateDatabase((String)this.mContext.getDatabasePath(this.mDbName).getAbsolutePath(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startFromAsset(final String assetFileName, final ImportListener listener) {
        if (listener != null) {
            listener.onStart();
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                block4: {
                    try {
                        ExcelToSqlite.this.working(ExcelToSqlite.this.mContext.getAssets().open(assetFileName), assetFileName);
                        if (listener != null) {
                            handler.post(new Runnable(){

                                @Override
                                public void run() {
                                    listener.onCompleted(ExcelToSqlite.this.mDbName);
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        if (ExcelToSqlite.this.database != null && ExcelToSqlite.this.database.isOpen()) {
                            ExcelToSqlite.this.database.close();
                        }
                        if (listener == null) break block4;
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                listener.onError(e);
                            }
                        });
                    }
                }
            }
        }).start();
    }

    public void startFromFile(String filePath, ImportListener listener) {
        this.startFromFile(new File(filePath), listener);
    }

    public void startFromFile(final File file, final ImportListener listener) {
        if (listener != null) {
            listener.onStart();
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                block4: {
                    try {
                        ExcelToSqlite.this.working(new FileInputStream(file), file.getName());
                        if (listener != null) {
                            handler.post(new Runnable(){

                                @Override
                                public void run() {
                                    listener.onCompleted(ExcelToSqlite.this.mDbName);
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        if (ExcelToSqlite.this.database != null && ExcelToSqlite.this.database.isOpen()) {
                            ExcelToSqlite.this.database.close();
                        }
                        if (listener == null) break block4;
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                listener.onError(e);
                            }
                        });
                    }
                }
            }
        }).start();
    }

    private void working(InputStream stream, String fileName) throws Exception {
        HSSFWorkbook workbook;
        if (fileName.endsWith(".xls")) {
            workbook = new HSSFWorkbook(stream);
        } else if (fileName.endsWith(".xlsx")) {
            workbook = new XSSFWorkbook(stream);
        } else {
            throw new UnsupportedOperationException("file name is null or unsupported file format!");
        }
        int sheetNumber = workbook.getNumberOfSheets();
        for (int i = 0; i < sheetNumber; ++i) {
            this.createTable(workbook.getSheetAt(i));
        }
        this.database.close();
    }

    private void createTable(Sheet sheet) {
        StringBuilder createTableSql = new StringBuilder("CREATE TABLE IF NOT EXISTS ");
        createTableSql.append(sheet.getSheetName());
        createTableSql.append("(");
        Iterator rit = sheet.rowIterator();
        Row rowHeader = (Row)rit.next();
        ArrayList<String> columns = new ArrayList<String>();
        for (int i = 0; i < rowHeader.getPhysicalNumberOfCells(); ++i) {
            createTableSql.append(rowHeader.getCell(i).getStringCellValue());
            if (i == rowHeader.getPhysicalNumberOfCells() - 1) {
                createTableSql.append(" TEXT");
            } else {
                createTableSql.append(" TEXT,");
            }
            columns.add(rowHeader.getCell(i).getStringCellValue());
        }
        createTableSql.append(")");
        this.database.execSQL(createTableSql.toString());
        while (rit.hasNext()) {
            long result;
            Row row = (Row)rit.next();
            ContentValues values = new ContentValues();
            for (int n = 0; n < row.getPhysicalNumberOfCells(); ++n) {
                if (row.getCell(n) == null) continue;
                if (row.getCell(n).getCellType() == 0) {
                    values.put((String)columns.get(n), Double.valueOf(row.getCell(n).getNumericCellValue()));
                    continue;
                }
                values.put((String)columns.get(n), row.getCell(n).getStringCellValue());
            }
            if (values.size() == 0 || (result = this.database.insert(sheet.getSheetName(), null, values)) >= 0L) continue;
            throw new RuntimeException("insert value failed!");
        }
    }

    public static interface ImportListener {
        public void onStart();

        public void onCompleted(String var1);

        public void onError(Exception var1);
    }
}

