/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax2.ri.evt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.javax.xml.namespace.NamespaceContext;
import org.apache.poi.javax.xml.stream.events.Namespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergedNsContext
implements NamespaceContext {
    final NamespaceContext _parentCtxt;
    final List<Namespace> _namespaces;

    protected MergedNsContext(NamespaceContext namespaceContext, List<Namespace> list) {
        this._parentCtxt = namespaceContext;
        this._namespaces = list == null ? Collections.emptyList() : list;
    }

    public static MergedNsContext construct(NamespaceContext namespaceContext, List<Namespace> list) {
        return new MergedNsContext(namespaceContext, list);
    }

    @Override
    public String getNamespaceURI(String string) {
        String string2;
        if (string == null) {
            throw new IllegalArgumentException("Illegal to pass null prefix");
        }
        int n = this._namespaces.size();
        for (int i = 0; i < n; ++i) {
            Namespace namespace = this._namespaces.get(i);
            if (!string.equals(namespace.getPrefix())) continue;
            return namespace.getNamespaceURI();
        }
        if (this._parentCtxt != null && (string2 = this._parentCtxt.getNamespaceURI(string)) != null) {
            return string2;
        }
        if (string.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (string.equals("xmlns")) {
            return "http://www.w3.org/2000/xmlns/";
        }
        return null;
    }

    @Override
    public String getPrefix(String string) {
        Object object;
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Illegal to pass null/empty prefix as argument.");
        }
        int n = this._namespaces.size();
        for (int i = 0; i < n; ++i) {
            object = this._namespaces.get(i);
            if (!string.equals(object.getNamespaceURI())) continue;
            return object.getPrefix();
        }
        if (this._parentCtxt != null) {
            String string2;
            String string3 = this._parentCtxt.getPrefix(string);
            if (string3 != null && (string2 = this.getNamespaceURI(string3)).equals(string)) {
                return string3;
            }
            Iterator iterator = this._parentCtxt.getPrefixes(string);
            while (iterator.hasNext()) {
                String string4;
                object = (String)iterator.next();
                if (((String)object).equals(string3) || !(string4 = this.getNamespaceURI((String)object)).equals(string)) continue;
                return object;
            }
        }
        if (string.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        if (string.equals("http://www.w3.org/2000/xmlns/")) {
            return "xmlns";
        }
        return null;
    }

    @Override
    public Iterator<String> getPrefixes(String string) {
        Object object;
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Illegal to pass null/empty prefix as argument.");
        }
        ArrayList<String> arrayList = null;
        int n = this._namespaces.size();
        for (int i = 0; i < n; ++i) {
            object = this._namespaces.get(i);
            if (!string.equals(object.getNamespaceURI())) continue;
            arrayList = this.addToList(arrayList, object.getPrefix());
        }
        if (this._parentCtxt != null) {
            Iterator iterator = this._parentCtxt.getPrefixes(string);
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                object = this.getNamespaceURI(string2);
                if (!((String)object).equals(string)) continue;
                arrayList = this.addToList(arrayList, string2);
            }
        }
        if (string.equals("http://www.w3.org/XML/1998/namespace")) {
            arrayList = this.addToList(arrayList, "xml");
        }
        if (string.equals("http://www.w3.org/2000/xmlns/")) {
            arrayList = this.addToList(arrayList, "xmlns");
        }
        return null;
    }

    protected <T> ArrayList<T> addToList(ArrayList<T> arrayList, T t) {
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        arrayList.add(t);
        return arrayList;
    }
}

