/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax2.ri.evt;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.poi.javax.xml.namespace.QName;
import org.apache.poi.javax.xml.stream.Location;
import org.apache.poi.javax.xml.stream.XMLStreamException;
import org.apache.poi.javax.xml.stream.XMLStreamReader;
import org.apache.poi.javax.xml.stream.events.EndElement;
import org.apache.poi.javax.xml.stream.events.Namespace;
import org.codehaus.stax2.XMLStreamWriter2;
import org.codehaus.stax2.ri.EmptyIterator;
import org.codehaus.stax2.ri.evt.BaseEventImpl;
import org.codehaus.stax2.ri.evt.NamespaceEventImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndElementEventImpl
extends BaseEventImpl
implements EndElement {
    protected final QName mName;
    protected final ArrayList<Namespace> mNamespaces;

    public EndElementEventImpl(Location location, XMLStreamReader xMLStreamReader) {
        super(location);
        this.mName = xMLStreamReader.getName();
        int n = xMLStreamReader.getNamespaceCount();
        if (n == 0) {
            this.mNamespaces = null;
        } else {
            ArrayList<NamespaceEventImpl> arrayList = new ArrayList<NamespaceEventImpl>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(NamespaceEventImpl.constructNamespace(location, xMLStreamReader.getNamespacePrefix(i), xMLStreamReader.getNamespaceURI(i)));
            }
            this.mNamespaces = arrayList;
        }
    }

    public EndElementEventImpl(Location location, QName qName, Iterator<Namespace> iterator) {
        super(location);
        this.mName = qName;
        if (iterator == null || !iterator.hasNext()) {
            this.mNamespaces = null;
        } else {
            ArrayList<Namespace> arrayList = new ArrayList<Namespace>();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            this.mNamespaces = arrayList;
        }
    }

    @Override
    public QName getName() {
        return this.mName;
    }

    @Override
    public Iterator<Namespace> getNamespaces() {
        if (this.mNamespaces == null) {
            return EmptyIterator.getInstance();
        }
        return this.mNamespaces.iterator();
    }

    @Override
    public EndElement asEndElement() {
        return this;
    }

    @Override
    public int getEventType() {
        return 2;
    }

    @Override
    public boolean isEndElement() {
        return true;
    }

    @Override
    public void writeAsEncodedUnicode(Writer writer) throws XMLStreamException {
        try {
            writer.write("</");
            String string = this.mName.getPrefix();
            if (string != null && string.length() > 0) {
                writer.write(string);
                writer.write(58);
            }
            writer.write(this.mName.getLocalPart());
            writer.write(62);
        }
        catch (IOException iOException) {
            this.throwFromIOE(iOException);
        }
    }

    @Override
    public void writeUsing(XMLStreamWriter2 xMLStreamWriter2) throws XMLStreamException {
        xMLStreamWriter2.writeEndElement();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof EndElement)) {
            return false;
        }
        EndElement endElement = (EndElement)object;
        return this.getName().equals(endElement.getName());
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }
}

