/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.magicprogresswidget;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.util.AttributeSet;
import android.view.View;
import cn.dreamtobe.percentsmoothhandler.ISmoothTarget;
import cn.dreamtobe.percentsmoothhandler.SmoothHandler;
import com.liulishuo.magicprogresswidget.R;
import java.lang.ref.WeakReference;

public class MagicProgressCircle
extends View
implements ISmoothTarget {
    private int startColor;
    private int endColor;
    private int defaultColor;
    private int percentEndColor;
    private int strokeWidth;
    private float percent;
    private Paint paint;
    private SmoothHandler smoothHandler;
    private boolean isFootOverHead;
    private int deltaR;
    private int deltaB;
    private int deltaG;
    private int startR;
    private int startB;
    private int startG;
    private Paint startPaint;
    private Paint endPaint;
    private final RectF rectF = new RectF();
    private int[] customColors;
    private int[] fullColors;
    private int[] emptyColors;
    private float[] customPositions;
    private float[] extremePositions;

    public MagicProgressCircle(Context context) {
        super(context);
        this.init(context, null);
    }

    public MagicProgressCircle(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public MagicProgressCircle(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public MagicProgressCircle(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs) {
        float defaultPercent = -1.0f;
        if (this.isInEditMode()) {
            defaultPercent = 0.6f;
        }
        int strokeWdithDefaultValue = (int)(18.0f * this.getResources().getDisplayMetrics().density + 0.5f);
        if (context == null || attrs == null) {
            this.strokeWidth = strokeWdithDefaultValue;
            this.percent = defaultPercent;
            this.startColor = this.getResources().getColor(R.color.mpc_start_color);
            this.endColor = this.getResources().getColor(R.color.mpc_end_color);
            this.defaultColor = this.getResources().getColor(R.color.mpc_default_color);
        } else {
            TypedArray typedArray = null;
            try {
                typedArray = context.obtainStyledAttributes(attrs, R.styleable.MagicProgressCircle);
                this.percent = typedArray.getFloat(R.styleable.MagicProgressCircle_mpc_percent, defaultPercent);
                this.strokeWidth = (int)typedArray.getDimension(R.styleable.MagicProgressCircle_mpc_stroke_width, (float)strokeWdithDefaultValue);
                this.startColor = typedArray.getColor(R.styleable.MagicProgressCircle_mpc_start_color, this.getResources().getColor(R.color.mpc_start_color));
                this.endColor = typedArray.getColor(R.styleable.MagicProgressCircle_mpc_end_color, this.getResources().getColor(R.color.mpc_end_color));
                this.defaultColor = typedArray.getColor(R.styleable.MagicProgressCircle_mpc_default_color, this.getResources().getColor(R.color.mpc_default_color));
                this.isFootOverHead = typedArray.getBoolean(R.styleable.MagicProgressCircle_mpc_foot_over_head, false);
            }
            finally {
                if (typedArray != null) {
                    typedArray.recycle();
                }
            }
        }
        this.paint = new Paint();
        this.paint.setAntiAlias(true);
        this.paint.setStrokeWidth((float)this.strokeWidth);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeJoin(Paint.Join.ROUND);
        this.paint.setStrokeCap(Paint.Cap.ROUND);
        this.startPaint = new Paint();
        this.startPaint.setColor(this.startColor);
        this.startPaint.setAntiAlias(true);
        this.startPaint.setStyle(Paint.Style.FILL);
        this.endPaint = new Paint();
        this.endPaint.setAntiAlias(true);
        this.endPaint.setStyle(Paint.Style.FILL);
        this.refreshDelta();
        this.customColors = new int[]{this.startColor, this.percentEndColor, this.defaultColor, this.defaultColor};
        this.fullColors = new int[]{this.startColor, this.endColor};
        this.emptyColors = new int[]{this.defaultColor, this.defaultColor};
        this.customPositions = new float[4];
        this.customPositions[0] = 0.0f;
        this.customPositions[3] = 1.0f;
        this.extremePositions = new float[]{0.0f, 1.0f};
    }

    private void refreshDelta() {
        int endR = (this.endColor & 0xFF0000) >> 16;
        int endG = (this.endColor & 0xFF00) >> 8;
        int endB = this.endColor & 0xFF;
        this.startR = (this.startColor & 0xFF0000) >> 16;
        this.startG = (this.startColor & 0xFF00) >> 8;
        this.startB = this.startColor & 0xFF;
        this.deltaR = endR - this.startR;
        this.deltaG = endG - this.startG;
        this.deltaB = endB - this.startB;
    }

    public void setPercent(float percent) {
        percent = Math.min(1.0f, percent);
        percent = Math.max(0.0f, percent);
        if (this.smoothHandler != null) {
            this.smoothHandler.commitPercent(percent);
        }
        if (this.percent != percent) {
            this.percent = percent;
            this.invalidate();
        }
    }

    public void setSmoothPercent(float percent) {
        this.getSmoothHandler().loopSmooth(percent);
    }

    public void setSmoothPercent(float percent, long durationMillis) {
        this.getSmoothHandler().loopSmooth(percent, durationMillis);
    }

    private SmoothHandler getSmoothHandler() {
        if (this.smoothHandler == null) {
            this.smoothHandler = new SmoothHandler(new WeakReference<MagicProgressCircle>(this));
        }
        return this.smoothHandler;
    }

    public float getPercent() {
        return this.percent;
    }

    public void setStartColor(int color2) {
        if (this.startColor != color2) {
            this.startColor = color2;
            this.refreshDelta();
            this.customColors[0] = color2;
            this.startPaint.setColor(color2);
            this.fullColors[0] = color2;
            this.invalidate();
        }
    }

    public int getStartColor() {
        return this.startColor;
    }

    public void setEndColor(int color2) {
        if (this.endColor != color2) {
            this.endColor = color2;
            this.refreshDelta();
            this.fullColors[1] = color2;
            this.invalidate();
        }
    }

    public int getEndColor() {
        return this.endColor;
    }

    public void setDefaultColor(int color2) {
        if (this.defaultColor != color2) {
            this.defaultColor = color2;
            this.customColors[2] = color2;
            this.customColors[3] = color2;
            this.emptyColors[0] = color2;
            this.emptyColors[1] = color2;
            this.invalidate();
        }
    }

    public int getDefaultColor() {
        return this.defaultColor;
    }

    public void setStrokeWidth(int width) {
        if (this.strokeWidth != width) {
            this.strokeWidth = width;
            this.paint.setStrokeWidth((float)width);
            this.requestLayout();
        }
    }

    public int getStrokeWidth() {
        return this.strokeWidth;
    }

    public void setFootOverHead(boolean footOverHead) {
        if (this.isFootOverHead != footOverHead) {
            this.isFootOverHead = footOverHead;
            this.invalidate();
        }
    }

    public boolean isFootOverHead() {
        return this.isFootOverHead;
    }

    private void calculatePercentEndColor(float percent) {
        this.percentEndColor = ((int)((float)this.deltaR * percent + (float)this.startR) << 16) + ((int)((float)this.deltaG * percent + (float)this.startG) << 8) + (int)((float)this.deltaB * percent + (float)this.startB) + -16777216;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.rectF.left = this.getMeasuredWidth() / 2 - this.strokeWidth / 2;
        this.rectF.top = 0.0f;
        this.rectF.right = this.getMeasuredWidth() / 2 + this.strokeWidth / 2;
        this.rectF.bottom = this.strokeWidth;
    }

    @SuppressLint(value={"DrawAllocation"})
    protected void onDraw(Canvas canvas) {
        float[] positions;
        int[] colors;
        super.onDraw(canvas);
        int restore = canvas.save();
        int cx = this.getMeasuredWidth() / 2;
        int cy = this.getMeasuredHeight() / 2;
        int radius = this.getMeasuredWidth() / 2 - this.strokeWidth / 2;
        float drawPercent = this.percent;
        if ((double)drawPercent > 0.97 && drawPercent < 1.0f) {
            drawPercent = 0.97f;
        }
        canvas.save();
        canvas.rotate(-90.0f, (float)cx, (float)cy);
        if (drawPercent < 1.0f && drawPercent > 0.0f) {
            this.calculatePercentEndColor(drawPercent);
            this.customColors[1] = this.percentEndColor;
            colors = this.customColors;
            this.customPositions[1] = drawPercent;
            this.customPositions[2] = drawPercent;
            positions = this.customPositions;
        } else if (drawPercent == 1.0f) {
            this.percentEndColor = this.endColor;
            colors = this.fullColors;
            positions = this.extremePositions;
        } else {
            colors = this.emptyColors;
            positions = this.extremePositions;
        }
        SweepGradient sweepGradient = new SweepGradient((float)(this.getMeasuredWidth() / 2), (float)(this.getMeasuredHeight() / 2), colors, positions);
        this.paint.setShader((Shader)sweepGradient);
        canvas.drawCircle((float)cx, (float)cy, (float)radius, this.paint);
        canvas.restore();
        if (drawPercent > 0.0f) {
            if (drawPercent < 1.0f || this.isFootOverHead && drawPercent == 1.0f) {
                canvas.save();
                this.endPaint.setColor(this.percentEndColor);
                canvas.rotate((float)((int)Math.floor(360.0f * drawPercent) - 1), (float)cx, (float)cy);
                canvas.drawArc(this.rectF, -90.0f, 180.0f, true, this.endPaint);
                canvas.restore();
            }
            if (!this.isFootOverHead || drawPercent < 1.0f) {
                canvas.save();
                canvas.drawArc(this.rectF, 90.0f, 180.0f, true, this.startPaint);
                canvas.restore();
            }
        }
        canvas.restoreToCount(restore);
    }
}

