/*
 * Decompiled with CFR 0.152.
 */
package com.littlegreens.netty.client.handler;

import android.util.Log;
import com.littlegreens.netty.client.listener.NettyClientListener;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;

public class NettyClientHandler
extends SimpleChannelInboundHandler<String> {
    private static final String TAG = "NettyClientHandler";
    private final boolean isSendheartBeat;
    private NettyClientListener listener;
    private int index;
    private Object heartBeatData;
    byte[] requestBody = new byte[]{-2, -19, -2, 5, 4, -1, 10};

    public NettyClientHandler(NettyClientListener listener, int index, boolean isSendheartBeat, Object heartBeatData) {
        this.listener = listener;
        this.index = index;
        this.isSendheartBeat = isSendheartBeat;
        this.heartBeatData = heartBeatData;
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        IdleStateEvent event;
        if (evt instanceof IdleStateEvent && (event = (IdleStateEvent)evt).state() == IdleState.WRITER_IDLE) {
            if (this.isSendheartBeat) {
                if (this.heartBeatData == null) {
                    ctx.channel().writeAndFlush((Object)("Heartbeat" + System.getProperty("line.separator")));
                } else if (this.heartBeatData instanceof String) {
                    ctx.channel().writeAndFlush((Object)(this.heartBeatData + System.getProperty("line.separator")));
                } else if (this.heartBeatData instanceof byte[]) {
                    ByteBuf buf = Unpooled.copiedBuffer((byte[])((byte[])this.heartBeatData));
                    ctx.channel().writeAndFlush((Object)buf);
                } else {
                    Log.e((String)TAG, (String)"userEventTriggered: heartBeatData type error");
                }
            } else {
                Log.e((String)TAG, (String)"\u4e0d\u53d1\u9001\u5fc3\u8df3");
            }
        }
    }

    public void channelActive(ChannelHandlerContext ctx) {
        Log.e((String)TAG, (String)"channelActive");
        this.listener.onClientStatusConnectChanged(1, this.index);
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        Log.e((String)TAG, (String)"channelInactive");
    }

    protected void channelRead0(ChannelHandlerContext channelHandlerContext, String msg) {
        Log.e((String)TAG, (String)("channelRead0:" + msg));
        this.listener.onMessageResponseClient(msg, this.index);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        Log.e((String)TAG, (String)"exceptionCaught");
        this.listener.onClientStatusConnectChanged(-1, this.index);
        cause.printStackTrace();
        ctx.close();
    }
}

