/*
 * Decompiled with CFR 0.152.
 */
package com.littlegreens.netty.client;

import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import com.littlegreens.netty.client.handler.NettyClientHandler;
import com.littlegreens.netty.client.listener.MessageStateListener;
import com.littlegreens.netty.client.listener.NettyClientListener;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.DelimiterBasedFrameDecoder;
import io.netty.handler.codec.LineBasedFrameDecoder;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.TimeUnit;

public class NettyTcpClient {
    private static final String TAG = "NettyTcpClient";
    private EventLoopGroup group;
    private NettyClientListener listener;
    private Channel channel;
    private boolean isConnect = false;
    private int MAX_CONNECT_TIMES;
    private int reconnectNum = this.MAX_CONNECT_TIMES = Integer.MAX_VALUE;
    private boolean isNeedReconnect = true;
    private boolean isConnecting = false;
    private long reconnectIntervalTime = 5000L;
    private static final Integer CONNECT_TIMEOUT_MILLIS = 5000;
    private String host;
    private int tcp_port;
    private int mIndex;
    private long heartBeatInterval = 5L;
    private boolean isSendheartBeat = false;
    private Object heartBeatData;
    private String packetSeparator;
    private int maxPacketLong = 1024;

    private void setPacketSeparator(String separator) {
        this.packetSeparator = separator;
    }

    private void setMaxPacketLong(int maxPacketLong) {
        this.maxPacketLong = maxPacketLong;
    }

    private NettyTcpClient(String host, int tcp_port, int index) {
        this.host = host;
        this.tcp_port = tcp_port;
        this.mIndex = index;
    }

    public int getMaxConnectTimes() {
        return this.MAX_CONNECT_TIMES;
    }

    public long getReconnectIntervalTime() {
        return this.reconnectIntervalTime;
    }

    public String getHost() {
        return this.host;
    }

    public int getTcp_port() {
        return this.tcp_port;
    }

    public int getIndex() {
        return this.mIndex;
    }

    public long getHeartBeatInterval() {
        return this.heartBeatInterval;
    }

    public boolean isSendheartBeat() {
        return this.isSendheartBeat;
    }

    public void connect() {
        if (this.isConnecting) {
            return;
        }
        Thread clientThread = new Thread("client-Netty"){

            @Override
            public void run() {
                super.run();
                NettyTcpClient.this.isNeedReconnect = true;
                NettyTcpClient.this.reconnectNum = NettyTcpClient.this.MAX_CONNECT_TIMES;
                NettyTcpClient.this.connectServer();
            }
        };
        clientThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectServer() {
        NettyTcpClient nettyTcpClient = this;
        synchronized (nettyTcpClient) {
            ChannelFuture channelFuture = null;
            if (!this.isConnect) {
                this.isConnecting = true;
                this.group = new NioEventLoopGroup();
                Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.group)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)5000)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                    public void initChannel(SocketChannel ch) throws Exception {
                        if (NettyTcpClient.this.isSendheartBeat) {
                            ch.pipeline().addLast("ping", (ChannelHandler)new IdleStateHandler(0L, NettyTcpClient.this.heartBeatInterval, 0L, TimeUnit.SECONDS));
                        }
                        if (!TextUtils.isEmpty((CharSequence)NettyTcpClient.this.packetSeparator)) {
                            ByteBuf delimiter = Unpooled.buffer();
                            delimiter.writeBytes(NettyTcpClient.this.packetSeparator.getBytes());
                            ch.pipeline().addLast(new ChannelHandler[]{new DelimiterBasedFrameDecoder(NettyTcpClient.this.maxPacketLong, delimiter)});
                        } else {
                            ch.pipeline().addLast(new ChannelHandler[]{new LineBasedFrameDecoder(NettyTcpClient.this.maxPacketLong)});
                        }
                        ch.pipeline().addLast(new ChannelHandler[]{new StringEncoder(CharsetUtil.UTF_8)});
                        ch.pipeline().addLast(new ChannelHandler[]{new StringDecoder(CharsetUtil.UTF_8)});
                        ch.pipeline().addLast(new ChannelHandler[]{new NettyClientHandler(NettyTcpClient.this.listener, NettyTcpClient.this.mIndex, NettyTcpClient.this.isSendheartBeat, NettyTcpClient.this.heartBeatData)});
                    }
                });
                try {
                    channelFuture = bootstrap.connect(this.host, this.tcp_port).addListener((GenericFutureListener)new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture channelFuture) throws Exception {
                            if (channelFuture.isSuccess()) {
                                Log.e((String)NettyTcpClient.TAG, (String)"\u8fde\u63a5\u6210\u529f");
                                NettyTcpClient.this.reconnectNum = NettyTcpClient.this.MAX_CONNECT_TIMES;
                                NettyTcpClient.this.isConnect = true;
                                NettyTcpClient.this.channel = channelFuture.channel();
                            } else {
                                Log.e((String)NettyTcpClient.TAG, (String)"\u8fde\u63a5\u5931\u8d25");
                                NettyTcpClient.this.isConnect = false;
                            }
                            NettyTcpClient.this.isConnecting = false;
                        }
                    }).sync();
                    channelFuture.channel().closeFuture().sync();
                    Log.e((String)TAG, (String)" \u65ad\u5f00\u8fde\u63a5");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    this.isConnect = false;
                    this.listener.onClientStatusConnectChanged(0, this.mIndex);
                    if (null != channelFuture && channelFuture.channel() != null && channelFuture.channel().isOpen()) {
                        channelFuture.channel().close();
                    }
                    this.group.shutdownGracefully();
                    this.reconnect();
                }
            }
        }
    }

    public void disconnect() {
        Log.e((String)TAG, (String)"disconnect");
        this.isNeedReconnect = false;
        this.group.shutdownGracefully();
    }

    public void reconnect() {
        Log.e((String)TAG, (String)"reconnect");
        if (this.isNeedReconnect && this.reconnectNum > 0 && !this.isConnect) {
            --this.reconnectNum;
            SystemClock.sleep((long)this.reconnectIntervalTime);
            if (this.isNeedReconnect && this.reconnectNum > 0 && !this.isConnect) {
                Log.e((String)TAG, (String)"\u91cd\u65b0\u8fde\u63a5");
                this.connectServer();
            }
        }
    }

    public boolean sendMsgToServer(String data, final MessageStateListener listener) {
        boolean flag;
        boolean bl = flag = this.channel != null && this.isConnect;
        if (flag) {
            String separator = TextUtils.isEmpty((CharSequence)this.packetSeparator) ? System.getProperty("line.separator") : this.packetSeparator;
            ChannelFuture channelFuture = this.channel.writeAndFlush((Object)(data + separator)).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture channelFuture) throws Exception {
                    listener.isSendSuccss(channelFuture.isSuccess());
                }
            });
        }
        return flag;
    }

    public boolean sendMsgToServer(String data) {
        boolean flag;
        boolean bl = flag = this.channel != null && this.isConnect;
        if (flag) {
            String separator = TextUtils.isEmpty((CharSequence)this.packetSeparator) ? System.getProperty("line.separator") : this.packetSeparator;
            ChannelFuture channelFuture = this.channel.writeAndFlush((Object)(data + separator)).awaitUninterruptibly();
            return channelFuture.isSuccess();
        }
        return false;
    }

    public boolean sendMsgToServer(byte[] data, final MessageStateListener listener) {
        boolean flag;
        boolean bl = flag = this.channel != null && this.isConnect;
        if (flag) {
            ByteBuf buf = Unpooled.copiedBuffer((byte[])data);
            this.channel.writeAndFlush((Object)buf).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture channelFuture) throws Exception {
                    listener.isSendSuccss(channelFuture.isSuccess());
                }
            });
        }
        return flag;
    }

    public boolean getConnectStatus() {
        return this.isConnect;
    }

    public boolean isConnecting() {
        return this.isConnecting;
    }

    public void setConnectStatus(boolean status) {
        this.isConnect = status;
    }

    public void setListener(NettyClientListener listener) {
        this.listener = listener;
    }

    public byte[] strToByteArray(String str) {
        if (str == null) {
            return null;
        }
        byte[] byteArray = str.getBytes();
        return byteArray;
    }

    public static class Builder {
        private int MAX_CONNECT_TIMES = Integer.MAX_VALUE;
        private long reconnectIntervalTime = 5000L;
        private String host;
        private int tcp_port;
        private int mIndex;
        private boolean isSendheartBeat;
        private long heartBeatInterval = 5L;
        private Object heartBeatData;
        private String packetSeparator;
        private int maxPacketLong = 1024;

        public Builder setPacketSeparator(String packetSeparator) {
            this.packetSeparator = packetSeparator;
            return this;
        }

        public Builder setMaxPacketLong(int maxPacketLong) {
            this.maxPacketLong = maxPacketLong;
            return this;
        }

        public Builder setMaxReconnectTimes(int reConnectTimes) {
            this.MAX_CONNECT_TIMES = reConnectTimes;
            return this;
        }

        public Builder setReconnectIntervalTime(long reconnectIntervalTime) {
            this.reconnectIntervalTime = reconnectIntervalTime;
            return this;
        }

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Builder setTcpPort(int tcp_port) {
            this.tcp_port = tcp_port;
            return this;
        }

        public Builder setIndex(int mIndex) {
            this.mIndex = mIndex;
            return this;
        }

        public Builder setHeartBeatInterval(long intervalTime) {
            this.heartBeatInterval = intervalTime;
            return this;
        }

        public Builder setSendheartBeat(boolean isSendheartBeat) {
            this.isSendheartBeat = isSendheartBeat;
            return this;
        }

        public Builder setHeartBeatData(Object heartBeatData) {
            this.heartBeatData = heartBeatData;
            return this;
        }

        public NettyTcpClient build() {
            NettyTcpClient nettyTcpClient = new NettyTcpClient(this.host, this.tcp_port, this.mIndex);
            nettyTcpClient.MAX_CONNECT_TIMES = this.MAX_CONNECT_TIMES;
            nettyTcpClient.reconnectIntervalTime = this.reconnectIntervalTime;
            nettyTcpClient.heartBeatInterval = this.heartBeatInterval;
            nettyTcpClient.isSendheartBeat = this.isSendheartBeat;
            nettyTcpClient.heartBeatData = this.heartBeatData;
            nettyTcpClient.packetSeparator = this.packetSeparator;
            nettyTcpClient.maxPacketLong = this.maxPacketLong;
            return nettyTcpClient;
        }
    }
}

