/*
 * Decompiled with CFR 0.152.
 */
package com.lishang.http.request;

import com.lishang.http.callback.UploadCallBack;
import com.lishang.http.request.BaseRequest;
import com.lishang.http.utils.LSLog;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;
import okio.ForwardingSink;
import okio.Okio;
import okio.Sink;

public class MultipartRequest
extends BaseRequest<MultipartRequest> {
    private Map<String, String> params = new HashMap<String, String>();
    private Map<String, FileWrapper> files = new HashMap<String, FileWrapper>();
    private UploadCallBack progressCallBack;

    public MultipartRequest addParams(String key, String value) {
        this.params.put(key, value);
        return this;
    }

    public MultipartRequest addFile(String key, File file) {
        this.files.put(key, new FileWrapper(file, file.getName()));
        return this;
    }

    public MultipartRequest progress(UploadCallBack progressCallBack) {
        this.progressCallBack = progressCallBack;
        return this;
    }

    private RequestBody createMultipartBody() {
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        if (!this.params.isEmpty()) {
            for (Map.Entry<String, String> entry : this.params.entrySet()) {
                builder.addFormDataPart(entry.getKey(), entry.getValue());
            }
        }
        if (!this.files.isEmpty()) {
            for (Map.Entry<String, Object> entry : this.files.entrySet()) {
                FileWrapper wrapper = (FileWrapper)entry.getValue();
                builder.addFormDataPart(entry.getKey(), wrapper.fileName, RequestBody.create((MediaType)wrapper.contentType, (File)wrapper.file));
            }
        }
        return builder.build();
    }

    @Override
    public Request generateRequest(Request.Builder builder) {
        return builder.post(this.createMultipartBody()).build();
    }

    @Override
    public void execute(Object obj) {
        this.mClient = this.mClient.newBuilder().addInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request original = chain.request();
                RequestBody body = original.body();
                if (body instanceof MultipartBody) {
                    body = new ProgressRequestBody((MultipartBody)body, new UploadProgressListener(){

                        @Override
                        public void onProgress(long total, long current) {
                            LSLog.i("onProgress upload:" + current + " / " + total);
                            if (MultipartRequest.this.progressCallBack != null) {
                                final int progress = (int)(100L * current / total);
                                MultipartRequest.this.runOnMainThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        MultipartRequest.this.progressCallBack.onLoading(progress);
                                    }
                                });
                            }
                        }
                    });
                }
                Request newRequest = original.newBuilder().method(original.method(), body).build();
                return chain.proceed(newRequest);
            }
        }).build();
        super.execute(obj);
    }

    static interface UploadProgressListener {
        public void onProgress(long var1, long var3);
    }

    private class ProgressRequestBody
    extends RequestBody {
        private MultipartBody mMultipartBody;
        private UploadProgressListener mProgressListener;

        public ProgressRequestBody(MultipartBody mMultipartBody, UploadProgressListener mProgressListener) {
            this.mMultipartBody = mMultipartBody;
            this.mProgressListener = mProgressListener;
        }

        public MediaType contentType() {
            return this.mMultipartBody.contentType();
        }

        public long contentLength() throws IOException {
            return this.mMultipartBody.contentLength();
        }

        public void writeTo(BufferedSink sink) throws IOException {
            ForwardingSink forwardingSink = new ForwardingSink((Sink)sink){
                final long totalLength;
                long mCurrentLength;
                {
                    this.totalLength = ProgressRequestBody.this.contentLength();
                }

                public void write(Buffer source, long byteCount) throws IOException {
                    this.mCurrentLength += byteCount;
                    if (ProgressRequestBody.this.mProgressListener != null) {
                        ProgressRequestBody.this.mProgressListener.onProgress(this.totalLength, this.mCurrentLength);
                    }
                    super.write(source, byteCount);
                }
            };
            BufferedSink bufferedSink = Okio.buffer((Sink)forwardingSink);
            this.mMultipartBody.writeTo(bufferedSink);
            bufferedSink.flush();
        }
    }

    public static class FileWrapper
    implements Serializable {
        private static final long serialVersionUID = -2356139899636767776L;
        public File file;
        public String fileName;
        public transient MediaType contentType;
        public long fileSize;

        public FileWrapper(File file, String fileName) {
            this.file = file;
            this.fileName = fileName;
            this.contentType = FileWrapper.guessMimeType(fileName);
            this.fileSize = file.length();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            out.writeObject(this.contentType.toString());
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.contentType = MediaType.parse((String)((String)in.readObject()));
        }

        public String toString() {
            return "FileWrapper{file=" + this.file + ", fileName=" + this.fileName + ", contentType=" + this.contentType + ", fileSize=" + this.fileSize + "}";
        }

        private static MediaType guessMimeType(String fileName) {
            FileNameMap fileNameMap = URLConnection.getFileNameMap();
            String contentType = fileNameMap.getContentTypeFor(fileName = fileName.replace("#", ""));
            if (contentType == null) {
                return MediaType.parse((String)"application/octet-stream");
            }
            return MediaType.parse((String)contentType);
        }
    }
}

