/*
 * Decompiled with CFR 0.152.
 */
package com.lishang.http.request;

import android.app.Activity;
import android.net.Uri;
import android.support.v4.app.Fragment;
import android.text.TextUtils;
import com.lishang.http.LSHttp;
import com.lishang.http.callback.JsonCallBack;
import com.lishang.http.callback.ResponseCallBack;
import com.lishang.http.exception.LSHttpException;
import com.lishang.http.lifecycle.LSHttpActivityLifecycleCallBacks;
import com.lishang.http.response.IConvertResponse;
import com.lishang.http.response.JsonConvertResponse;
import com.lishang.http.response.StringConvertResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public abstract class BaseRequest<T extends BaseRequest> {
    protected OkHttpClient mClient;
    protected LSHttpActivityLifecycleCallBacks lifecycleCallBacks;
    protected String url;
    protected Map<String, String> headers = new HashMap<String, String>();
    protected String tag;
    protected ResponseCallBack callBack;
    protected IConvertResponse convertResponse;

    public BaseRequest() {
        this.mClient = LSHttp.getInstance().getClient();
        this.lifecycleCallBacks = LSHttp.getInstance().getLifecycleCallBacks();
    }

    public ResponseCallBack getCallBack() {
        return this.callBack;
    }

    public T addHeader(String key, String value) {
        this.headers.put(key, value);
        return (T)this;
    }

    public T addHeaders(Map<String, String> map) {
        if (map != null) {
            this.headers.putAll(map);
        }
        return (T)this;
    }

    public T url(String url) {
        this.url = url;
        return (T)this;
    }

    public T tag(String tag) {
        this.tag = tag;
        return (T)this;
    }

    public T callback(ResponseCallBack callBack) {
        this.callBack = callBack;
        return (T)this;
    }

    public T convert(IConvertResponse convertResponse) {
        this.convertResponse = convertResponse;
        return (T)this;
    }

    public Headers createHeaders() {
        Headers.Builder builder = new Headers.Builder();
        for (String key : this.headers.keySet()) {
            builder.add(key, this.headers.get(key));
        }
        return builder.build();
    }

    public Request.Builder request() {
        Request.Builder builder = new Request.Builder().url(this.url).tag((Object)this.tag).headers(this.createHeaders());
        return builder;
    }

    public abstract Request generateRequest(Request.Builder var1);

    public void execute() {
        this.execute(null);
    }

    public void execute(final Object obj) {
        this.checkUrl();
        OkHttpClient client = this.mClient;
        Call call = client.newCall(this.generateRequest(this.request()));
        this.bindLifecycle(obj, call);
        call.enqueue(new Callback(){

            public void onFailure(Call call, final IOException e) {
                e.printStackTrace();
                if (call.isCanceled()) {
                    System.out.println("call is canceled");
                    return;
                }
                BaseRequest.this.runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        if (BaseRequest.this.callBack != null) {
                            BaseRequest.this.callBack.onFail(LSHttpException.handleException(e));
                        }
                    }
                });
                BaseRequest.this.removeLifecycle(obj, call);
            }

            public void onResponse(Call call, final Response response) throws IOException {
                if (response.isSuccessful()) {
                    BaseRequest.this.onConvertCallBack(response);
                } else {
                    BaseRequest.this.runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (BaseRequest.this.callBack != null) {
                                BaseRequest.this.callBack.onFail(new LSHttpException(1007, "\u8bf7\u6c42\u5931\u8d25\uff0c\u670d\u52a1\u5668\u5f00\u5c0f\u5dee...", response.code()));
                            }
                        }
                    });
                }
                BaseRequest.this.removeLifecycle(obj, call);
            }
        });
    }

    public void onConvertCallBack(Response response) {
        if (this.convertResponse != null) {
            this.convertResponse.setCallBack(this.callBack);
            this.convertResponse.convert(response);
        } else if (this.callBack != null) {
            if (this.callBack instanceof JsonCallBack) {
                JsonConvertResponse convertResponse = new JsonConvertResponse();
                convertResponse.setCallBack(this.callBack);
                convertResponse.convert(response);
            } else {
                StringConvertResponse convertResponse = new StringConvertResponse();
                convertResponse.setCallBack(this.callBack);
                convertResponse.convert(response);
            }
        }
    }

    public void checkUrl() {
        Uri uri;
        if (TextUtils.isEmpty((CharSequence)this.url)) {
            throw new NullPointerException("url is null");
        }
        String baseUrl = LSHttp.getInstance().getBaseUrl();
        if (!(TextUtils.isEmpty((CharSequence)baseUrl) || "http".equalsIgnoreCase((uri = Uri.parse((String)this.url)).getScheme()) || "https".equalsIgnoreCase(uri.getScheme()))) {
            this.url = baseUrl + this.url;
        }
    }

    public void runOnMainThread(Runnable runnable) {
        LSHttp.getInstance().runOnMainThread(runnable);
    }

    public void bindLifecycle(Object obj, Call call) {
        if (this.lifecycleCallBacks != null && obj != null && (obj instanceof Activity || obj instanceof Fragment)) {
            this.lifecycleCallBacks.put(obj.toString(), call);
        }
    }

    public void removeLifecycle(Object obj, Call call) {
        if (this.lifecycleCallBacks != null && obj != null) {
            this.lifecycleCallBacks.remove(obj.toString(), call);
        }
    }

    public OkHttpClient getClient() {
        return this.mClient;
    }

    public LSHttpActivityLifecycleCallBacks getLifecycleCallBacks() {
        return this.lifecycleCallBacks;
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getTag() {
        return this.tag;
    }

    public IConvertResponse getConvertResponse() {
        return this.convertResponse;
    }
}

