/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.mockito.inline;

import android.util.Log;
import com.android.dx.mockito.inline.InlineDexmakerMockMaker;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.mockito.invocation.MockHandler;
import org.mockito.mock.MockCreationSettings;
import org.mockito.plugins.InlineMockMaker;
import org.mockito.plugins.MockMaker;

public final class MockMakerMultiplexer
implements InlineMockMaker {
    private static final String LOG_TAG = MockMakerMultiplexer.class.getSimpleName();
    private static final MockMaker[] MOCK_MAKERS;

    public <T> T createMock(MockCreationSettings<T> settings, MockHandler handler) {
        for (MockMaker mockMaker : MOCK_MAKERS) {
            Object mock = mockMaker.createMock(settings, handler);
            if (mock == null) continue;
            return (T)mock;
        }
        return null;
    }

    public MockHandler getHandler(Object mock) {
        for (MockMaker mockMaker : MOCK_MAKERS) {
            MockHandler handler = mockMaker.getHandler(mock);
            if (handler == null) continue;
            return handler;
        }
        return null;
    }

    public void resetMock(Object mock, MockHandler newHandler, MockCreationSettings settings) {
        for (MockMaker mockMaker : MOCK_MAKERS) {
            mockMaker.resetMock(mock, newHandler, settings);
        }
    }

    public MockMaker.TypeMockability isTypeMockable(Class<?> type) {
        for (MockMaker mockMaker : MOCK_MAKERS) {
            MockMaker.TypeMockability mockability = mockMaker.isTypeMockable(type);
            if (mockability == null) continue;
            return mockability;
        }
        return null;
    }

    public void clearMock(Object mock) {
        for (MockMaker mockMaker : MOCK_MAKERS) {
            if (!(mockMaker instanceof InlineMockMaker)) continue;
            InlineMockMaker inlineMockMaker = (InlineMockMaker)mockMaker;
            inlineMockMaker.clearMock(mock);
        }
    }

    public void clearAllMocks() {
        for (MockMaker mockMaker : MOCK_MAKERS) {
            if (!(mockMaker instanceof InlineMockMaker)) continue;
            InlineMockMaker inlineMockMaker = (InlineMockMaker)mockMaker;
            inlineMockMaker.clearAllMocks();
        }
    }

    static {
        String[] potentialMockMakers = new String[]{"com.android.dx.mockito.inline.InlineStaticMockMaker", InlineDexmakerMockMaker.class.getName()};
        ArrayList<MockMaker> mockMakers = new ArrayList<MockMaker>();
        for (String potentialMockMaker : potentialMockMakers) {
            try {
                Class<?> mockMakerClass = Class.forName(potentialMockMaker);
                mockMakers.add((MockMaker)mockMakerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                if (potentialMockMaker.equals(InlineDexmakerMockMaker.class.getName())) {
                    Log.e((String)LOG_TAG, (String)("Could not init mockmaker " + potentialMockMaker), (Throwable)e);
                    continue;
                }
                Log.e((String)LOG_TAG, (String)("Could not init mockmaker " + potentialMockMaker));
            }
        }
        MOCK_MAKERS = mockMakers.toArray(new MockMaker[0]);
    }
}

