/*
 * Decompiled with CFR 0.152.
 */
package com.link_intersystems.jdbc;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;

public class ScopedDatabaseMetaData {
    private final DatabaseMetaData databaseMetaData;
    private final String catalog;
    private final String schemaPattern;

    public ScopedDatabaseMetaData(DatabaseMetaData databaseMetaData, String catalog, String schemaPattern) {
        this.databaseMetaData = Objects.requireNonNull(databaseMetaData);
        this.catalog = catalog;
        this.schemaPattern = schemaPattern;
    }

    public ResultSet getTables(String tableNamePattern) throws SQLException {
        return this.getTables(tableNamePattern, "TABLE");
    }

    public ResultSet getTables(String tableNamePattern, String ... tableTypes) throws SQLException {
        return this.databaseMetaData.getTables(this.catalog, this.schemaPattern, tableNamePattern, tableTypes);
    }

    public ResultSet getColumns(String tableNamePattern) throws SQLException {
        return this.getColumns(tableNamePattern, "%");
    }

    public ResultSet getColumns(String tableNamePattern, String columnNamePattern) throws SQLException {
        return this.databaseMetaData.getColumns(this.catalog, this.schemaPattern, tableNamePattern, columnNamePattern);
    }

    public ResultSet getExportedKeys(String tableNamePattern) throws SQLException {
        return this.databaseMetaData.getExportedKeys(this.catalog, this.schemaPattern, tableNamePattern);
    }

    public ResultSet getImportedKeys(String tableNamePattern) throws SQLException {
        return this.databaseMetaData.getImportedKeys(this.catalog, this.schemaPattern, tableNamePattern);
    }

    public ResultSet getPrimaryKeys(String tableNamePattern) throws SQLException {
        return this.databaseMetaData.getPrimaryKeys(this.catalog, this.schemaPattern, tableNamePattern);
    }
}

