/*
 * Decompiled with CFR 0.152.
 */
package com.link_intersystems.jdbc;

import java.util.Objects;

class QualifiedTableName {
    private String catalog;
    private String schema;
    private String tableName;

    public QualifiedTableName(String tableName) {
        this(null, tableName);
    }

    public QualifiedTableName(String schema, String tableName) {
        this(null, schema, tableName);
    }

    public QualifiedTableName(String catalog, String schema, String tableName) {
        this.catalog = catalog;
        this.schema = schema;
        this.tableName = Objects.requireNonNull(tableName);
        if (tableName.trim().isEmpty()) {
            throw new IllegalArgumentException("tableName must not be blank");
        }
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getTableName() {
        return this.tableName;
    }
}

