/*
 * Decompiled with CFR 0.152.
 */
package com.link_intersystems.jdbc;

import com.link_intersystems.jdbc.DefaultSqlTypeMapper;
import com.link_intersystems.jdbc.SqlTypeMapper;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ResultSetMap
extends AbstractMap<String, Object> {
    private Map<String, Object> map = new HashMap<String, Object>();

    public ResultSetMap(ResultSet resultSet) throws SQLException {
        this(resultSet, new DefaultSqlTypeMapper());
    }

    public ResultSetMap(ResultSet resultSet, SqlTypeMapper sqlTypeMapper) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        int columnCount = metaData.getColumnCount();
        for (int columnIndex = 1; columnIndex <= columnCount; ++columnIndex) {
            String columnName = metaData.getColumnName(columnIndex);
            this.map.put(columnName, sqlTypeMapper.toObject(resultSet, columnIndex));
        }
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return Collections.unmodifiableSet(this.map.entrySet());
    }
}

