/*
 * Decompiled with CFR 0.152.
 */
package com.link_intersystems.jdbc;

import com.link_intersystems.jdbc.SqlTypeMapper;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;

public class DefaultSqlTypeMapper
implements SqlTypeMapper {
    private BiFunction<ResultSet, Integer, ZoneId> zoneIdSupplier = (rs, columnIndex) -> ZoneId.systemDefault();
    private Map<Integer, SqlTypeMapper> sqlTypeMappers;

    public DefaultSqlTypeMapper() {
        HashMap<Integer, SqlTypeMapper> sqlTypeMappers = new HashMap<Integer, SqlTypeMapper>();
        this.initSqlTypeMappers(sqlTypeMappers);
        this.sqlTypeMappers = sqlTypeMappers;
    }

    public void setZoneId(ZoneId zoneId) {
        this.setZoneIdSupplier((rs, columnIndex) -> zoneId);
    }

    public void setZoneIdSupplier(BiFunction<ResultSet, Integer, ZoneId> zoneIdSupplier) {
        this.zoneIdSupplier = Objects.requireNonNull(zoneIdSupplier);
    }

    public Map<Integer, SqlTypeMapper> getSqlTypeMappers() {
        if (this.sqlTypeMappers == null) {
            HashMap<Integer, SqlTypeMapper> sqlTypeMappers = new HashMap<Integer, SqlTypeMapper>();
            this.initSqlTypeMappers(sqlTypeMappers);
            this.sqlTypeMappers = sqlTypeMappers;
        }
        return this.sqlTypeMappers;
    }

    protected void initSqlTypeMappers(Map<Integer, SqlTypeMapper> sqlTypeMappers) {
        sqlTypeMappers.put(-15, ResultSet::getString);
        sqlTypeMappers.put(1, ResultSet::getString);
        sqlTypeMappers.put(12, ResultSet::getString);
        sqlTypeMappers.put(-9, ResultSet::getString);
        sqlTypeMappers.put(-1, ResultSet::getString);
        sqlTypeMappers.put(-16, ResultSet::getString);
        sqlTypeMappers.put(2005, this::clobToString);
        sqlTypeMappers.put(2011, this::clobToString);
        sqlTypeMappers.put(-6, ResultSet::getByte);
        sqlTypeMappers.put(5, ResultSet::getShort);
        sqlTypeMappers.put(4, ResultSet::getInt);
        sqlTypeMappers.put(-5, ResultSet::getLong);
        sqlTypeMappers.put(6, ResultSet::getFloat);
        sqlTypeMappers.put(8, ResultSet::getDouble);
        sqlTypeMappers.put(3, ResultSet::getBigDecimal);
        sqlTypeMappers.put(2, ResultSet::getBigDecimal);
        sqlTypeMappers.put(16, ResultSet::getBoolean);
        sqlTypeMappers.put(-7, ResultSet::getBoolean);
        sqlTypeMappers.put(92, this::timeToLocalTime);
        sqlTypeMappers.put(91, this::dateToLocalDate);
        sqlTypeMappers.put(93, this::timestampToLocalDateTime);
        sqlTypeMappers.put(2014, this::offsetDateTime);
        sqlTypeMappers.put(2013, this::offsetTime);
        sqlTypeMappers.put(2004, this::blobToByteArray);
    }

    @Override
    public Object toObject(ResultSet resultSet, int columnIndex) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        int columnType = metaData.getColumnType(columnIndex);
        SqlTypeMapper sqlTypeMapper = this.sqlTypeMappers.getOrDefault(columnType, ResultSet::getObject);
        return sqlTypeMapper.toObject(resultSet, columnIndex);
    }

    public Object clobToString(ResultSet resultSet, int columnIndex) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        Clob clob = resultSet.getClob(columnIndex);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(clob.getAsciiStream()));){
            int read;
            char[] buff = new char[8192];
            while ((read = reader.read(buff)) > 0) {
                stringBuffer.append(buff, 0, read);
            }
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        return stringBuffer.toString();
    }

    public byte[] blobToByteArray(ResultSet resultSet, int columnIndex) throws SQLException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        Blob blob = resultSet.getBlob(columnIndex);
        try (BufferedInputStream in = new BufferedInputStream(blob.getBinaryStream());){
            int read;
            byte[] buff = new byte[8192];
            while ((read = ((InputStream)in).read(buff)) > 0) {
                bout.write(buff, 0, read);
            }
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        return bout.toByteArray();
    }

    public Object dateToLocalDate(ResultSet resultSet, int columnIndex) throws SQLException {
        Date date = resultSet.getDate(columnIndex);
        ZoneId zoneId = this.zoneIdSupplier.apply(resultSet, columnIndex);
        return Instant.ofEpochMilli(date.getTime()).atZone(zoneId).toLocalDate();
    }

    public Object timestampToLocalDateTime(ResultSet resultSet, int columnIndex) throws SQLException {
        Timestamp timestamp = resultSet.getTimestamp(columnIndex);
        ZoneId zoneId = this.zoneIdSupplier.apply(resultSet, columnIndex);
        return Instant.ofEpochMilli(timestamp.getTime()).atZone(zoneId).toLocalDateTime();
    }

    public Object timeToLocalTime(ResultSet resultSet, int columnIndex) throws SQLException {
        Time time = resultSet.getTime(columnIndex);
        ZoneId zoneId = this.zoneIdSupplier.apply(resultSet, columnIndex);
        return Instant.ofEpochMilli(time.getTime()).atZone(zoneId).toLocalTime();
    }

    public Object offsetTime(ResultSet resultSet, int columnIndex) throws SQLException {
        return resultSet.getObject(columnIndex, OffsetTime.class);
    }

    public Object offsetDateTime(ResultSet resultSet, int columnIndex) throws SQLException {
        return resultSet.getObject(columnIndex, OffsetDateTime.class);
    }
}

