/*
 * Decompiled with CFR 0.152.
 */
package com.link_intersystems.jdbc;

import com.link_intersystems.jdbc.ColumnDescription;
import com.link_intersystems.jdbc.ForeignKey;
import com.link_intersystems.jdbc.ForeignKeyEntry;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class TableReference {
    private final String name;
    private final Edge targetEdge;
    private final Edge sourceEdge;

    public static TableReference of(ForeignKey foreignKey) {
        String name = foreignKey.getName();
        Edge sourceEdge = TableReference.getSourceEdge(foreignKey);
        Edge targetEdge = TableReference.getTargetEdge(foreignKey);
        return new TableReference(name, sourceEdge, targetEdge);
    }

    private static Edge getTargetEdge(ForeignKey foreignKey) {
        return TableReference.getReferenceEdge(foreignKey, ForeignKeyEntry::getPkColumnDescription);
    }

    private static Edge getSourceEdge(ForeignKey foreignKey) {
        return TableReference.getReferenceEdge(foreignKey, ForeignKeyEntry::getFkColumnDescription);
    }

    private static Edge getReferenceEdge(ForeignKey foreignKey, Function<ForeignKeyEntry, ColumnDescription> columnDescriptionGetter) {
        ArrayList<String> columns = new ArrayList<String>();
        String tableName = null;
        for (ForeignKeyEntry entry : foreignKey) {
            ColumnDescription columnDescription = columnDescriptionGetter.apply(entry);
            columns.add(columnDescription.getColumnName());
            tableName = columnDescription.getTableName();
        }
        return new Edge(tableName, columns);
    }

    public TableReference(String name, Edge sourceEdge, Edge targetEdge) {
        this.name = Objects.requireNonNull(name);
        this.sourceEdge = Objects.requireNonNull(sourceEdge);
        this.targetEdge = Objects.requireNonNull(targetEdge);
    }

    public String getName() {
        return this.name;
    }

    public Edge getSourceEdge() {
        return this.sourceEdge;
    }

    public Edge getTargetEdge() {
        return this.targetEdge;
    }

    public TableReference reverse() {
        Direction direction = Direction.REVERSED;
        Edge sourceEdge = direction.getSourceEdge(this);
        Edge targetEdge = direction.getTargetEdge(this);
        return new TableReference(this.getName(), sourceEdge, targetEdge);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableReference that = (TableReference)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.targetEdge, that.targetEdge) && Objects.equals(this.sourceEdge, that.sourceEdge);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.targetEdge, this.sourceEdge);
    }

    public String toString() {
        return this.name + "<" + this.sourceEdge + " -> " + this.targetEdge + ">";
    }

    public static enum Direction {
        NATURAL{

            @Override
            public Edge getSourceEdge(TableReference dependency) {
                return dependency.getSourceEdge();
            }

            @Override
            public Edge getTargetEdge(TableReference dependency) {
                return dependency.getTargetEdge();
            }
        }
        ,
        REVERSED{

            @Override
            public Edge getSourceEdge(TableReference reference) {
                return reference.getTargetEdge();
            }

            @Override
            public Edge getTargetEdge(TableReference reference) {
                return reference.getSourceEdge();
            }
        };


        public abstract Edge getSourceEdge(TableReference var1);

        public abstract Edge getTargetEdge(TableReference var1);
    }

    public static class Edge {
        private String tableName;
        private List<String> columns = new ArrayList<String>();

        public Edge(String tableName, List<String> columns) {
            this.tableName = Objects.requireNonNull(tableName);
            if (columns.isEmpty()) {
                String msg = MessageFormat.format("Edge for table ''{0}'' must define at least one column, but was zero.", tableName);
                throw new IllegalArgumentException(msg);
            }
            this.columns.addAll(columns);
        }

        public String getTableName() {
            return this.tableName;
        }

        public List<String> getColumns() {
            return Collections.unmodifiableList(this.columns);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Edge edge = (Edge)o;
            return Objects.equals(this.tableName, edge.tableName) && Objects.equals(this.columns, edge.columns);
        }

        public int hashCode() {
            return Objects.hash(this.tableName, this.columns);
        }

        public String toString() {
            return this.tableName + "(" + this.getColumns() + ")";
        }
    }
}

