/*
 * Decompiled with CFR 0.152.
 */
package com.link_intersystems.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.function.Supplier;

public class PrimaryKeyColumn
implements Comparable<PrimaryKeyColumn> {
    private final String primaryKeyName;
    private final String catalogName;
    private final String schemaName;
    private final String tableName;
    private final String columnName;
    private final short keySequenceNumber;

    public PrimaryKeyColumn(ResultSet primaryKeyResultSet) throws SQLException {
        this.catalogName = primaryKeyResultSet.getString("TABLE_CAT");
        this.schemaName = primaryKeyResultSet.getString("TABLE_SCHEM");
        this.tableName = primaryKeyResultSet.getString("TABLE_NAME");
        this.columnName = primaryKeyResultSet.getString("COLUMN_NAME");
        this.keySequenceNumber = primaryKeyResultSet.getShort("KEY_SEQ");
        this.primaryKeyName = primaryKeyResultSet.getString("PK_NAME");
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getPrimaryKeyName() {
        return this.primaryKeyName;
    }

    public short getKeySequenceNumber() {
        return this.keySequenceNumber;
    }

    @Override
    public int compareTo(PrimaryKeyColumn o) {
        int catalogCompare = this.nullSafeCompare(this::getCatalogName, o::getCatalogName);
        if (catalogCompare != 0) {
            return catalogCompare;
        }
        int schemaCompare = this.nullSafeCompare(this::getSchemaName, o::getSchemaName);
        if (schemaCompare != 0) {
            return catalogCompare;
        }
        int tableCompare = this.nullSafeCompare(this::getTableName, o::getTableName);
        if (tableCompare != 0) {
            return catalogCompare;
        }
        return Short.valueOf(this.getKeySequenceNumber()).compareTo(o.getKeySequenceNumber());
    }

    private <T extends Comparable<T>> int nullSafeCompare(Supplier<T> supplier1, Supplier<T> supplier2) {
        Comparable o1 = (Comparable)supplier1.get();
        Comparable o2 = (Comparable)supplier2.get();
        if (o1 == null) {
            return o2 == null ? 0 : -1;
        }
        if (o2 == null) {
            return 1;
        }
        return o1.compareTo(o2);
    }
}

