/*
 * Decompiled with CFR 0.152.
 */
package com.link_intersystems.jdbc;

import com.link_intersystems.jdbc.QualifiedTableName;
import java.sql.ResultSet;
import java.sql.SQLException;

public class TableMetaData {
    private String catalog;
    private String schema;
    private String tableName;
    private String tableType;
    private String remarks;
    private String typeCatalog;
    private String typeSchama;
    private String typeName;
    private String selfReferencingColumnName;
    private String refGeneration;

    public TableMetaData(ResultSet tablesResultSet) throws SQLException {
        this.catalog = tablesResultSet.getString("TABLE_CAT");
        this.schema = tablesResultSet.getString("TABLE_SCHEM");
        this.tableName = tablesResultSet.getString("TABLE_NAME");
        this.tableType = tablesResultSet.getString("TABLE_TYPE");
        this.remarks = tablesResultSet.getString("REMARKS");
        this.typeCatalog = tablesResultSet.getString("TYPE_CAT");
        this.typeSchama = tablesResultSet.getString("TYPE_SCHEM");
        this.typeName = tablesResultSet.getString("TYPE_NAME");
        this.selfReferencingColumnName = tablesResultSet.getString("SELF_REFERENCING_COL_NAME");
        this.refGeneration = tablesResultSet.getString("REF_GENERATION");
    }

    public String getCatalogName() {
        return this.catalog;
    }

    public String getSchemaName() {
        return this.schema;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableType() {
        return this.tableType;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public String getTypeCatalog() {
        return this.typeCatalog;
    }

    public String getTypeSchama() {
        return this.typeSchama;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getSelfReferencingColumnName() {
        return this.selfReferencingColumnName;
    }

    public String getRefGeneration() {
        return this.refGeneration;
    }

    public boolean matches(QualifiedTableName qualifiedTableName) {
        String matchTableName = qualifiedTableName.getTableName();
        if (!this.getTableName().equals(matchTableName)) {
            return false;
        }
        String matchSchema = qualifiedTableName.getSchema();
        if (matchSchema != null && !this.getSchemaName().equals(matchSchema)) {
            return false;
        }
        String matchCatalog = qualifiedTableName.getCatalog();
        return matchCatalog == null || this.getCatalogName().equals(matchCatalog);
    }
}

