/*
 * Decompiled with CFR 0.152.
 */
package com.link_intersystems.jdbc;

import com.link_intersystems.jdbc.AmbiguousTableNameException;
import com.link_intersystems.jdbc.QualifiedTableName;
import com.link_intersystems.jdbc.ResultSetMappers;
import com.link_intersystems.jdbc.TableMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TableMetaDataList
extends AbstractList<TableMetaData> {
    private List<TableMetaData> tableMetaDataList;
    private Map<String, Collection<TableMetaData>> tableMetaDatasByName;

    public TableMetaDataList(ResultSet tablesResultSet) throws SQLException {
        this.tableMetaDataList = ResultSetMappers.TABLE_META_DATA_MAPPER.map(tablesResultSet);
    }

    public TableMetaDataList(List<TableMetaData> tableMetaData) {
        this.tableMetaDataList = new ArrayList<TableMetaData>(tableMetaData);
    }

    public TableMetaData getByName(String tableName) {
        return this.getByName(null, null, tableName);
    }

    public TableMetaData getByName(String schema, String tableName) {
        return this.getByName(null, schema, tableName);
    }

    public TableMetaData getByName(String catalog, String schema, String tableName) {
        return this.getByName(new QualifiedTableName(catalog, schema, tableName));
    }

    public TableMetaData getByName(QualifiedTableName qualifiedTableName) {
        List<TableMetaData> matchingTableMetaDatas = this.findMatchingTableMetaDatas(qualifiedTableName);
        if (matchingTableMetaDatas.isEmpty()) {
            return null;
        }
        if (matchingTableMetaDatas.size() > 1) {
            throw new AmbiguousTableNameException(qualifiedTableName.getTableName());
        }
        return matchingTableMetaDatas.get(0);
    }

    private List<TableMetaData> findMatchingTableMetaDatas(QualifiedTableName qualifiedTableName) {
        Map<String, Collection<TableMetaData>> tableMetasDataByName = this.getTableMetasDataByName();
        ArrayList<TableMetaData> matchingTableMetaDatas = new ArrayList<TableMetaData>();
        String tableName = qualifiedTableName.getTableName();
        Collection<TableMetaData> tableMetaDatas = tableMetasDataByName.get(tableName);
        for (TableMetaData tableMetaData : tableMetaDatas) {
            if (!tableMetaData.matches(qualifiedTableName)) continue;
            matchingTableMetaDatas.add(tableMetaData);
        }
        return matchingTableMetaDatas;
    }

    public Map<String, Collection<TableMetaData>> getTableMetasDataByName() {
        if (this.tableMetaDatasByName == null) {
            this.tableMetaDatasByName = new HashMap<String, Collection<TableMetaData>>();
            this.forEach(tm -> {
                Collection tableMetaDatas = this.tableMetaDatasByName.computeIfAbsent(tm.getTableName(), k -> new ArrayList());
                tableMetaDatas.add(tm);
            });
        }
        return this.tableMetaDatasByName;
    }

    @Override
    public TableMetaData get(int index) {
        return this.tableMetaDataList.get(index);
    }

    @Override
    public int size() {
        return this.tableMetaDataList.size();
    }

    private static class QualifiedTableNameMatch {
        private QualifiedTableName qualifiedTableName;

        public QualifiedTableNameMatch(QualifiedTableName qualifiedTableName) {
            this.qualifiedTableName = qualifiedTableName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QualifiedTableNameMatch that = (QualifiedTableNameMatch)o;
            return Objects.equals(this.qualifiedTableName, that.qualifiedTableName);
        }

        public int hashCode() {
            return Objects.hash(this.qualifiedTableName.getTableName());
        }
    }
}

