/*
 * Decompiled with CFR 0.152.
 */
package com.link_intersystems.jdbc;

import com.link_intersystems.jdbc.ColumnDescription;
import com.link_intersystems.jdbc.ColumnDescriptionEquality;
import com.link_intersystems.jdbc.ForeignKey;
import com.link_intersystems.jdbc.ForeignKeyEntry;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class ForeignKeyList
extends AbstractList<ForeignKey> {
    private List<ForeignKey> foreignKeyList;

    public ForeignKeyList(List<ForeignKey> foreignKeyList) {
        this.foreignKeyList = Objects.requireNonNull(foreignKeyList);
    }

    public ForeignKey getByName(String name) {
        return this.stream().filter(fk -> fk.getName().equals(name)).findFirst().orElse(null);
    }

    public ForeignKeyList getByPkColumnDescription(ColumnDescription ... columnDescriptions) {
        ArrayList<ForeignKey> result = new ArrayList<ForeignKey>();
        for (ForeignKey foreignKey : this) {
            ArrayList<ColumnDescription> descriptions = new ArrayList<ColumnDescription>(Arrays.asList(columnDescriptions));
            for (ForeignKeyEntry entry : foreignKey) {
                ColumnDescription entryDescription = entry.getPkColumnDescription();
                for (int i = 0; i < descriptions.size(); ++i) {
                    ColumnDescription columnDescription = (ColumnDescription)descriptions.get(i);
                    if (!ColumnDescriptionEquality.equals(entryDescription, columnDescription)) continue;
                    descriptions.remove(i);
                    --i;
                }
            }
            if (!descriptions.isEmpty()) continue;
            result.add(foreignKey);
        }
        return new ForeignKeyList(result);
    }

    public ForeignKey getByFkColumnDescription(ColumnDescription ... columnDescriptions) {
        return this.getByColumnDescription(ForeignKeyEntry::getFkColumnDescription, columnDescriptions);
    }

    private ForeignKey getByColumnDescription(Function<ForeignKeyEntry, ColumnDescription> descriptionSupplier, ColumnDescription ... columnDescriptions) {
        ForeignKey result = null;
        for (ForeignKey foreignKey : this) {
            ArrayList<ColumnDescription> descriptions = new ArrayList<ColumnDescription>(Arrays.asList(columnDescriptions));
            for (ForeignKeyEntry entry : foreignKey) {
                ColumnDescription entryDescription = descriptionSupplier.apply(entry);
                for (int i = 0; i < descriptions.size(); ++i) {
                    ColumnDescription columnDescription = (ColumnDescription)descriptions.get(i);
                    if (!ColumnDescriptionEquality.equals(entryDescription, columnDescription)) continue;
                    descriptions.remove(i);
                    --i;
                }
            }
            if (!descriptions.isEmpty()) continue;
            result = foreignKey;
            break;
        }
        return result;
    }

    @Override
    public ForeignKey get(int index) {
        return this.foreignKeyList.get(index);
    }

    @Override
    public int size() {
        return this.foreignKeyList.size();
    }
}

