/*
 * Decompiled with CFR 0.152.
 */
package com.link_intersystems.jdbc;

import com.link_intersystems.jdbc.ColumnMetaData;
import com.link_intersystems.jdbc.ColumnMetaDataList;
import com.link_intersystems.jdbc.ForeignKey;
import com.link_intersystems.jdbc.ForeignKeyEntry;
import com.link_intersystems.jdbc.ForeignKeyList;
import com.link_intersystems.jdbc.JdbcContext;
import com.link_intersystems.jdbc.PrimaryKey;
import com.link_intersystems.jdbc.PrimaryKeyColumn;
import com.link_intersystems.jdbc.ScopedDatabaseMetaData;
import com.link_intersystems.jdbc.TableMetaData;
import com.link_intersystems.jdbc.TableReference;
import com.link_intersystems.jdbc.TableReferenceList;
import com.link_intersystems.jdbc.TableReferenceMetaData;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ConnectionMetaData
implements TableReferenceMetaData {
    private List<TableMetaData> tableMetaDataList;
    private Map<String, ColumnMetaDataList> columnMetaDataListByTableName = new HashMap<String, ColumnMetaDataList>();
    private Map<String, PrimaryKey> primaryKeysByTableName = new HashMap<String, PrimaryKey>();
    private Map<String, ForeignKeyList> exportedForeignKeysByTableName = new HashMap<String, ForeignKeyList>();
    private Map<String, ForeignKeyList> importedForeignKeysByTableName = new HashMap<String, ForeignKeyList>();
    private Map<String, TableReferenceList> outgoingReferences = new HashMap<String, TableReferenceList>();
    private Map<String, TableReferenceList> incommingReferences = new HashMap<String, TableReferenceList>();
    private Connection connection;
    private String[] tableTypes;
    private JdbcContext context;

    public ConnectionMetaData(Connection connection) {
        this(connection, "TABLE");
    }

    public ConnectionMetaData(Connection connection, String ... tableTypes) {
        this(connection, (JdbcContext)null, tableTypes);
    }

    public ConnectionMetaData(Connection connection, JdbcContext context) {
        this(connection, context, "TABLE");
    }

    public ConnectionMetaData(Connection connection, JdbcContext context, String ... tableTypes) {
        this.connection = connection;
        this.context = context;
        this.tableTypes = tableTypes;
    }

    public List<TableMetaData> getTableMetaDataList() throws SQLException {
        if (this.tableMetaDataList == null) {
            ScopedDatabaseMetaData metaData = this.getScopedDatabaseMetaData();
            ResultSet tablesResultSet = metaData.getTables("%", this.tableTypes);
            this.tableMetaDataList = this.mapResultSet(tablesResultSet, TableMetaData::new);
        }
        return this.tableMetaDataList;
    }

    private ScopedDatabaseMetaData getScopedDatabaseMetaData() throws SQLException {
        DatabaseMetaData metaData = this.connection.getMetaData();
        JdbcContext context = this.getContext();
        return new ScopedDatabaseMetaData(metaData, context.getCatalog(), context.getSchema());
    }

    private JdbcContext getContext() throws SQLException {
        if (this.context == null) {
            JdbcContext.Builder builder = new JdbcContext.Builder();
            builder.setCatalog(this.connection.getCatalog());
            builder.setSchema(this.connection.getSchema());
            this.context = builder.build();
        }
        return this.context;
    }

    public TableMetaData getTableMetaData(String tableName) throws SQLException {
        return this.getTableMetaDataList().stream().filter(jtmd -> jtmd.getTableName().equals(tableName)).findFirst().orElse(null);
    }

    public List<ColumnMetaData> getColumnMetaDataList(TableMetaData jdbcTableMetaData) throws SQLException {
        return this.getColumnMetaDataList(jdbcTableMetaData.getTableName());
    }

    public PrimaryKey getPrimaryKey(String tableName) throws SQLException {
        if (!this.primaryKeysByTableName.containsKey(tableName)) {
            ColumnMetaDataList columnMetaDataList = this.getColumnMetaDataList(tableName);
            ScopedDatabaseMetaData metaData = this.getScopedDatabaseMetaData();
            ResultSet resultSet = metaData.getPrimaryKeys(tableName);
            List<PrimaryKeyColumn> primaryKeyColumns = this.mapResultSet(resultSet, PrimaryKeyColumn::new);
            PrimaryKey primaryKey = null;
            if (primaryKeyColumns.size() > 0) {
                Collections.sort(primaryKeyColumns);
                ArrayList<ColumnMetaData> pkColumnMetaData = new ArrayList<ColumnMetaData>();
                for (PrimaryKeyColumn primaryKeyColumn : primaryKeyColumns) {
                    ColumnMetaData pkColumn = columnMetaDataList.getByName(primaryKeyColumn.getColumnName());
                    pkColumnMetaData.add(pkColumn);
                }
                PrimaryKeyColumn primaryKeyColumn = primaryKeyColumns.get(0);
                String primaryKeyName = primaryKeyColumn.getPrimaryKeyName();
                primaryKey = new PrimaryKey(primaryKeyName, new ColumnMetaDataList(pkColumnMetaData));
            }
            this.primaryKeysByTableName.put(tableName, primaryKey);
        }
        return this.primaryKeysByTableName.get(tableName);
    }

    public ColumnMetaDataList getColumnMetaDataList(String tableName) throws SQLException {
        if (!this.columnMetaDataListByTableName.containsKey(tableName)) {
            List<ColumnMetaData> columnMetaDatas = this.createColumnMetaData(tableName);
            this.columnMetaDataListByTableName.put(tableName, new ColumnMetaDataList(columnMetaDatas));
        }
        return this.columnMetaDataListByTableName.get(tableName);
    }

    private List<ColumnMetaData> createColumnMetaData(String tableName) throws SQLException {
        ScopedDatabaseMetaData scopedDatabaseMetaData = this.getScopedDatabaseMetaData();
        ResultSet columnsMetaDataResultSet = scopedDatabaseMetaData.getColumns(tableName);
        return this.mapResultSet(columnsMetaDataResultSet, ColumnMetaData::new);
    }

    public ForeignKeyList getExportedKeys(String tableName) throws SQLException {
        if (!this.exportedForeignKeysByTableName.containsKey(tableName)) {
            ForeignKeyList foreignKeys = this.createForeignKeys(tableName);
            this.exportedForeignKeysByTableName.put(tableName, foreignKeys);
        }
        return this.exportedForeignKeysByTableName.get(tableName);
    }

    private ForeignKeyList createForeignKeys(String tableName) throws SQLException {
        ScopedDatabaseMetaData scopedDatabaseMetaData = this.getScopedDatabaseMetaData();
        ResultSet resultSet = scopedDatabaseMetaData.getExportedKeys(tableName);
        List<ForeignKeyEntry> jdbcForeignKeyEntries = this.mapResultSet(resultSet, ForeignKeyEntry::new);
        return new ForeignKeyList(this.mapToForeignKeys(jdbcForeignKeyEntries));
    }

    private List<ForeignKey> mapToForeignKeys(List<ForeignKeyEntry> jdbcForeignKeyEntries) {
        Map<String, List<ForeignKeyEntry>> foreignKeys = jdbcForeignKeyEntries.stream().collect(Collectors.groupingBy(ForeignKeyEntry::getFkName));
        return foreignKeys.values().stream().map(ForeignKey::new).collect(Collectors.toList());
    }

    public ForeignKeyList getImportedKeys(String tableName) throws SQLException {
        if (!this.importedForeignKeysByTableName.containsKey(tableName)) {
            ForeignKeyList foreignKeys = this.createImportedKeys(tableName);
            this.importedForeignKeysByTableName.put(tableName, foreignKeys);
        }
        return this.importedForeignKeysByTableName.get(tableName);
    }

    private ForeignKeyList createImportedKeys(String tableName) throws SQLException {
        ScopedDatabaseMetaData scopedDatabaseMetaData = this.getScopedDatabaseMetaData();
        ResultSet resultSet = scopedDatabaseMetaData.getImportedKeys(tableName);
        List<ForeignKeyEntry> jdbcForeignKeyEntries = this.mapResultSet(resultSet, ForeignKeyEntry::new);
        return new ForeignKeyList(this.mapToForeignKeys(jdbcForeignKeyEntries));
    }

    @Override
    public TableReferenceList getOutgoingReferences(String tableName) throws SQLException {
        if (!this.outgoingReferences.containsKey(tableName)) {
            ForeignKeyList importedKeys = this.getImportedKeys(tableName);
            List<TableReference> outgoing = importedKeys.stream().map(TableReference::of).collect(Collectors.toList());
            this.outgoingReferences.put(tableName, new TableReferenceList(outgoing));
        }
        return this.outgoingReferences.get(tableName);
    }

    @Override
    public TableReferenceList getIncomingReferences(String tableName) throws SQLException {
        if (!this.incommingReferences.containsKey(tableName)) {
            ForeignKeyList exportedKeys = this.getExportedKeys(tableName);
            List<TableReference> incoming = exportedKeys.stream().map(TableReference::of).collect(Collectors.toList());
            this.incommingReferences.put(tableName, new TableReferenceList(incoming));
        }
        return this.incommingReferences.get(tableName);
    }

    private <T> List<T> mapResultSet(ResultSet resultSet, ElementFactory<T> elementFactory) throws SQLException {
        ArrayList<T> mappedResultSet = new ArrayList<T>();
        while (resultSet.next()) {
            T element = elementFactory.apply(resultSet);
            mappedResultSet.add(element);
        }
        return mappedResultSet;
    }

    @FunctionalInterface
    private static interface ElementFactory<T> {
        public T apply(ResultSet var1) throws SQLException;
    }
}

