/*
 * Decompiled with CFR 0.152.
 */
package com.link_intersystems.jdbc;

import com.link_intersystems.jdbc.ColumnDescription;
import com.link_intersystems.jdbc.ColumnMetaData;
import com.link_intersystems.jdbc.ColumnMetaDataList;
import com.link_intersystems.jdbc.ConnectionMetaData;
import com.link_intersystems.jdbc.ForeignKey;
import com.link_intersystems.jdbc.ForeignKeyEntry;
import com.link_intersystems.jdbc.ForeignKeyList;
import com.link_intersystems.jdbc.JdbcContext;
import com.link_intersystems.jdbc.PrimaryKey;
import com.link_intersystems.jdbc.TableMetaData;
import com.link_intersystems.jdbc.TableReference;
import com.link_intersystems.jdbc.TableReferenceList;
import com.link_intersystems.test.UnitTest;
import com.link_intersystems.test.db.sakila.SakilaEmptyTestDBExtension;
import java.sql.Connection;
import java.sql.SQLException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={SakilaEmptyTestDBExtension.class})
@UnitTest
class ConnectionMetaDataTest {
    private ConnectionMetaData metaDataRepository;

    ConnectionMetaDataTest() {
    }

    @BeforeEach
    void setUp(Connection connection) {
        JdbcContext.Builder builder = new JdbcContext.Builder();
        builder.setSchema("sakila");
        JdbcContext jdbcContext = builder.build();
        this.metaDataRepository = new ConnectionMetaData(connection, jdbcContext);
    }

    @Test
    void tableMetaData() throws SQLException {
        TableMetaData actor = this.metaDataRepository.getTableMetaData("actor");
        Assertions.assertEquals((Object)"test", (Object)actor.getCatalogName());
        Assertions.assertEquals((Object)"sakila", (Object)actor.getSchemaName());
        Assertions.assertEquals((Object)"actor", (Object)actor.getTableName());
        Assertions.assertEquals((Object)"BASE TABLE", (Object)actor.getTableType());
        Assertions.assertEquals(null, (Object)actor.getTypeSchama());
        Assertions.assertEquals(null, (Object)actor.getTypeCatalog());
        Assertions.assertEquals(null, (Object)actor.getTypeName());
        Assertions.assertEquals(null, (Object)actor.getSelfReferencingColumnName());
        Assertions.assertEquals(null, (Object)actor.getRefGeneration());
        Assertions.assertEquals(null, (Object)actor.getRemarks());
    }

    @Test
    void primaryKey() throws SQLException {
        PrimaryKey primaryKey = this.metaDataRepository.getPrimaryKey("film_actor");
        Assertions.assertEquals((int)2, (int)primaryKey.size());
        Assertions.assertEquals((Object)"actor_id", (Object)primaryKey.get(0).getColumnName());
        Assertions.assertEquals((Object)"film_id", (Object)primaryKey.get(1).getColumnName());
        Assertions.assertEquals((Object)"pk_film_actor", (Object)primaryKey.getName());
    }

    @Test
    void columnMetaData() throws SQLException {
        ColumnMetaDataList columnMetaDataList = this.metaDataRepository.getColumnMetaDataList("film");
        Assertions.assertEquals((int)13, (int)columnMetaDataList.size());
        ColumnMetaData id = columnMetaDataList.getByName("film_id");
        Assertions.assertEquals((Object)"NO", (Object)id.getIsAutoincrement());
        Assertions.assertEquals((Object)"NO", (Object)id.getIsGeneratedColumn());
        ColumnMetaData title = columnMetaDataList.getByName("title");
        Assertions.assertEquals((int)12, (int)title.getDataType());
        Assertions.assertEquals((int)255, (int)title.getColumnSize());
        Assertions.assertEquals((Object)"NO", (Object)title.getIsNullable());
        Assertions.assertEquals((int)0, (int)title.getNullable());
        Assertions.assertEquals((Object)"test", (Object)title.getCatalogName());
        Assertions.assertEquals((Object)"sakila", (Object)title.getSchemaName());
        Assertions.assertEquals((Object)"film", (Object)title.getTableName());
        ColumnMetaData replacementCost = columnMetaDataList.getByName("replacement_cost");
        Assertions.assertEquals((int)2, (int)replacementCost.getDecimalDigits());
        ColumnMetaData lastUpdate = columnMetaDataList.getByName("last_update");
        Assertions.assertEquals((Object)"CURRENT_TIMESTAMP", (Object)lastUpdate.getColumnDefaultValue());
    }

    @Test
    void foreignKey() throws SQLException {
        ForeignKeyList foreignKeys = this.metaDataRepository.getImportedKeys("film_actor");
        Assertions.assertEquals((int)2, (int)foreignKeys.size());
        ForeignKey fk_film_actor_actor = foreignKeys.getByName("fk_film_actor_actor");
        Assertions.assertEquals((int)1, (int)fk_film_actor_actor.size());
        ForeignKeyEntry foreignKeyEntry = fk_film_actor_actor.get(0);
        Assertions.assertEquals((Object)"actor_id", (Object)foreignKeyEntry.getFkColumnName());
        Assertions.assertEquals((Object)"film_actor", (Object)foreignKeyEntry.getFkTableName());
        Assertions.assertEquals((Object)"fk_film_actor_actor", (Object)foreignKeyEntry.getFkName());
        Assertions.assertEquals((Object)"actor_id", (Object)foreignKeyEntry.getPkColumnName());
        Assertions.assertEquals((Object)"actor", (Object)foreignKeyEntry.getPkTableName());
        Assertions.assertEquals((Object)"pk_actor", (Object)foreignKeyEntry.getPkName());
    }

    @Test
    void foreignKeyByColumnDescription() throws SQLException {
        ForeignKeyList foreignKeys = this.metaDataRepository.getImportedKeys("film_actor");
        ColumnMetaDataList filmActorColumns = this.metaDataRepository.getColumnMetaDataList("film_actor");
        ForeignKey foreignKey = foreignKeys.getByFkColumnDescription(new ColumnDescription[]{filmActorColumns.getByName("actor_id")});
        Assertions.assertNotNull((Object)foreignKey);
        Assertions.assertEquals((Object)"fk_film_actor_actor", (Object)foreignKey.getName());
        ColumnMetaDataList actorColumns = this.metaDataRepository.getColumnMetaDataList("actor");
        ForeignKeyList foreignKeyList = foreignKeys.getByPkColumnDescription(new ColumnDescription[]{actorColumns.getByName("actor_id")});
        Assertions.assertNotNull((Object)foreignKeyList);
        Assertions.assertEquals((int)1, (int)foreignKeyList.size());
        Assertions.assertNotNull((Object)foreignKeyList.getByName("fk_film_actor_actor"));
    }

    @Test
    void importedForeignKeys() throws SQLException {
        ForeignKeyList foreignKeys = this.metaDataRepository.getImportedKeys("film_actor");
        Assertions.assertEquals((int)2, (int)foreignKeys.size());
        ColumnMetaDataList columnMetaDataList = this.metaDataRepository.getColumnMetaDataList("film_actor");
        ColumnMetaData actorIdColumn = columnMetaDataList.getByName("actor_id");
        ForeignKey foreignKey = foreignKeys.getByFkColumnDescription(new ColumnDescription[]{actorIdColumn});
        Assertions.assertNotNull((Object)foreignKey);
        Assertions.assertEquals((Object)"fk_film_actor_actor", (Object)foreignKey.getName());
    }

    @Test
    void exportedForeignKeys() throws SQLException {
        ForeignKeyList foreignKeys = this.metaDataRepository.getExportedKeys("actor");
        Assertions.assertEquals((int)2, (int)foreignKeys.size());
        ColumnMetaDataList columnMetaDataList = this.metaDataRepository.getColumnMetaDataList("actor");
        ColumnMetaData actorIdColumn = columnMetaDataList.getByName("actor_id");
        ForeignKeyList foreignKeyList = foreignKeys.getByPkColumnDescription(new ColumnDescription[]{actorIdColumn});
        Assertions.assertNotNull((Object)foreignKeyList);
        Assertions.assertEquals((int)2, (int)foreignKeyList.size());
        Assertions.assertNotNull((Object)foreignKeyList.getByName("fk_film_actor_actor"));
        Assertions.assertNotNull((Object)foreignKeyList.getByName("fk_actor_genre_actor"));
    }

    @Test
    void outgoingReferences() throws SQLException {
        TableReferenceList outgoingReferences = this.metaDataRepository.getOutgoingReferences("film_actor");
        Assertions.assertEquals((int)2, (int)outgoingReferences.size());
        Assertions.assertNotNull((Object)outgoingReferences.getByName("fk_film_actor_actor"));
        TableReference fkFilmActorFilm = outgoingReferences.getByName("fk_film_actor_film");
        Assertions.assertNotNull((Object)fkFilmActorFilm);
        TableReference.Edge sourceEdge = fkFilmActorFilm.getSourceEdge();
        Assertions.assertEquals((Object)"film_actor", (Object)sourceEdge.getTableName());
        Assertions.assertEquals((int)1, (int)sourceEdge.getColumns().size());
        Assertions.assertEquals((Object)"film_id", sourceEdge.getColumns().get(0));
        TableReference.Edge targetEdge = fkFilmActorFilm.getTargetEdge();
        Assertions.assertEquals((Object)"film", (Object)targetEdge.getTableName());
        Assertions.assertEquals((int)1, (int)targetEdge.getColumns().size());
        Assertions.assertEquals((Object)"film_id", targetEdge.getColumns().get(0));
    }

    @Test
    void incomingReferences() throws SQLException {
        TableReferenceList incomingReferences = this.metaDataRepository.getIncomingReferences("actor");
        Assertions.assertEquals((int)2, (int)incomingReferences.size());
        TableReference fkFilmActorActor = incomingReferences.getByName("fk_film_actor_actor");
        Assertions.assertNotNull((Object)fkFilmActorActor);
        Assertions.assertNotNull((Object)incomingReferences.getByName("fk_actor_genre_actor"));
        TableReference.Edge sourceEdge = fkFilmActorActor.getSourceEdge();
        Assertions.assertEquals((Object)"film_actor", (Object)sourceEdge.getTableName());
        Assertions.assertEquals((int)1, (int)sourceEdge.getColumns().size());
        Assertions.assertEquals((Object)"actor_id", sourceEdge.getColumns().get(0));
        TableReference.Edge targetEdge = fkFilmActorActor.getTargetEdge();
        Assertions.assertEquals((Object)"actor", (Object)targetEdge.getTableName());
        Assertions.assertEquals((int)1, (int)targetEdge.getColumns().size());
        Assertions.assertEquals((Object)"actor_id", targetEdge.getColumns().get(0));
    }

    @Test
    void tableReferenceEqual() throws SQLException {
        TableReferenceList incomingReferences = this.metaDataRepository.getIncomingReferences("actor");
        TableReferenceList outgoingReferences = this.metaDataRepository.getOutgoingReferences("film_actor");
        Assertions.assertEquals((Object)outgoingReferences.getByName("fk_film_actor_actor"), (Object)incomingReferences.getByName("fk_film_actor_actor"));
    }

    @Test
    void tableReferenceToString() throws SQLException {
        TableReferenceList outgoingReferences = this.metaDataRepository.getOutgoingReferences("film_actor");
        Assertions.assertEquals((Object)"fk_film_actor_actor<film_actor([actor_id]) -> actor([actor_id])>", (Object)outgoingReferences.getByName("fk_film_actor_actor").toString());
    }
}

