/*
 * Decompiled with CFR 0.152.
 */
package com.link_intersystems.jdbc;

import com.link_intersystems.jdbc.ColumnDescription;
import com.link_intersystems.jdbc.ColumnDescriptionEquality;
import com.link_intersystems.jdbc.DefaultColumnDescription;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ColumnDescriptionEqualityTest {
    private ColumnDescription desc1;
    private ColumnDescription desc2;
    private ColumnDescription notEqualDesc;

    ColumnDescriptionEqualityTest() {
    }

    @BeforeEach
    void setUp() {
        this.desc1 = new DefaultColumnDescription.Builder().setCatalogName("catalogName").setSchemaName("schemaName").setTableName("tableName").setColumnName("columnName").build();
        this.desc2 = new DefaultColumnDescription.Builder().setCatalogName("catalogName").setSchemaName("schemaName").setTableName("tableName").setColumnName("columnName").build();
        this.notEqualDesc = new DefaultColumnDescription.Builder().setCatalogName("catalog").setSchemaName("schema").setTableName("table").setColumnName("column").build();
    }

    @Test
    void testStaticEquals() {
        Assertions.assertTrue((boolean)ColumnDescriptionEquality.equals((ColumnDescription)this.desc1, (ColumnDescription)this.desc1));
        Assertions.assertTrue((boolean)ColumnDescriptionEquality.equals((ColumnDescription)this.desc1, (ColumnDescription)this.desc2));
        Assertions.assertTrue((boolean)ColumnDescriptionEquality.equals((ColumnDescription)this.desc2, (ColumnDescription)this.desc1));
        Assertions.assertTrue((boolean)ColumnDescriptionEquality.equals((ColumnDescription)this.desc2, (ColumnDescription)this.desc2));
        Assertions.assertFalse((boolean)ColumnDescriptionEquality.equals((ColumnDescription)this.desc1, (ColumnDescription)this.notEqualDesc));
        Assertions.assertFalse((boolean)ColumnDescriptionEquality.equals((ColumnDescription)this.notEqualDesc, (ColumnDescription)this.desc1));
    }

    @Test
    void testEquals() {
        ColumnDescriptionEquality desc1Equality = new ColumnDescriptionEquality(this.desc1);
        Assertions.assertTrue((boolean)desc1Equality.equalsDescription(this.desc2));
        Assertions.assertFalse((boolean)desc1Equality.equalsDescription(this.notEqualDesc));
    }
}

