/*
 * Decompiled with CFR 0.152.
 */
package com.link_intersystems.jdbc;

import com.link_intersystems.jdbc.ColumnDescription;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ForeignKeyEntry {
    private String pkTableCategory;
    private String pkSchema;
    private String pkTableName;
    private String pkColumnName;
    private String fkTableCategory;
    private String fkSchema;
    private String fkTableName;
    private String fkColumnName;
    private short updateRule;
    private short deleteRule;
    private String fkName;
    private String pkName;
    private final short deferability;

    public ForeignKeyEntry(ResultSet foreignKeyResultSet) throws SQLException {
        this.pkTableCategory = foreignKeyResultSet.getString("PKTABLE_CAT");
        this.pkSchema = foreignKeyResultSet.getString("PKTABLE_SCHEM");
        this.pkTableName = foreignKeyResultSet.getString("PKTABLE_NAME");
        this.pkColumnName = foreignKeyResultSet.getString("PKCOLUMN_NAME");
        this.fkTableCategory = foreignKeyResultSet.getString("FKTABLE_CAT");
        this.fkSchema = foreignKeyResultSet.getString("FKTABLE_SCHEM");
        this.fkTableName = foreignKeyResultSet.getString("FKTABLE_NAME");
        this.fkColumnName = foreignKeyResultSet.getString("FKCOLUMN_NAME");
        this.updateRule = foreignKeyResultSet.getShort("UPDATE_RULE");
        this.deleteRule = foreignKeyResultSet.getShort("DELETE_RULE");
        this.fkName = foreignKeyResultSet.getString("FK_NAME");
        this.pkName = foreignKeyResultSet.getString("PK_NAME");
        this.deferability = foreignKeyResultSet.getShort("DEFERRABILITY");
    }

    public String getPkCategory() {
        return this.pkTableCategory;
    }

    public String getPkSchema() {
        return this.pkSchema;
    }

    public String getPkTableName() {
        return this.pkTableName;
    }

    public String getPkColumnName() {
        return this.pkColumnName;
    }

    public String getFkCategory() {
        return this.fkTableCategory;
    }

    public String getFkSchema() {
        return this.fkSchema;
    }

    public String getFkTableName() {
        return this.fkTableName;
    }

    public String getFkColumnName() {
        return this.fkColumnName;
    }

    public short getUpdateRule() {
        return this.updateRule;
    }

    public short getDeleteRule() {
        return this.deleteRule;
    }

    public String getFkName() {
        return this.fkName;
    }

    public String getPkName() {
        return this.pkName;
    }

    public short getDeferability() {
        return this.deferability;
    }

    boolean isSameForeignKey(ForeignKeyEntry jdbcForeignKeyEntry) {
        return this.getFkName().equals(jdbcForeignKeyEntry.getFkName());
    }

    public String toString() {
        return "JdbcForeignKeyEntry{fkTableCategory='" + this.fkTableCategory + '\'' + ", fkTableSchema='" + this.fkSchema + '\'' + ", fkTableName='" + this.fkTableName + '\'' + ", fkColumnName='" + this.fkColumnName + '\'' + '}';
    }

    public ColumnDescription getPkColumnDescription() {
        return new ColumnDescription(){

            @Override
            public String getCatalogName() {
                return ForeignKeyEntry.this.getPkCategory();
            }

            @Override
            public String getSchemaName() {
                return ForeignKeyEntry.this.getPkSchema();
            }

            @Override
            public String getTableName() {
                return ForeignKeyEntry.this.getPkTableName();
            }

            @Override
            public String getColumnName() {
                return ForeignKeyEntry.this.getPkColumnName();
            }
        };
    }

    public ColumnDescription getFkColumnDescription() {
        return new ColumnDescription(){

            @Override
            public String getCatalogName() {
                return ForeignKeyEntry.this.getFkCategory();
            }

            @Override
            public String getSchemaName() {
                return ForeignKeyEntry.this.getFkSchema();
            }

            @Override
            public String getTableName() {
                return ForeignKeyEntry.this.getFkTableName();
            }

            @Override
            public String getColumnName() {
                return ForeignKeyEntry.this.getFkColumnName();
            }
        };
    }
}

