/*
 * Decompiled with CFR 0.152.
 */
package com.link_intersystems.jdbc;

import com.link_intersystems.jdbc.ForeignKeyEntry;
import java.text.MessageFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;

public class ForeignKey
extends AbstractList<ForeignKeyEntry> {
    private List<ForeignKeyEntry> foreignKeyEntryList = new ArrayList<ForeignKeyEntry>();

    public ForeignKey(List<ForeignKeyEntry> foreignKeyEntryList) {
        if (foreignKeyEntryList.isEmpty()) {
            throw new IllegalArgumentException("foreignKeyEntryList must not be empty");
        }
        ForeignKeyEntry mainFkEntry = null;
        for (ForeignKeyEntry jdbcForeignKeyEntry : foreignKeyEntryList) {
            if (mainFkEntry == null) {
                mainFkEntry = jdbcForeignKeyEntry;
                continue;
            }
            if (mainFkEntry.isSameForeignKey(jdbcForeignKeyEntry)) continue;
            String msg = MessageFormat.format("foreignKeyEntryList contains different foreign keys: {0} != {1}", mainFkEntry, jdbcForeignKeyEntry);
            throw new IllegalArgumentException(msg);
        }
        this.foreignKeyEntryList.addAll(foreignKeyEntryList);
    }

    @Override
    public ForeignKeyEntry get(int index) {
        return this.foreignKeyEntryList.get(index);
    }

    @Override
    public int size() {
        return this.foreignKeyEntryList.size();
    }

    public String getName() {
        return this.get(0).getFkName();
    }
}

