/*
 * Decompiled with CFR 0.152.
 */
package com.link_intersystems.jdbc;

import com.link_intersystems.jdbc.ColumnDescription;
import com.link_intersystems.jdbc.ColumnMetaData;
import com.link_intersystems.jdbc.ColumnMetaDataList;
import com.link_intersystems.jdbc.ConnectionMetaData;
import com.link_intersystems.jdbc.ForeignKey;
import com.link_intersystems.jdbc.ForeignKeyEntry;
import com.link_intersystems.jdbc.ForeignKeyList;
import com.link_intersystems.jdbc.JdbcContext;
import com.link_intersystems.jdbc.PrimaryKey;
import com.link_intersystems.jdbc.TableMetaData;
import com.link_intersystems.test.UnitTest;
import com.link_intersystems.test.db.sakila.SakilaTestDBExtension;
import java.sql.Connection;
import java.sql.SQLException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={SakilaTestDBExtension.class})
@UnitTest
class ConnectionMetaDataTest {
    private ConnectionMetaData metaDataRepository;

    ConnectionMetaDataTest() {
    }

    @BeforeEach
    void setUp(Connection connection) {
        JdbcContext.Builder builder = new JdbcContext.Builder();
        builder.setSchema("sakila");
        JdbcContext jdbcContext = builder.build();
        this.metaDataRepository = new ConnectionMetaData(connection, jdbcContext);
    }

    @Test
    void tableMetaData() throws SQLException {
        TableMetaData actor = this.metaDataRepository.getTableMetaData("actor");
        Assertions.assertEquals((Object)"sakila", (Object)actor.getSchemaName());
        Assertions.assertEquals((Object)"actor", (Object)actor.getTableName());
    }

    @Test
    void primaryKey() throws SQLException {
        PrimaryKey primaryKey = this.metaDataRepository.getPrimaryKey("film_actor");
        Assertions.assertEquals((int)2, (int)primaryKey.size());
        Assertions.assertEquals((Object)"actor_id", (Object)primaryKey.get(0).getColumnName());
        Assertions.assertEquals((Object)"film_id", (Object)primaryKey.get(1).getColumnName());
    }

    @Test
    void columnMetaData() throws SQLException {
        ColumnMetaDataList actorColumnMetaData = this.metaDataRepository.getColumnMetaDataList("actor");
        Assertions.assertEquals((int)4, (int)actorColumnMetaData.size());
        ColumnMetaData firstNameColumnMetaData = actorColumnMetaData.getByName("first_name");
        Assertions.assertEquals((int)12, (int)firstNameColumnMetaData.getDataType());
        Assertions.assertEquals((int)45, (int)firstNameColumnMetaData.getColumnSize());
        Assertions.assertEquals((Object)"NO", (Object)firstNameColumnMetaData.getIsNullable());
        Assertions.assertEquals((int)0, (int)firstNameColumnMetaData.getNullable());
    }

    @Test
    void foreignKey() throws SQLException {
        ForeignKeyList foreignKeys = this.metaDataRepository.getImportedKeys("film_actor");
        Assertions.assertEquals((int)2, (int)foreignKeys.size());
        ForeignKey fk_film_actor_actor = foreignKeys.stream().filter(fk -> fk.getName().equals("fk_film_actor_actor")).findFirst().orElse(null);
        Assertions.assertEquals((int)1, (int)fk_film_actor_actor.size());
        ForeignKeyEntry foreignKeyEntry = fk_film_actor_actor.get(0);
        Assertions.assertEquals((Object)"actor_id", (Object)foreignKeyEntry.getFkColumnName());
        Assertions.assertEquals((Object)"film_actor", (Object)foreignKeyEntry.getFkTableName());
        Assertions.assertEquals((Object)"actor_id", (Object)foreignKeyEntry.getPkColumnName());
        Assertions.assertEquals((Object)"actor", (Object)foreignKeyEntry.getPkTableName());
    }

    @Test
    void foreignKeyByColumnDescription() throws SQLException {
        ForeignKeyList foreignKeys = this.metaDataRepository.getImportedKeys("film_actor");
        ColumnMetaDataList filmActorColumns = this.metaDataRepository.getColumnMetaDataList("film_actor");
        ForeignKey foreignKey = foreignKeys.getByFkColumnDescription(new ColumnDescription[]{filmActorColumns.getByName("actor_id")});
        Assertions.assertNotNull((Object)foreignKey);
        Assertions.assertEquals((Object)"fk_film_actor_actor", (Object)foreignKey.getName());
        ColumnMetaDataList actorColumns = this.metaDataRepository.getColumnMetaDataList("actor");
        foreignKey = foreignKeys.getByPkColumnDescription(new ColumnDescription[]{actorColumns.getByName("actor_id")});
        Assertions.assertNotNull((Object)foreignKey);
        Assertions.assertEquals((Object)"fk_film_actor_actor", (Object)foreignKey.getName());
    }

    @Test
    void foreignKeys() throws SQLException {
        ForeignKeyList foreignKeys = this.metaDataRepository.getImportedKeys("film_actor");
        Assertions.assertEquals((int)2, (int)foreignKeys.size());
        ColumnMetaDataList columnMetaDataList = this.metaDataRepository.getColumnMetaDataList("actor");
        ColumnMetaData actorIdColumn = columnMetaDataList.getByName("actor_id");
        ForeignKey foreignKey = foreignKeys.getByPkColumnDescription(new ColumnDescription[]{actorIdColumn});
        Assertions.assertNotNull((Object)foreignKey);
        Assertions.assertEquals((Object)"fk_film_actor_actor", (Object)foreignKey.getName());
    }
}

