/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.model.message;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.linecorp.bot.model.message.Message;
import com.linecorp.bot.model.message.quickreply.QuickReply;
import com.linecorp.bot.model.message.sender.Sender;
import lombok.Generated;

@JsonTypeName(value="location")
@JsonDeserialize(builder=LocationMessageBuilder.class)
public final class LocationMessage
implements Message {
    private final String title;
    private final String address;
    private final double latitude;
    private final double longitude;
    private final QuickReply quickReply;
    private final Sender sender;

    public LocationMessage(String title, String address, double latitude, double longitude) {
        this(title, address, latitude, longitude, null, null);
    }

    @Generated
    public static LocationMessageBuilder builder() {
        return new LocationMessageBuilder();
    }

    @Generated
    public LocationMessageBuilder toBuilder() {
        return new LocationMessageBuilder().title(this.title).address(this.address).latitude(this.latitude).longitude(this.longitude).quickReply(this.quickReply).sender(this.sender);
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getAddress() {
        return this.address;
    }

    @Generated
    public double getLatitude() {
        return this.latitude;
    }

    @Generated
    public double getLongitude() {
        return this.longitude;
    }

    @Override
    @Generated
    public QuickReply getQuickReply() {
        return this.quickReply;
    }

    @Override
    @Generated
    public Sender getSender() {
        return this.sender;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LocationMessage)) {
            return false;
        }
        LocationMessage other = (LocationMessage)o;
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        if (Double.compare(this.getLatitude(), other.getLatitude()) != 0) {
            return false;
        }
        if (Double.compare(this.getLongitude(), other.getLongitude()) != 0) {
            return false;
        }
        QuickReply this$quickReply = this.getQuickReply();
        QuickReply other$quickReply = other.getQuickReply();
        if (this$quickReply == null ? other$quickReply != null : !((Object)this$quickReply).equals(other$quickReply)) {
            return false;
        }
        Sender this$sender = this.getSender();
        Sender other$sender = other.getSender();
        return !(this$sender == null ? other$sender != null : !((Object)this$sender).equals(other$sender));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        long $latitude = Double.doubleToLongBits(this.getLatitude());
        result = result * 59 + (int)($latitude >>> 32 ^ $latitude);
        long $longitude = Double.doubleToLongBits(this.getLongitude());
        result = result * 59 + (int)($longitude >>> 32 ^ $longitude);
        QuickReply $quickReply = this.getQuickReply();
        result = result * 59 + ($quickReply == null ? 43 : ((Object)$quickReply).hashCode());
        Sender $sender = this.getSender();
        result = result * 59 + ($sender == null ? 43 : ((Object)$sender).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LocationMessage(title=" + this.getTitle() + ", address=" + this.getAddress() + ", latitude=" + this.getLatitude() + ", longitude=" + this.getLongitude() + ", quickReply=" + this.getQuickReply() + ", sender=" + this.getSender() + ")";
    }

    @Generated
    private LocationMessage(String title, String address, double latitude, double longitude, QuickReply quickReply, Sender sender) {
        this.title = title;
        this.address = address;
        this.latitude = latitude;
        this.longitude = longitude;
        this.quickReply = quickReply;
        this.sender = sender;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class LocationMessageBuilder {
        @Generated
        private String title;
        @Generated
        private String address;
        @Generated
        private double latitude;
        @Generated
        private double longitude;
        @Generated
        private QuickReply quickReply;
        @Generated
        private Sender sender;

        @Generated
        LocationMessageBuilder() {
        }

        @Generated
        public LocationMessageBuilder title(String title) {
            this.title = title;
            return this;
        }

        @Generated
        public LocationMessageBuilder address(String address) {
            this.address = address;
            return this;
        }

        @Generated
        public LocationMessageBuilder latitude(double latitude) {
            this.latitude = latitude;
            return this;
        }

        @Generated
        public LocationMessageBuilder longitude(double longitude) {
            this.longitude = longitude;
            return this;
        }

        @Generated
        public LocationMessageBuilder quickReply(QuickReply quickReply) {
            this.quickReply = quickReply;
            return this;
        }

        @Generated
        public LocationMessageBuilder sender(Sender sender) {
            this.sender = sender;
            return this;
        }

        @Generated
        public LocationMessage build() {
            return new LocationMessage(this.title, this.address, this.latitude, this.longitude, this.quickReply, this.sender);
        }

        @Generated
        public String toString() {
            return "LocationMessage.LocationMessageBuilder(title=" + this.title + ", address=" + this.address + ", latitude=" + this.latitude + ", longitude=" + this.longitude + ", quickReply=" + this.quickReply + ", sender=" + this.sender + ")";
        }
    }
}

