/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.model.event.beacon;

final class BeaconContentUtil {
    private static final char[] HEX_CODE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private BeaconContentUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static byte[] parseBytesOrNull(String deviceMessageAsHex) {
        if (deviceMessageAsHex == null) {
            return null;
        }
        int length = deviceMessageAsHex.length();
        int resultSize = length / 2;
        if (length % 2 != 0) {
            throw new IllegalArgumentException("hex string needs to be even-length: " + deviceMessageAsHex);
        }
        byte[] bytes = new byte[resultSize];
        for (int pos = 0; pos < resultSize; ++pos) {
            bytes[pos] = (byte)Integer.parseInt(deviceMessageAsHex.substring(pos * 2, pos * 2 + 2), 16);
        }
        return bytes;
    }

    static String printHexBinary(byte[] deviceMessage) {
        if (deviceMessage == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(deviceMessage.length * 2);
        for (byte byteValue : deviceMessage) {
            int intValue = Byte.toUnsignedInt(byteValue);
            sb.append(HEX_CODE[intValue >>> 4]);
            sb.append(HEX_CODE[intValue & 0xF]);
        }
        return sb.toString();
    }
}

