/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.server.rxjava3;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.server.annotation.DelegatingResponseConverterFunctionProvider;
import com.linecorp.armeria.server.annotation.ResponseConverterFunction;
import com.linecorp.armeria.server.rxjava3.ObservableResponseConverterFunction;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Single;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

@UnstableApi
public final class ObservableResponseConverterFunctionProvider
implements DelegatingResponseConverterFunctionProvider {
    @Nullable
    public ResponseConverterFunction createResponseConverterFunction(Type returnType, ResponseConverterFunction responseConverter) {
        Class<?> clazz = ObservableResponseConverterFunctionProvider.typeToClass(returnType);
        if (clazz != null && ObservableResponseConverterFunctionProvider.isSupportedClass(clazz)) {
            ObservableResponseConverterFunctionProvider.ensureNoMoreObservableSource(returnType, returnType);
            return new ObservableResponseConverterFunction(responseConverter);
        }
        return null;
    }

    private static void ensureNoMoreObservableSource(Type returnType, Type type) {
        if (type instanceof ParameterizedType) {
            Type[] args;
            for (Type arg : args = ((ParameterizedType)type).getActualTypeArguments()) {
                Class<?> clazz = ObservableResponseConverterFunctionProvider.typeToClass(arg);
                if (clazz != null && ObservableResponseConverterFunctionProvider.isSupportedClass(clazz)) {
                    throw new IllegalStateException("Disallowed type exists in the generic type arguments of the return type '" + returnType + "': " + clazz.getName());
                }
                ObservableResponseConverterFunctionProvider.ensureNoMoreObservableSource(returnType, arg);
            }
        }
    }

    private static boolean isSupportedClass(Class<?> clazz) {
        return Observable.class.isAssignableFrom(clazz) || Maybe.class.isAssignableFrom(clazz) || Single.class.isAssignableFrom(clazz) || Completable.class.isAssignableFrom(clazz);
    }

    @Nullable
    private static Class<?> typeToClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        return null;
    }

    public String toString() {
        return ObservableResponseConverterFunctionProvider.class.getSimpleName();
    }
}

