/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.rxjava3;

import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.SafeCloseable;
import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;

final class RequestContextMaybeObserver<T>
implements MaybeObserver<T>,
Disposable {
    private final MaybeObserver<T> actual;
    private final RequestContext assemblyContext;
    @Nullable
    private Disposable disposable;

    RequestContextMaybeObserver(MaybeObserver<T> actual, RequestContext assemblyContext) {
        this.actual = actual;
        this.assemblyContext = assemblyContext;
    }

    public void onSubscribe(Disposable d) {
        if (!DisposableHelper.validate((Disposable)this.disposable, (Disposable)d)) {
            return;
        }
        this.disposable = d;
        try (SafeCloseable ignored = this.assemblyContext.push();){
            this.actual.onSubscribe((Disposable)this);
        }
    }

    public void onError(Throwable t) {
        try (SafeCloseable ignored = this.assemblyContext.push();){
            this.actual.onError(t);
        }
    }

    public void onSuccess(T value) {
        try (SafeCloseable ignored = this.assemblyContext.push();){
            this.actual.onSuccess(value);
        }
    }

    public void onComplete() {
        try (SafeCloseable ignored = this.assemblyContext.push();){
            this.actual.onComplete();
        }
    }

    public boolean isDisposed() {
        assert (this.disposable != null);
        return this.disposable.isDisposed();
    }

    public void dispose() {
        assert (this.disposable != null);
        this.disposable.dispose();
    }
}

