/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.rxjava3;

import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.ExceptionHandlerFunction;
import com.linecorp.armeria.server.annotation.ResponseConverterFunction;
import io.reactivex.rxjava3.core.BackpressureStrategy;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Single;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;

public final class ObservableResponseConverterFunction
implements ResponseConverterFunction {
    private final ResponseConverterFunction responseConverter;
    @Nullable
    private final ExceptionHandlerFunction exceptionHandler;

    @Deprecated
    public ObservableResponseConverterFunction(ResponseConverterFunction responseConverter, ExceptionHandlerFunction exceptionHandler) {
        this.responseConverter = Objects.requireNonNull(responseConverter, "responseConverter");
        this.exceptionHandler = Objects.requireNonNull(exceptionHandler, "exceptionHandler");
    }

    public ObservableResponseConverterFunction(ResponseConverterFunction responseConverter) {
        this.responseConverter = Objects.requireNonNull(responseConverter, "responseConverter");
        this.exceptionHandler = null;
    }

    public HttpResponse convertResponse(ServiceRequestContext ctx, ResponseHeaders headers, @Nullable Object result, HttpHeaders trailers) throws Exception {
        if (result instanceof Observable) {
            return this.responseConverter.convertResponse(ctx, headers, (Object)((Observable)result).toFlowable(BackpressureStrategy.BUFFER), trailers);
        }
        if (result instanceof Maybe) {
            CompletionStage future = ((Maybe)result).toCompletionStage(null);
            return HttpResponse.from(future.handle(this.handleResult(ctx, headers, trailers)));
        }
        if (result instanceof Single) {
            CompletionStage future = ((Single)result).toCompletionStage();
            return HttpResponse.from(future.handle(this.handleResult(ctx, headers, trailers)));
        }
        if (result instanceof Completable) {
            CompletionStage future = ((Completable)result).toCompletionStage(null);
            return HttpResponse.from(future.handle(this.handleResult(ctx, headers, trailers)));
        }
        return (HttpResponse)ResponseConverterFunction.fallthrough();
    }

    private HttpResponse onSuccess(ServiceRequestContext ctx, ResponseHeaders headers, @Nullable Object result, HttpHeaders trailers) {
        try {
            return this.responseConverter.convertResponse(ctx, headers, result, trailers);
        }
        catch (Exception e) {
            return this.onError(ctx, e);
        }
    }

    private HttpResponse onError(ServiceRequestContext ctx, Throwable cause) {
        if (this.exceptionHandler == null) {
            return HttpResponse.ofFailure((Throwable)cause);
        }
        return this.exceptionHandler.handleException(ctx, ctx.request(), cause);
    }

    private BiFunction<Object, Throwable, HttpResponse> handleResult(ServiceRequestContext ctx, ResponseHeaders headers, HttpHeaders trailers) {
        return (result, cause) -> {
            if (cause != null) {
                return this.onError(ctx, (Throwable)cause);
            }
            return this.onSuccess(ctx, headers, result, trailers);
        };
    }
}

