/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.rxjava2;

import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.util.SafeCloseable;
import io.reactivex.CompletableObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;

final class RequestContextCompletableObserver
implements CompletableObserver,
Disposable {
    private final CompletableObserver actual;
    private final RequestContext assemblyContext;
    private Disposable disposable;

    RequestContextCompletableObserver(CompletableObserver actual, RequestContext assemblyContext) {
        this.actual = actual;
        this.assemblyContext = assemblyContext;
    }

    public void onSubscribe(Disposable d) {
        if (!DisposableHelper.validate((Disposable)this.disposable, (Disposable)d)) {
            return;
        }
        this.disposable = d;
        try (SafeCloseable ignored = this.assemblyContext.push();){
            this.actual.onSubscribe((Disposable)this);
        }
    }

    public void onError(Throwable t) {
        try (SafeCloseable ignored = this.assemblyContext.push();){
            this.actual.onError(t);
        }
    }

    public void onComplete() {
        try (SafeCloseable ignored = this.assemblyContext.push();){
            this.actual.onComplete();
        }
    }

    public boolean isDisposed() {
        return this.disposable.isDisposed();
    }

    public void dispose() {
        this.disposable.dispose();
    }
}

