/*
 * Decompiled with CFR 0.152.
 */
package com.ergy.fset;

import com.ergy.fset.AbstractFMap;
import com.ergy.fset.BinaryOp;
import com.ergy.fset.FMap;
import com.ergy.fset.FSet;
import com.ergy.fset.FTreeSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;

public class FTreeMap<Key, Val>
extends AbstractFMap<Key, Val>
implements Comparable<FTreeMap<Key, Val>>,
SortedMap<Key, Val>,
Serializable {
    private static BinaryOp second = new BinaryOp(){

        public Object apply(Object object, Object object2) {
            return object2;
        }
    };
    private static final FTreeMap EMPTY_INSTANCE = new FTreeMap();
    private final transient Object tree;
    private final Val dflt;
    private final Comparator<Key> comp;
    private transient int hash_code = Integer.MIN_VALUE;
    private static final int MAX_LEAF_ARRAY_LENGTH = 16;
    private static final int BALANCE_FACTOR = 4;
    static final Object NEGATIVE_INFINITY = FTreeSet.NEGATIVE_INFINITY;
    static final Object POSITIVE_INFINITY = FTreeSet.POSITIVE_INFINITY;
    private static final Object NO_ELEMENT = new Object();
    private static final int BIN_SEARCH_NOT_FOUND = 0;
    private static final int BIN_SEARCH_FOUND = 1;
    private static final int BIN_SEARCH_FOUND_MASK = 1;
    private static final int BIN_SEARCH_INDEX_SHIFT = 1;
    private static Field TreeField;

    public static <Key, Val> FTreeMap<Key, Val> emptyMap() {
        return EMPTY_INSTANCE;
    }

    public FTreeMap() {
        this.tree = null;
        this.comp = null;
        this.dflt = null;
    }

    public FTreeMap(Comparator<? super Key> comparator) {
        this.tree = null;
        this.comp = comparator;
        this.dflt = null;
    }

    public FTreeMap(Map<? extends Key, ? extends Val> map) {
        this.comp = null;
        this.tree = this.fromMap(map);
        this.dflt = null;
    }

    public FTreeMap(Map<? extends Key, ? extends Val> map, Comparator<? super Key> comparator) {
        this.comp = comparator;
        this.tree = this.fromMap(map);
        this.dflt = null;
    }

    public FTreeMap(SortedMap<Key, Val> sortedMap) {
        this.comp = sortedMap.comparator();
        this.tree = this.fromMap(sortedMap);
        this.dflt = null;
    }

    public FTreeMap(Key[] KeyArray, Val[] ValArray) {
        if (KeyArray.length != ValArray.length) {
            throw new IllegalArgumentException();
        }
        this.comp = null;
        this.tree = this.fromArrays(KeyArray, ValArray);
        this.dflt = null;
    }

    public FTreeMap(Key[] KeyArray, Val[] ValArray, Comparator<? super Key> comparator) {
        if (KeyArray.length != ValArray.length) {
            throw new IllegalArgumentException();
        }
        this.comp = comparator;
        this.tree = this.fromArrays(KeyArray, ValArray);
        this.dflt = null;
    }

    public static <Key, Val> FTreeMap<Key, Val> withDefault(Val Val) {
        return new FTreeMap<Key, Val>(null, Val, null);
    }

    public static <Key, Val> FTreeMap<Key, Val> withDefault(Val Val, Comparator<? super Key> comparator) {
        return new FTreeMap<Key, Val>(null, Val, comparator);
    }

    public static <Key, Val> FTreeMap<Key, Val> withDefault(FTreeMap<Key, Val> fTreeMap, Val Val) {
        return new FTreeMap<Key, Val>(fTreeMap.tree, Val, null);
    }

    public static <Key, Val> FTreeMap<Key, Val> withDefault(FTreeMap<Key, Val> fTreeMap, Val Val, Comparator<? super Key> comparator) {
        return new FTreeMap<Key, Val>(fTreeMap.tree, Val, comparator);
    }

    private Object fromMap(Map<Key, Val> map) {
        if (map instanceof FTreeMap && FTreeMap.eql(this.comp, ((FTreeMap)map).comp)) {
            return ((FTreeMap)map).tree;
        }
        Object object = null;
        for (Map.Entry<Key, Val> entry : map.entrySet()) {
            object = this.with(object, entry.getKey(), entry.getValue());
        }
        return object;
    }

    private Object fromArrays(Key[] KeyArray, Val[] ValArray) {
        Object object = null;
        if (KeyArray.length != ValArray.length) {
            throw new IllegalArgumentException("array lengths must be equal");
        }
        for (int i = 0; i < KeyArray.length; ++i) {
            object = this.with(object, KeyArray[i], ValArray[i]);
        }
        return object;
    }

    @Override
    public boolean isEmpty() {
        return this.tree == null;
    }

    @Override
    public int size() {
        return FTreeMap.treeSize(this.tree);
    }

    @Override
    public Map.Entry<Key, Val> arb() {
        if (this.tree == null) {
            throw new NoSuchElementException();
        }
        if (!(this.tree instanceof Node)) {
            Object[] objectArray = (Object[])this.tree;
            int n = objectArray.length;
            int n2 = n >> 1;
            int n3 = n2 >> 1;
            return new Entry(objectArray[n3], objectArray[n3 + n2]);
        }
        Node node = (Node)this.tree;
        if (node.key instanceof EquivalentMap) {
            return ((EquivalentMap)node.key).contents.get(0);
        }
        return node;
    }

    @Override
    public boolean contains(Map.Entry<Key, Val> entry) {
        Object object = this.get(this.tree, entry.getKey());
        return object != NO_ELEMENT && FTreeMap.eql(object, entry.getValue());
    }

    @Override
    public boolean containsKey(Object object) {
        return this.get(this.tree, object) != NO_ELEMENT;
    }

    @Override
    public Val get(Object object) {
        Object object2 = this.get(this.tree, object);
        if (object2 == NO_ELEMENT) {
            return this.dflt;
        }
        return (Val)object2;
    }

    @Override
    public FTreeMap<Key, Val> with(Key Key, Val Val) {
        Object object = this.with(this.tree, Key, Val);
        if (object == this.tree) {
            return this;
        }
        return new FTreeMap<Key, Val>(object, this.dflt, this.comp);
    }

    @Override
    public FTreeMap<Key, Val> less(Key Key) {
        Object object = this.less(this.tree, Key);
        if (object == this.tree) {
            return this;
        }
        if (object == null && this.dflt == null && this.comp == null) {
            return FTreeMap.emptyMap();
        }
        return new FTreeMap<Key, Val>(object, this.dflt, this.comp);
    }

    @Override
    public Set<Key> keySet() {
        return new AbstractSet<Key>(){

            @Override
            public Iterator<Key> iterator() {
                return new FTMKeyIterator(FTreeMap.this.tree);
            }

            @Override
            public int size() {
                return FTreeMap.this.size();
            }

            @Override
            public boolean contains(Object object) {
                return FTreeMap.this.containsKey(object);
            }
        };
    }

    @Override
    public Collection<Val> values() {
        return new AbstractCollection<Val>(){

            @Override
            public Iterator<Val> iterator() {
                return new FTMValueIterator(FTreeMap.this.tree);
            }

            @Override
            public int size() {
                return FTreeMap.this.size();
            }
        };
    }

    @Override
    public Set<Map.Entry<Key, Val>> entrySet() {
        return new AbstractSet<Map.Entry<Key, Val>>(){

            @Override
            public Iterator iterator() {
                return FTreeMap.this.iterator();
            }

            @Override
            public int size() {
                return FTreeMap.this.size();
            }

            @Override
            public boolean contains(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                Object k = entry.getKey();
                Object v = entry.getValue();
                if (FTreeMap.this.containsKey(k)) {
                    return FTreeMap.eql(v, FTreeMap.this.get(k));
                }
                return false;
            }

            @Override
            public boolean remove(Object object) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public FTreeSet<Key> domain() {
        Object object = this.domain(this.tree);
        return FTreeSet.make(object, this.comp);
    }

    @Override
    public FTreeSet<Val> range() {
        return (FTreeSet)this.range(this.tree, new FTreeSet());
    }

    @Override
    public FSet<Val> range(FSet<Val> fSet) {
        fSet = fSet.difference(fSet);
        return this.range(this.tree, fSet);
    }

    @Override
    public FTreeSet<Map.Entry<Key, Val>> toSet() {
        return (FTreeSet)this.toSet(new FTreeSet<Map.Entry<Key, Val>>(this.comp == null ? null : new EntryComparator<Key>(this.comp)));
    }

    @Override
    public FSet<Map.Entry<Key, Val>> toSet(FSet<Map.Entry<Key, Val>> fSet) {
        FSet<Map.Entry<Key, Val>> fSet2 = fSet.difference(fSet);
        Iterator<Map.Entry<Key, Val>> iterator = this.iterator();
        while (iterator.hasNext()) {
            fSet2 = fSet2.with(iterator.next());
        }
        return fSet2;
    }

    @Override
    public FTreeMap<Key, Val> union(FMap<? extends Key, ? extends Val> fMap) {
        return this.union((FMap)fMap, second);
    }

    @Override
    public FTreeMap<Key, Val> union(FMap<? extends Key, ? extends Val> fMap, BinaryOp<Val> binaryOp) {
        FTreeMap<? extends Key, ? extends Val> fTreeMap = new FTreeMap<Key, Val>(fMap, this.comp);
        Object object = this.union(this.tree, fTreeMap.tree, binaryOp);
        return new FTreeMap<Key, Val>(object, this.dflt, this.comp);
    }

    @Override
    public FTreeMap<Key, Val> restrictedTo(FSet<Key> fSet) {
        FTreeSet<Key> fTreeSet = new FTreeSet<Key>(fSet, this.comp);
        Object object = this.restrictedTo(this.tree, fTreeSet.tree, fTreeSet);
        return new FTreeMap<Key, Val>(object, this.dflt, this.comp);
    }

    @Override
    public FTreeMap<Key, Val> restrictedFrom(FSet<Key> fSet) {
        FTreeSet<Key> fTreeSet = new FTreeSet<Key>(fSet, this.comp);
        Object object = this.restrictedFrom(this.tree, fTreeSet.tree, fTreeSet);
        return new FTreeMap<Key, Val>(object, this.dflt, this.comp);
    }

    @Override
    public Val getDefault() {
        return this.dflt;
    }

    @Override
    public Iterator<Map.Entry<Key, Val>> iterator() {
        return new FTMIterator(this.tree);
    }

    @Override
    public int compareTo(FTreeMap<Key, Val> fTreeMap) {
        return this.compareTo(this.tree, fTreeMap.tree);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof FTreeMap && FTreeMap.eql(this.comp, ((FTreeMap)object).comp)) {
            FTreeMap fTreeMap = (FTreeMap)object;
            return this.equals(this.tree, fTreeMap.tree);
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (this.size() != map.size()) {
            return false;
        }
        for (Map.Entry entry : map.entrySet()) {
            if (this.contains(entry)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this.hash_code == Integer.MIN_VALUE) {
            this.hash_code = this.hashCode(this.tree);
        }
        return this.hash_code;
    }

    String dump() {
        return FTreeMap.dump(this.tree);
    }

    boolean verify() {
        return this.verify(this.tree, NEGATIVE_INFINITY, POSITIVE_INFINITY);
    }

    @Override
    public Comparator<Key> comparator() {
        return this.comp;
    }

    @Override
    public Key firstKey() {
        if (this.tree == null) {
            throw new NoSuchElementException();
        }
        return (Key)this.firstKey(this.tree);
    }

    @Override
    public Key lastKey() {
        if (this.tree == null) {
            throw new NoSuchElementException();
        }
        return (Key)this.lastKey(this.tree);
    }

    @Override
    public SortedMap<Key, Val> subMap(Key Key, Key Key2) {
        if (this.tree == null) {
            return this;
        }
        Key Key3 = this.firstKey();
        Key Key4 = this.lastKey();
        if (this.compare(Key, Key2) >= 0 || this.compare(Key3, Key2) >= 0 || this.compare(Key4, Key) < 0) {
            return new FTreeMap<Key, Val>(null, this.dflt, this.comp);
        }
        if (this.compare(Key3, Key) >= 0 && this.compare(Key4, Key2) < 0) {
            return this;
        }
        Object object = this.split(this.tree, Key, Key2);
        Entry entry = this.findEquiv(this.tree, Key);
        if (entry != null) {
            object = this.with(object, entry.key, entry.value);
        }
        return new FTreeMap<Key, Val>(object, this.dflt, this.comp);
    }

    @Override
    public SortedMap<Key, Val> headMap(Key Key) {
        if (this.tree == null || this.compare(this.lastKey(), Key) < 0) {
            return this;
        }
        if (this.compare(this.firstKey(), Key) >= 0) {
            return new FTreeMap<Key, Val>(null, this.dflt, this.comp);
        }
        return new FTreeMap<Key, Val>(this.split(this.tree, NEGATIVE_INFINITY, Key), this.dflt, this.comp);
    }

    @Override
    public SortedMap<Key, Val> tailMap(Key Key) {
        if (this.tree == null || this.compare(this.firstKey(), Key) >= 0) {
            return this;
        }
        if (this.compare(this.lastKey(), Key) < 0) {
            return new FTreeMap<Key, Val>(null, this.dflt, this.comp);
        }
        Object object = this.split(this.tree, Key, POSITIVE_INFINITY);
        Entry entry = this.findEquiv(this.tree, Key);
        if (entry != null) {
            object = this.with(object, entry.key, entry.value);
        }
        return new FTreeMap<Key, Val>(object, this.dflt, this.comp);
    }

    private static Node makeNode(Object object, Object object2, Object object3, Object object4) {
        if (object instanceof Entry) {
            Entry entry = (Entry)object;
            object2 = entry.value;
            object = entry.key;
        }
        return new Node(FTreeMap.treeSize(object3) + FTreeMap.treeSize(object4) + FTreeMap.keySize(object), object, object2, object3, object4);
    }

    private static int treeSize(Object object) {
        if (object == null) {
            return 0;
        }
        if (!(object instanceof Node)) {
            return ((Object[])object).length >> 1;
        }
        return ((Node)object).size;
    }

    private static int keySize(Object object) {
        if (object instanceof EquivalentMap) {
            return ((EquivalentMap)object).contents.size();
        }
        return 1;
    }

    private FTreeMap(Object object, Val Val, Comparator<Key> comparator) {
        this.tree = object;
        this.dflt = Val;
        this.comp = comparator;
    }

    private Object firstKey(Object object) {
        if (!(object instanceof Node)) {
            Object[] objectArray = (Object[])object;
            return objectArray[0];
        }
        Node node = (Node)object;
        if (node.left == null) {
            if (node.key instanceof EquivalentMap) {
                return ((EquivalentMap)node.key).contents.get((int)0).key;
            }
            return node.key;
        }
        return this.firstKey(node.left);
    }

    private Object lastKey(Object object) {
        if (!(object instanceof Node)) {
            Object[] objectArray = (Object[])object;
            return objectArray[(objectArray.length >> 1) - 1];
        }
        Node node = (Node)object;
        if (node.right == null) {
            if (node.key instanceof EquivalentMap) {
                ArrayList<Entry> arrayList = ((EquivalentMap)node.key).contents;
                return arrayList.get((int)(arrayList.size() - 1)).key;
            }
            return node.key;
        }
        return this.lastKey(node.right);
    }

    private Object get(Object object, Object object2) {
        if (object == null) {
            return NO_ELEMENT;
        }
        if (!(object instanceof Node)) {
            Object[] objectArray = (Object[])object;
            int n = this.binarySearch(objectArray, object2);
            int n2 = n >> 1;
            if ((n & 1) == 1 && FTreeMap.eql(object2, objectArray[n2])) {
                return objectArray[n2 + (objectArray.length >> 1)];
            }
            return NO_ELEMENT;
        }
        Node node = (Node)object;
        Object object3 = node.key;
        int n = this.compare(object2, object3);
        if (n == 0) {
            if (object3 instanceof EquivalentMap) {
                ArrayList<Entry> arrayList = ((EquivalentMap)object3).contents;
                int n3 = arrayList.size();
                for (int i = 0; i < n3; ++i) {
                    Entry entry = arrayList.get(i);
                    if (!FTreeMap.eql(object2, entry.key)) continue;
                    return entry.value;
                }
                return NO_ELEMENT;
            }
            if (FTreeMap.eql(object2, object3)) {
                return node.value;
            }
            return NO_ELEMENT;
        }
        if (n < 0) {
            return this.get(node.left, object2);
        }
        return this.get(node.right, object2);
    }

    private Object with(Object object, Object object2, Object object3) {
        if (object == null) {
            if (!(object2 instanceof EquivalentMap)) {
                Object[] objectArray = new Object[]{object2, object3};
                return objectArray;
            }
            return FTreeMap.makeNode(object2, object3, null, null);
        }
        if (!(object instanceof Node)) {
            Object[] objectArray = (Object[])object;
            int n = objectArray.length;
            int n2 = n >> 1;
            int n3 = this.binarySearch(objectArray, object2);
            int n4 = n3 & 1;
            int n5 = n3 >> 1;
            if (n4 == 1 && !(object2 instanceof EquivalentMap) && FTreeMap.eql(object2, objectArray[n5])) {
                if (FTreeMap.eql(object3, objectArray[n5 + n2])) {
                    return object;
                }
                return FTreeMap.update2(objectArray, n5, object3);
            }
            if (n4 == 0 && n + 1 < 16 && !(object2 instanceof EquivalentMap)) {
                return FTreeMap.insert2(objectArray, n5, object2, object3);
            }
            return FTreeMap.makeNode(n4 == 1 ? FTreeMap.equivUnion(objectArray[n5], objectArray[n5 + n2], object2, object3, second) : object2, object3, FTreeMap.subseq2(objectArray, 0, n5), FTreeMap.subseq2(objectArray, n4 == 1 ? n5 + 1 : n5, n2));
        }
        Node node = (Node)object;
        Object object4 = node.key;
        int n = this.compare(object2, object4);
        if (n == 0) {
            if (!(object2 instanceof EquivalentMap) && !(object4 instanceof EquivalentMap) && FTreeMap.eql(object2, object4) && FTreeMap.eql(object3, node.value)) {
                return object;
            }
            return FTreeMap.makeNode(FTreeMap.equivUnion(object4, node.value, object2, object3, second), object3, node.left, node.right);
        }
        if (n < 0) {
            Object object5 = this.with(node.left, object2, object3);
            if (object5 == node.left) {
                return object;
            }
            return this.buildNode(object4, node.value, object5, node.right);
        }
        Object object6 = this.with(node.right, object2, object3);
        if (object6 == node.right) {
            return object;
        }
        return this.buildNode(object4, node.value, node.left, object6);
    }

    private Object less(Object object, Object object2) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof Node)) {
            Object[] objectArray = (Object[])object;
            int n = this.binarySearch(objectArray, object2);
            int n2 = n & 1;
            int n3 = n >> 1;
            if (n2 == 1) {
                Object object3 = objectArray[n3];
                if (FTreeMap.eql(object2, object3)) {
                    return FTreeMap.remove2(objectArray, n3);
                }
                return object;
            }
            return object;
        }
        Node node = (Node)object;
        Object object4 = node.key;
        int n = this.compare(object2, object4);
        if (n == 0) {
            if (!(object4 instanceof EquivalentMap)) {
                if (object2 != null && !object2.equals(object4)) {
                    return object;
                }
                return this.join(node.left, node.right);
            }
            return this.buildNode(FTreeMap.equivLess(object4, object2), null, node.left, node.right);
        }
        if (n < 0) {
            Object object5 = this.less(node.left, object2);
            if (object5 == node.left) {
                return object;
            }
            return this.buildNode(object4, node.value, object5, node.right);
        }
        Object object6 = this.less(node.right, object2);
        if (object6 == node.right) {
            return object;
        }
        return this.buildNode(object4, node.value, node.left, object6);
    }

    private Object domain(Object object) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof Node)) {
            Object[] objectArray = (Object[])object;
            int n = objectArray.length >> 1;
            Object[] objectArray2 = new Object[n];
            for (int i = 0; i < n; ++i) {
                objectArray2[i] = objectArray[i];
            }
            return objectArray2;
        }
        Node node = (Node)object;
        Object object2 = this.domain(node.left);
        Object object3 = this.domain(node.right);
        if (node.key instanceof EquivalentMap) {
            ArrayList<Entry> arrayList = ((EquivalentMap)node.key).contents;
            ArrayList<Object> arrayList2 = new ArrayList<Object>(arrayList.size());
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList2.add(arrayList.get((int)i).key);
            }
            return FTreeSet.makeNode(new FTreeSet.EquivalentSet(arrayList2), object2, object3);
        }
        return FTreeSet.makeNode(node.key, object2, object3);
    }

    private FSet range(Object object, FSet fSet) {
        if (object == null) {
            return fSet;
        }
        if (!(object instanceof Node)) {
            Object[] objectArray = (Object[])object;
            int n = objectArray.length >> 1;
            for (int i = 0; i < n; ++i) {
                fSet = fSet.with(objectArray[n + i]);
            }
            return fSet;
        }
        Node node = (Node)object;
        if (node.key instanceof EquivalentMap) {
            ArrayList<Entry> arrayList = ((EquivalentMap)node.key).contents;
            for (int i = 0; i < arrayList.size(); ++i) {
                fSet = fSet.with(arrayList.get((int)i).value);
            }
            return fSet;
        }
        return this.range(node.left, fSet).with(node.value).union(this.range(node.right, fSet));
    }

    private Object union(Object object, Object object2, BinaryOp binaryOp) {
        return this.union(object, object2, binaryOp, NEGATIVE_INFINITY, POSITIVE_INFINITY);
    }

    private Object union(Object object, Object object2, BinaryOp binaryOp, Object object3, Object object4) {
        if (object == object2) {
            return object;
        }
        if (object == null) {
            return this.split(object2, object3, object4);
        }
        if (object2 == null) {
            return this.split(object, object3, object4);
        }
        if (!(object instanceof Node)) {
            Object[] objectArray = (Object[])object;
            if (!(object2 instanceof Node)) {
                return this.union2(objectArray, (Object[])object2, binaryOp, object3, object4);
            }
            Node node = (Node)object2;
            Object object5 = node.key;
            Object object6 = this.union(this.trim(object, object3, object5), this.trim(node.left, object3, object5), binaryOp, object3, object5);
            Object object7 = this.union(this.trim(object, object5, object4), this.trim(node.right, object5, object4), binaryOp, object5, object4);
            Entry entry = this.findEquiv(object, object5);
            if (entry == null) {
                return this.concat(object5, node.value, object6, object7);
            }
            Object object8 = FTreeMap.equivUnion(entry.key, entry.value, object5, node.value, binaryOp);
            if (object8 instanceof EquivalentMap) {
                return this.concat(object8, null, object6, object7);
            }
            Entry entry2 = (Entry)object8;
            return this.concat(entry2.key, entry2.value, object6, object7);
        }
        Node node = (Node)object;
        Object object9 = node.key;
        Object object10 = this.union(this.trim(node.left, object3, object9), this.trim(object2, object3, object9), binaryOp, object3, object9);
        Object object11 = this.union(this.trim(node.right, object9, object4), this.trim(object2, object9, object4), binaryOp, object9, object4);
        Entry entry = this.findEquiv(object2, object9);
        if (entry == null) {
            return this.concat(object9, node.value, object10, object11);
        }
        Object object12 = FTreeMap.equivUnion(object9, node.value, entry.key, entry.value, binaryOp);
        if (object12 instanceof EquivalentMap) {
            return this.concat(object12, null, object10, object11);
        }
        Entry entry3 = (Entry)object12;
        return this.concat(entry3.key, entry3.value, object10, object11);
    }

    private Object restrictedTo(Object object, Object object2, FTreeSet fTreeSet) {
        return this.restrictedTo(object, object2, fTreeSet, NEGATIVE_INFINITY, POSITIVE_INFINITY);
    }

    private Object restrictedTo(Object object, Object object2, FTreeSet fTreeSet, Object object3, Object object4) {
        if (object == null) {
            return null;
        }
        if (object2 == null) {
            return null;
        }
        if (!(object instanceof Node)) {
            Object[] objectArray = (Object[])object;
            if (!(object2 instanceof FTreeSet.Node)) {
                return this.restrictedTo2(objectArray, (Object[])object2, object3, object4);
            }
            FTreeSet.Node node = (FTreeSet.Node)object2;
            Object object5 = node.element;
            Object object6 = object5 instanceof FTreeSet.EquivalentSet ? ((FTreeSet.EquivalentSet)object5).contents.get(0) : object5;
            Object object7 = this.restrictedTo(this.trim(object, object3, object6), fTreeSet.trim(node.left, object3, object6), fTreeSet, object3, object6);
            Object object8 = this.restrictedTo(this.trim(object, object6, object4), fTreeSet.trim(node.right, object6, object4), fTreeSet, object6, object4);
            Entry entry = this.findEquiv(object, object6);
            if (entry == null) {
                return this.join(object7, object8);
            }
            Object object9 = FTreeMap.equivRestrictedTo(entry.key, entry.value, object5);
            if (object9 == null) {
                return this.join(object7, object8);
            }
            Entry entry2 = (Entry)object9;
            return this.concat(entry2.key, entry2.value, object7, object8);
        }
        Node node = (Node)object;
        Object object10 = node.key;
        Object object11 = object10 instanceof EquivalentMap ? ((EquivalentMap)object10).contents.get((int)0).key : object10;
        Object object12 = this.restrictedTo(node.left, fTreeSet.trim(object2, object3, object11), fTreeSet, object3, object11);
        Object object13 = this.restrictedTo(node.right, fTreeSet.trim(object2, object11, object4), fTreeSet, object11, object4);
        Object object14 = fTreeSet.findEquiv(object2, object11);
        if (object14 == FTreeSet.NO_ELEMENT) {
            return this.join(object12, object13);
        }
        Object object15 = FTreeMap.equivRestrictedTo(object10, node.value, object14);
        if (object15 == null) {
            return this.join(object12, object13);
        }
        if (object15 instanceof EquivalentMap) {
            return this.concat(object15, null, object12, object13);
        }
        Entry entry = (Entry)object15;
        return this.concat(entry.key, entry.value, object12, object13);
    }

    private Object restrictedFrom(Object object, Object object2, FTreeSet fTreeSet) {
        return this.restrictedFrom(object, object2, fTreeSet, NEGATIVE_INFINITY, POSITIVE_INFINITY);
    }

    private Object restrictedFrom(Object object, Object object2, FTreeSet fTreeSet, Object object3, Object object4) {
        if (object == null) {
            return null;
        }
        if (object2 == null) {
            return this.split(object, object3, object4);
        }
        if (!(object instanceof Node)) {
            Object[] objectArray = (Object[])object;
            if (!(object2 instanceof FTreeSet.Node)) {
                return this.restrictedFrom2(objectArray, (Object[])object2, object3, object4);
            }
            FTreeSet.Node node = (FTreeSet.Node)object2;
            Object object5 = node.element;
            Object object6 = object5 instanceof FTreeSet.EquivalentSet ? ((FTreeSet.EquivalentSet)object5).contents.get(0) : object5;
            Object object7 = this.restrictedFrom(this.trim(object, object3, object6), fTreeSet.trim(node.left, object3, object6), fTreeSet, object3, object6);
            Object object8 = this.restrictedFrom(this.trim(object, object6, object4), fTreeSet.trim(node.right, object6, object4), fTreeSet, object6, object4);
            Entry entry = this.findEquiv(object, object6);
            if (entry == null) {
                return this.join(object7, object8);
            }
            Object object9 = FTreeMap.equivRestrictedFrom(entry.key, entry.value, object5);
            if (object9 == null) {
                return this.join(object7, object8);
            }
            Entry entry2 = (Entry)object9;
            return this.concat(entry2.key, entry2.value, object7, object8);
        }
        Node node = (Node)object;
        Object object10 = node.key;
        Object object11 = object10 instanceof EquivalentMap ? ((EquivalentMap)object10).contents.get((int)0).key : object10;
        Object object12 = this.restrictedFrom(node.left, fTreeSet.trim(object2, object3, object11), fTreeSet, object3, object11);
        Object object13 = this.restrictedFrom(node.right, fTreeSet.trim(object2, object11, object4), fTreeSet, object11, object4);
        Object object14 = fTreeSet.findEquiv(object2, object11);
        if (object14 == FTreeSet.NO_ELEMENT) {
            return this.concat(object10, node.value, object12, object13);
        }
        Object object15 = FTreeMap.equivRestrictedFrom(object10, node.value, object14);
        if (object15 == null) {
            return this.join(object12, object13);
        }
        if (object15 instanceof EquivalentMap) {
            return this.concat(object15, null, object12, object13);
        }
        Entry entry = (Entry)object15;
        return this.concat(entry.key, entry.value, object12, object13);
    }

    private int compareTo(Object object, Object object2) {
        int n;
        if (object == object2) {
            return 0;
        }
        int n2 = FTreeMap.treeSize(object);
        if (n2 < (n = FTreeMap.treeSize(object2))) {
            return -1;
        }
        if (n2 > n) {
            return 1;
        }
        return this.compareTo(object, 0, object2, 0, 0, n2);
    }

    private int compareTo(Object object, int n, Object object2, int n2, int n3, int n4) {
        if (object == object2 && n == n2 || n3 == n4) {
            return 0;
        }
        if (!(object instanceof Node)) {
            if (!(object2 instanceof Node)) {
                Object[] objectArray = (Object[])object;
                Object[] objectArray2 = (Object[])object2;
                int n5 = objectArray.length >> 1;
                int n6 = objectArray2.length >> 1;
                for (int i = n3; i < n4; ++i) {
                    Object object3 = objectArray[i - n];
                    Object object4 = objectArray2[i - n2];
                    int n7 = this.compare(object3, object4);
                    if (n7 != 0) {
                        return n7;
                    }
                    Object object5 = objectArray[i - n + n5];
                    Object object6 = objectArray2[i - n2 + n6];
                    n7 = ((Comparable)object5).compareTo((Comparable)object6);
                    if (n7 == 0) continue;
                    return n7;
                }
                return 0;
            }
            return -this.compareTo(object2, n2, object, n, n3, n4);
        }
        Node node = (Node)object;
        Object object7 = node.left;
        int n8 = FTreeMap.treeSize(object7);
        int n9 = n + n8;
        RankTrimResult rankTrimResult = this.rankTrim(object7, n, n3, n9);
        RankTrimResult rankTrimResult2 = this.rankTrim(object2, n2, n3, n9);
        int n10 = this.compareTo(rankTrimResult.subtree, rankTrimResult.base, rankTrimResult2.subtree, rankTrimResult2.base, n3, n9);
        if (n10 != 0) {
            return n10;
        }
        Object object8 = node.key;
        Entry entry = this.rankEntry(object2, n9 - n2);
        int n11 = this.compare(object8, entry.key);
        if (n11 != 0) {
            return n11;
        }
        n11 = FTreeMap.equivCompare(object8, node.value, entry.key, entry.value);
        if (n11 != 0) {
            return n11;
        }
        int n12 = n + n8 + FTreeMap.keySize(object8);
        RankTrimResult rankTrimResult3 = this.rankTrim(node.right, n12, n12, n4);
        RankTrimResult rankTrimResult4 = this.rankTrim(object2, n2, n12, n4);
        return this.compareTo(rankTrimResult3.subtree, rankTrimResult3.base, rankTrimResult4.subtree, rankTrimResult4.base, n12, n4);
    }

    private boolean equals(Object object, Object object2) {
        int n;
        if (object == object2) {
            return true;
        }
        int n2 = FTreeMap.treeSize(object);
        if (n2 != (n = FTreeMap.treeSize(object2))) {
            return false;
        }
        return this.equals(object, 0, object2, 0, 0, n2);
    }

    private boolean equals(Object object, int n, Object object2, int n2, int n3, int n4) {
        if (object == object2 && n == n2 || n3 == n4) {
            return true;
        }
        if (!(object instanceof Node)) {
            if (!(object2 instanceof Node)) {
                Object[] objectArray = (Object[])object;
                Object[] objectArray2 = (Object[])object2;
                for (int i = n3; i < n4; ++i) {
                    Object object3 = objectArray[i - n];
                    Object object4 = objectArray2[i - n2];
                    if (!FTreeMap.eql(object3, object4)) {
                        return false;
                    }
                    int n5 = objectArray.length >> 1;
                    Object object5 = objectArray[i - n + n5];
                    int n6 = objectArray2.length >> 1;
                    Object object6 = objectArray2[i - n2 + n6];
                    if (FTreeMap.eql(object5, object6)) continue;
                    return false;
                }
                return true;
            }
            return this.equals(object2, n2, object, n, n3, n4);
        }
        Node node = (Node)object;
        Object object7 = node.left;
        int n7 = FTreeMap.treeSize(object7);
        int n8 = n + n7;
        RankTrimResult rankTrimResult = this.rankTrim(object7, n, n3, n8);
        RankTrimResult rankTrimResult2 = this.rankTrim(object2, n2, n3, n8);
        if (!this.equals(rankTrimResult.subtree, rankTrimResult.base, rankTrimResult2.subtree, rankTrimResult2.base, n3, n8)) {
            return false;
        }
        Object object8 = node.key;
        Object object9 = node.value;
        Entry entry = this.rankEntry(object2, n8 - n2);
        if (!FTreeMap.equivEquals(object8, entry.key)) {
            return false;
        }
        if (!(object8 instanceof EquivalentMap) && !FTreeMap.eql(object9, entry.value)) {
            return false;
        }
        int n9 = FTreeMap.keySize(object8);
        int n10 = n + n7 + n9;
        RankTrimResult rankTrimResult3 = this.rankTrim(node.right, n10, n10, n4);
        RankTrimResult rankTrimResult4 = this.rankTrim(object2, n2, n10, n4);
        return this.equals(rankTrimResult3.subtree, rankTrimResult3.base, rankTrimResult4.subtree, rankTrimResult4.base, n10, n4);
    }

    private RankTrimResult rankTrim(Object object, int n, int n2, int n3) {
        while (object != null && object instanceof Node) {
            Node node = (Node)object;
            int n4 = n + FTreeMap.treeSize(node.left);
            if (n4 >= n2) {
                if (n4 < n3) break;
                object = node.left;
                continue;
            }
            int n5 = n4 + FTreeMap.keySize(node.key);
            if (n5 > n2) break;
            object = node.right;
            n = n5;
        }
        return new RankTrimResult(object, n);
    }

    private Entry rankEntry(Object object, int n) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (!(object instanceof Node)) {
            Object[] objectArray = (Object[])object;
            return new Entry(objectArray[n], objectArray[n + (objectArray.length >> 1)]);
        }
        Node node = (Node)object;
        int n2 = FTreeMap.treeSize(node.left);
        if (n < n2) {
            return this.rankEntry(node.left, n);
        }
        Object object2 = node.key;
        int n3 = FTreeMap.keySize(object2);
        if (n < n2 + n3) {
            return node;
        }
        return this.rankEntry(node.right, n - (n2 + n3));
    }

    private Entry findEquiv(Object object, Object object2) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof Node)) {
            Object[] objectArray = (Object[])object;
            int n = this.binarySearch(objectArray, object2);
            int n2 = n & 1;
            int n3 = n >> 1;
            if (n2 == 1) {
                return new Entry(objectArray[n3], objectArray[n3 + (objectArray.length >> 1)]);
            }
            return null;
        }
        Node node = (Node)object;
        Object object3 = node.key;
        int n = this.compare(object2, object3);
        if (n == 0) {
            return node;
        }
        if (n < 0) {
            return this.findEquiv(node.left, object2);
        }
        return this.findEquiv(node.right, object2);
    }

    private int compare(Object object, Object object2) {
        if (object == null) {
            return object2 == null ? 0 : -1;
        }
        if (object2 == null) {
            return 1;
        }
        if (object instanceof EquivalentMap) {
            object = ((EquivalentMap)object).contents.get((int)0).key;
        }
        if (object2 instanceof EquivalentMap) {
            object2 = ((EquivalentMap)object2).contents.get((int)0).key;
        }
        if (this.comp != null) {
            return this.comp.compare(object, object2);
        }
        return ((Comparable)object).compareTo((Comparable)object2);
    }

    private Object split(Object object, Object object2, Object object3) {
        int n;
        int n2;
        if (object == null) {
            return null;
        }
        if (object2 == NEGATIVE_INFINITY && object3 == POSITIVE_INFINITY) {
            return object;
        }
        if (!(object instanceof Node)) {
            int n3;
            Object[] objectArray = (Object[])object;
            int n4 = objectArray.length >> 1;
            int n5 = object2 == NEGATIVE_INFINITY ? 0 : this.binarySearchLo(objectArray, object2);
            int n6 = n3 = object3 == POSITIVE_INFINITY ? n4 : this.binarySearchHi(objectArray, object3);
            if (n5 >= n3) {
                return null;
            }
            if (n5 == 0 && n3 == n4) {
                return object;
            }
            return FTreeMap.subseq2(objectArray, n5, n3);
        }
        Node node = (Node)object;
        if (object2 != NEGATIVE_INFINITY && (n2 = this.compare(node.key, object2)) <= 0) {
            if (object3 == POSITIVE_INFINITY && n2 == 0) {
                return node.right;
            }
            return this.split(node.right, object2, object3);
        }
        if (object3 != POSITIVE_INFINITY && (n = this.compare(node.key, object3)) >= 0) {
            if (object2 == NEGATIVE_INFINITY && n == 0) {
                return node.left;
            }
            return this.split(node.left, object2, object3);
        }
        Object object4 = this.split(node.left, object2, POSITIVE_INFINITY);
        Object object5 = this.split(node.right, NEGATIVE_INFINITY, object3);
        if (object4 == node.left && object5 == node.right) {
            return object;
        }
        return this.concat(node.key, node.value, object4, object5);
    }

    private Object trim(Object object, Object object2, Object object3) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof Node)) {
            Object[] objectArray = (Object[])object;
            int n = objectArray.length >> 1;
            if (object2 != NEGATIVE_INFINITY && this.compare(objectArray[n - 1], object2) <= 0 || object3 != POSITIVE_INFINITY && this.compare(objectArray[0], object3) >= 0) {
                return null;
            }
            return object;
        }
        Node node = (Node)object;
        if (object2 == NEGATIVE_INFINITY || this.compare(node.key, object2) > 0) {
            if (object3 == POSITIVE_INFINITY || this.compare(node.key, object3) < 0) {
                return object;
            }
            return this.trim(node.left, object2, object3);
        }
        return this.trim(node.right, object2, object3);
    }

    private Object concat(Object object, Object object2, Object object3, Object object4) {
        if (object3 == null) {
            return this.with(object4, object, object2);
        }
        if (object4 == null) {
            return this.with(object3, object, object2);
        }
        int n = FTreeMap.treeSize(object3);
        int n2 = FTreeMap.treeSize(object4);
        if (object3 instanceof Node && n > n2 * 4) {
            Node node = (Node)object3;
            return this.buildNode(node.key, node.value, node.left, this.concat(object, object2, node.right, object4));
        }
        if (object4 instanceof Node && n2 > n * 4) {
            Node node = (Node)object4;
            return this.buildNode(node.key, node.value, this.concat(object, object2, object3, node.left), node.right);
        }
        return this.buildNode(object, object2, object3, object4);
    }

    private Object buildNode(Object object, Object object2, Object object3, Object object4) {
        if (object instanceof Entry) {
            Entry entry = (Entry)object;
            object2 = entry.value;
            object = entry.key;
        }
        if (!(object3 != null && object3 instanceof Node || object4 != null && object4 instanceof Node)) {
            if (!(object instanceof EquivalentMap) && (object3 == null ? 0 : ((Object[])object3).length) + 1 + (object4 == null ? 0 : ((Object[])object4).length) < 16) {
                return FTreeMap.makeArray2(object, object2, (Object[])object3, (Object[])object4);
            }
            return FTreeMap.makeNode(object, object2, object3, object4);
        }
        int n = FTreeMap.treeSize(object3);
        int n2 = FTreeMap.treeSize(object4);
        if (object4 instanceof Node && n2 > n * 4) {
            Node node = (Node)object4;
            Object object5 = node.left;
            Object object6 = node.right;
            if (!(object5 instanceof Node) || FTreeMap.treeSize(object5) <= FTreeMap.treeSize(object6)) {
                return FTreeMap.makeNode(node.key, node.value, this.buildNode(object, object2, object3, object5), object6);
            }
            Node node2 = (Node)object5;
            return FTreeMap.makeNode(node2.key, node2.value, this.buildNode(object, object2, object3, node2.left), this.buildNode(node.key, node.value, node2.right, object6));
        }
        if (object3 instanceof Node && n > n2 * 4) {
            Node node = (Node)object3;
            Object object7 = node.left;
            Object object8 = node.right;
            if (!(object8 instanceof Node) || FTreeMap.treeSize(object8) <= FTreeMap.treeSize(object7)) {
                return FTreeMap.makeNode(node.key, node.value, object7, this.buildNode(object, object2, object8, object4));
            }
            Node node3 = (Node)object8;
            return FTreeMap.makeNode(node3.key, node3.value, this.buildNode(node.key, node.value, object7, node3.left), this.buildNode(object, object2, node3.right, object4));
        }
        return FTreeMap.makeNode(object, object2, object3, object4);
    }

    private Object join(Object object, Object object2) {
        if (object == null) {
            return object2;
        }
        if (object2 == null) {
            return object;
        }
        Object object3 = this.min(object2);
        Object object4 = null;
        if (object3 instanceof Entry) {
            Entry entry = (Entry)object3;
            object3 = entry.key;
            object4 = entry.value;
        }
        return this.concat(object3, object4, object, this.lessMin(object2));
    }

    private Object min(Object object) {
        if (!(object instanceof Node)) {
            Object[] objectArray = (Object[])object;
            return new Entry(objectArray[0], objectArray[objectArray.length >> 1]);
        }
        Node node = (Node)object;
        if (node.left == null) {
            if (node.key instanceof EquivalentMap) {
                return node.key;
            }
            return node;
        }
        return this.min(node.left);
    }

    private Object lessMin(Object object) {
        if (!(object instanceof Node)) {
            Object[] objectArray = (Object[])object;
            return FTreeMap.subseq2(objectArray, 1, objectArray.length >> 1);
        }
        Node node = (Node)object;
        if (node.left == null) {
            return node.right;
        }
        return this.concat(node.key, node.value, this.lessMin(node.left), node.right);
    }

    private int hashCode(Object object) {
        if (object == null) {
            return 0;
        }
        if (!(object instanceof Node)) {
            Object[] objectArray = (Object[])object;
            int n = objectArray.length >> 1;
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                Object object2 = objectArray[i];
                Object object3 = objectArray[i + n];
                int n3 = (object2 == null ? 0 : object2.hashCode()) ^ (object3 == null ? 0 : object3.hashCode());
                n2 += n3;
            }
            return n2;
        }
        Node node = (Node)object;
        int n = this.hashCode(node.left) + this.hashCode(node.right);
        Object object4 = node.key;
        if (object4 instanceof EquivalentMap) {
            ArrayList<Entry> arrayList = ((EquivalentMap)object4).contents;
            int n4 = arrayList.size();
            for (int i = 0; i < n4; ++i) {
                n += arrayList.get(i).hashCode();
            }
        } else {
            n += (object4 == null ? 0 : object4.hashCode()) ^ (node.value == null ? 0 : node.value.hashCode());
        }
        return n;
    }

    private static String dump(Object object) {
        if (object == null) {
            return "[null]";
        }
        if (object == NEGATIVE_INFINITY) {
            return "-oo";
        }
        if (object == POSITIVE_INFINITY) {
            return "+oo";
        }
        if (object instanceof EquivalentMap) {
            ArrayList<Entry> arrayList = ((EquivalentMap)object).contents;
            String string = "[";
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    string = string + ", ";
                }
                string = string + FTreeMap.dump(arrayList.get(i));
            }
            return string + "]";
        }
        if (object instanceof Object[]) {
            StringBuffer stringBuffer = new StringBuffer("{");
            Object[] objectArray = (Object[])object;
            int n = objectArray.length >> 1;
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(FTreeMap.dump(objectArray[i]));
                stringBuffer.append(" -> ");
                stringBuffer.append(FTreeMap.dump(objectArray[i + n]));
                if (i >= n - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append("}");
            return stringBuffer.toString();
        }
        if (object instanceof Node) {
            Node node = (Node)object;
            return "(" + node.size + ", " + FTreeMap.dump(node.key) + (node.key instanceof EquivalentMap ? "" : " -> " + FTreeMap.dump(node.value)) + ";\n" + FTreeMap.indent(FTreeMap.dump(node.left), "  ") + ",\n" + FTreeMap.indent(FTreeMap.dump(node.right), "  ") + ")";
        }
        if (object instanceof Entry) {
            Entry entry = (Entry)object;
            return FTreeMap.dump(entry.key) + " -> " + FTreeMap.dump(entry.value);
        }
        return object.toString();
    }

    private static String indent(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string2);
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            stringBuffer.append(c);
            if (c != '\n' || i >= n - 1) continue;
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private boolean verify(Object object, Object object2, Object object3) {
        if (object == null) {
            return true;
        }
        if (!(object instanceof Node)) {
            Object[] objectArray = (Object[])object;
            boolean bl = true;
            Object object4 = object2;
            int n = objectArray.length >> 1;
            int n2 = n;
            for (int i = 0; i < n2; ++i) {
                Object object5 = objectArray[i];
                if (object5 instanceof EquivalentMap) {
                    return false;
                }
                if (object4 != NEGATIVE_INFINITY && this.compare(object4, object5) >= 0) {
                    bl = false;
                }
                object4 = object5;
            }
            if (object3 != POSITIVE_INFINITY && this.compare(object4, object3) >= 0) {
                bl = false;
            }
            return bl;
        }
        Node node = (Node)object;
        int n = FTreeMap.treeSize(node.left);
        int n3 = FTreeMap.treeSize(node.right);
        if (node.size != n + n3 + FTreeMap.keySize(node.key)) {
            return false;
        }
        if (node.key instanceof Entry) {
            return false;
        }
        if (node.key instanceof EquivalentMap && ((EquivalentMap)node.key).contents.size() < 2) {
            return false;
        }
        if (n3 > 4 && n > n3 * 4 || n > 4 && n3 > n * 4) {
            return false;
        }
        return this.verify(node.left, object2, node.key) && this.verify(node.right, node.key, object3);
    }

    private static Object equivUnion(Object object, Object object2, Object object3, Object object4, BinaryOp binaryOp) {
        if (object instanceof EquivalentMap) {
            ArrayList<Entry> arrayList = ((EquivalentMap)object).contents;
            if (object3 instanceof EquivalentMap) {
                ArrayList<Entry> arrayList2 = ((EquivalentMap)object3).contents;
                ArrayList arrayList3 = (ArrayList)arrayList2.clone();
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    Entry entry = arrayList.get(i);
                    boolean bl = false;
                    int n2 = arrayList3.size();
                    for (int j = 0; j < n2 && !bl; ++j) {
                        Entry entry2 = (Entry)arrayList3.get(j);
                        if (!FTreeMap.eql(entry2.key, entry.key)) continue;
                        arrayList3.set(j, new Entry(entry.key, binaryOp.apply(entry.value, entry2.value)));
                        bl = true;
                    }
                    if (bl) continue;
                    arrayList3.add(entry);
                }
                arrayList3.trimToSize();
                return new EquivalentMap(arrayList3);
            }
            ArrayList arrayList4 = (ArrayList)arrayList.clone();
            boolean bl = false;
            int n = arrayList4.size();
            for (int i = 0; i < n && !bl; ++i) {
                Entry entry = (Entry)arrayList4.get(i);
                if (!FTreeMap.eql(object3, entry.key)) continue;
                arrayList4.set(i, new Entry(entry.key, binaryOp.apply(entry.value, object4)));
                bl = true;
            }
            if (!bl) {
                arrayList4.add(new Entry(object3, object4));
            }
            arrayList4.trimToSize();
            return new EquivalentMap(arrayList4);
        }
        if (object3 instanceof EquivalentMap) {
            ArrayList arrayList = (ArrayList)((EquivalentMap)object3).contents.clone();
            boolean bl = false;
            int n = arrayList.size();
            for (int i = 0; i < n && !bl; ++i) {
                Entry entry = (Entry)arrayList.get(i);
                if (!FTreeMap.eql(object, entry.key)) continue;
                arrayList.set(i, new Entry(object, binaryOp.apply(object2, entry.value)));
                bl = true;
            }
            if (!bl) {
                arrayList.add(new Entry(object, object2));
            }
            arrayList.trimToSize();
            return new EquivalentMap(arrayList);
        }
        if (FTreeMap.eql(object, object3)) {
            return new Entry(object, binaryOp.apply(object2, object4));
        }
        ArrayList<Entry> arrayList = new ArrayList<Entry>(2);
        arrayList.add(new Entry(object, object2));
        arrayList.add(new Entry(object3, object4));
        return new EquivalentMap(arrayList);
    }

    private static Object equivRestrictedTo(Object object, Object object2, Object object3) {
        if (object instanceof EquivalentMap) {
            ArrayList<Entry> arrayList = ((EquivalentMap)object).contents;
            if (object3 instanceof FTreeSet.EquivalentSet) {
                ArrayList<Object> arrayList2 = ((FTreeSet.EquivalentSet)object3).contents;
                ArrayList<Entry> arrayList3 = new ArrayList<Entry>();
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    Entry entry = arrayList.get(i);
                    if (!arrayList2.contains(entry.key)) continue;
                    arrayList3.add(entry);
                }
                if (arrayList3.size() == 0) {
                    return null;
                }
                if (arrayList3.size() == 1) {
                    return arrayList3.get(0);
                }
                arrayList3.trimToSize();
                return new EquivalentMap(arrayList3);
            }
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Entry entry = arrayList.get(i);
                if (!FTreeMap.eql(object3, entry.key)) continue;
                return entry;
            }
            return null;
        }
        if (object3 instanceof FTreeSet.EquivalentSet) {
            ArrayList<Object> arrayList = ((FTreeSet.EquivalentSet)object3).contents;
            if (arrayList.contains(object)) {
                return new Entry(object, object2);
            }
            return null;
        }
        if (FTreeMap.eql(object, object3)) {
            return new Entry(object, object2);
        }
        return null;
    }

    private static Object equivRestrictedFrom(Object object, Object object2, Object object3) {
        if (object instanceof EquivalentMap) {
            ArrayList<Entry> arrayList = ((EquivalentMap)object).contents;
            ArrayList<Entry> arrayList2 = new ArrayList<Entry>();
            if (object3 instanceof FTreeSet.EquivalentSet) {
                ArrayList<Object> arrayList3 = ((FTreeSet.EquivalentSet)object3).contents;
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    Entry entry = arrayList.get(i);
                    if (arrayList3.contains(entry.key)) continue;
                    arrayList2.add(entry);
                }
            } else {
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    Entry entry = arrayList.get(i);
                    if (FTreeMap.eql(object3, entry.key)) continue;
                    arrayList2.add(entry);
                }
            }
            if (arrayList2.size() == 0) {
                return null;
            }
            if (arrayList2.size() == 1) {
                return arrayList2.get(0);
            }
            arrayList2.trimToSize();
            return new EquivalentMap(arrayList2);
        }
        if (object3 instanceof FTreeSet.EquivalentSet) {
            ArrayList<Object> arrayList = ((FTreeSet.EquivalentSet)object3).contents;
            if (!arrayList.contains(object)) {
                return new Entry(object, object2);
            }
            return null;
        }
        if (!FTreeMap.eql(object, object3)) {
            return new Entry(object, object2);
        }
        return null;
    }

    private static Object equivLess(Object object, Object object2) {
        ArrayList arrayList = ((EquivalentMap)object).contents;
        int n = -1;
        int n2 = arrayList.size();
        for (int i = 0; i < n2 && n < 0; ++i) {
            Entry entry = arrayList.get(i);
            if (!FTreeMap.eql(object2, entry.key)) continue;
            n = i;
        }
        if (n >= 0) {
            arrayList = (ArrayList)arrayList.clone();
            arrayList.remove(n);
            if (arrayList.size() == 1) {
                return arrayList.get(0);
            }
            return new EquivalentMap(arrayList);
        }
        return object;
    }

    private static int equivCompare(Object object, Object object2, Object object3, Object object4) {
        if (object instanceof EquivalentMap) {
            ArrayList<Entry> arrayList = ((EquivalentMap)object).contents;
            if (object3 instanceof EquivalentMap) {
                int n;
                int n2;
                ArrayList<Entry> arrayList2 = ((EquivalentMap)object3).contents;
                int n3 = arrayList.size();
                if (n3 < (n2 = arrayList2.size())) {
                    return 1;
                }
                if (n3 > n2) {
                    return -1;
                }
                FSet fSet = new FTreeSet();
                FSet fSet2 = new FTreeSet();
                for (n = 0; n < n3; ++n) {
                    fSet = fSet.with(arrayList.get((int)n).value);
                }
                for (n = 0; n < n2; ++n) {
                    fSet2 = fSet2.with(arrayList2.get((int)n).value);
                }
                return fSet.compareTo(fSet2);
            }
            return -1;
        }
        if (object3 instanceof EquivalentMap) {
            return 1;
        }
        return ((Comparable)object2).compareTo((Comparable)object4);
    }

    private static boolean equivEquals(Object object, Object object2) {
        if (object instanceof EquivalentMap) {
            ArrayList<Entry> arrayList = ((EquivalentMap)object).contents;
            if (object2 instanceof EquivalentMap) {
                int n;
                ArrayList<Entry> arrayList2 = ((EquivalentMap)object2).contents;
                int n2 = arrayList.size();
                if (n2 != (n = arrayList2.size())) {
                    return false;
                }
                for (int i = 0; i < n2; ++i) {
                    boolean bl = false;
                    Entry entry = arrayList.get(i);
                    for (int j = 0; j < n && !bl; ++j) {
                        Entry entry2 = arrayList2.get(j);
                        if (!FTreeMap.eql(entry.key, entry2.key) || !FTreeMap.eql(entry.value, entry2.value)) continue;
                        bl = true;
                    }
                    if (bl) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (object2 instanceof EquivalentMap) {
            return false;
        }
        return FTreeMap.eql(object, object2);
    }

    private static Object[] makeArray2(Object object, Object object2, Object[] objectArray, Object[] objectArray2) {
        int n;
        int n2 = objectArray == null ? 0 : objectArray.length >> 1;
        int n3 = objectArray2 == null ? 0 : objectArray2.length >> 1;
        int n4 = n2 + 1 + n3;
        Object[] objectArray3 = new Object[n4 << 1];
        for (n = 0; n < n2; ++n) {
            objectArray3[n] = objectArray[n];
            objectArray3[n + n4] = objectArray[n + n2];
        }
        objectArray3[n2] = object;
        objectArray3[n2 + n4] = object2;
        for (n = 0; n < n3; ++n) {
            objectArray3[n + n2 + 1] = objectArray2[n];
            objectArray3[n + n2 + 1 + n4] = objectArray2[n + n3];
        }
        return objectArray3;
    }

    private static Object[] insert2(Object[] objectArray, int n, Object object, Object object2) {
        int n2;
        int n3 = objectArray.length >> 1;
        Object[] objectArray2 = new Object[objectArray.length + 2];
        for (n2 = 0; n2 < n; ++n2) {
            objectArray2[n2] = objectArray[n2];
            objectArray2[n2 + n3 + 1] = objectArray[n2 + n3];
        }
        objectArray2[n] = object;
        objectArray2[n + n3 + 1] = object2;
        for (n2 = n; n2 < n3; ++n2) {
            objectArray2[n2 + 1] = objectArray[n2];
            objectArray2[n2 + n3 + 2] = objectArray[n2 + n3];
        }
        return objectArray2;
    }

    private static Object[] remove2(Object[] objectArray, int n) {
        int n2;
        int n3 = objectArray.length >> 1;
        if (n3 == 1) {
            return null;
        }
        Object[] objectArray2 = new Object[objectArray.length - 2];
        for (n2 = 0; n2 < n; ++n2) {
            objectArray2[n2] = objectArray[n2];
            objectArray2[n2 + n3 - 1] = objectArray[n2 + n3];
        }
        for (n2 = n + 1; n2 < n3; ++n2) {
            objectArray2[n2 - 1] = objectArray[n2];
            objectArray2[n2 + n3 - 2] = objectArray[n2 + n3];
        }
        return objectArray2;
    }

    private static Object[] subseq2(Object[] objectArray, int n, int n2) {
        if (n >= n2) {
            return null;
        }
        int n3 = objectArray.length >> 1;
        int n4 = n2 - n;
        Object[] objectArray2 = new Object[n4 << 1];
        for (int i = 0; i < n4; ++i) {
            objectArray2[i] = objectArray[i + n];
            objectArray2[i + n4] = objectArray[i + n + n3];
        }
        return objectArray2;
    }

    private static Object[] update2(Object[] objectArray, int n, Object object) {
        int n2 = objectArray.length;
        Object[] objectArray2 = new Object[n2];
        for (int i = 0; i < n2; ++i) {
            objectArray2[i] = objectArray[i];
        }
        objectArray2[n + (n2 >> 1)] = object;
        return objectArray2;
    }

    private Object union2(Object[] objectArray, Object[] objectArray2, BinaryOp binaryOp, Object object, Object object2) {
        int n;
        Object object3;
        Object object4;
        int n2;
        int n3 = 0;
        int n4 = objectArray.length >> 1;
        int n5 = objectArray2.length >> 1;
        int n6 = n4;
        int n7 = n5;
        if (object != NEGATIVE_INFINITY) {
            for (n2 = 0; n2 < n6 && this.compare(object, objectArray[n2]) >= 0; ++n2) {
            }
            while (n3 < n7 && this.compare(object, objectArray2[n3]) >= 0) {
                ++n3;
            }
        }
        if (object2 != POSITIVE_INFINITY) {
            while (n2 < n6 && this.compare(object2, objectArray[n6 - 1]) <= 0) {
                --n6;
            }
            while (n3 < n7 && this.compare(object2, objectArray2[n7 - 1]) <= 0) {
                --n7;
            }
        }
        int n8 = n6 - n2 + (n7 - n3);
        ArrayList<Object> arrayList = new ArrayList<Object>(n8);
        ArrayList<Object> arrayList2 = new ArrayList<Object>(n8);
        boolean bl = false;
        while (true) {
            if (n2 == n6) {
                while (n3 < n7) {
                    arrayList.add(objectArray2[n3]);
                    arrayList2.add(objectArray2[n3 + n5]);
                    ++n3;
                }
                break;
            }
            if (n3 == n7) {
                while (n2 < n6) {
                    arrayList.add(objectArray[n2]);
                    arrayList2.add(objectArray[n2 + n4]);
                    ++n2;
                }
                break;
            }
            object4 = objectArray[n2];
            object3 = objectArray2[n3];
            n = this.compare(object4, object3);
            if (n < 0) {
                arrayList.add(object4);
                arrayList2.add(objectArray[n2 + n4]);
                ++n2;
                continue;
            }
            if (n > 0) {
                arrayList.add(object3);
                arrayList2.add(objectArray2[n3 + n5]);
                ++n3;
                continue;
            }
            if (FTreeMap.eql(object4, object3)) {
                arrayList.add(object4);
                arrayList2.add(binaryOp.apply(objectArray[n2 + n4], objectArray2[n3 + n5]));
            } else {
                arrayList.add(FTreeMap.equivUnion(object4, objectArray[n2 + n4], object3, objectArray2[n3 + n5], binaryOp));
                arrayList2.add(null);
                bl = true;
            }
            ++n2;
            ++n3;
        }
        if (bl) {
            object4 = null;
            object3 = arrayList.iterator();
            Iterator iterator = arrayList2.iterator();
            while (object3.hasNext()) {
                object4 = this.with(object4, object3.next(), iterator.next());
            }
            return object4;
        }
        int n9 = arrayList.size();
        arrayList.addAll(arrayList2);
        object3 = arrayList.toArray();
        if (((Object[])object3).length > 16) {
            n = n9 >> 1;
            return FTreeMap.makeNode(arrayList.get(n), arrayList2.get(n), FTreeMap.subseq2(object3, 0, n), FTreeMap.subseq2(object3, n + 1, n9));
        }
        return object3;
    }

    private Object[] restrictedTo2(Object[] objectArray, Object[] objectArray2, Object object, Object object2) {
        int n;
        int n2 = 0;
        int n3 = objectArray.length >> 1;
        int n4 = objectArray2.length;
        int n5 = n3;
        int n6 = n4;
        if (object != NEGATIVE_INFINITY) {
            for (n = 0; n < n5 && this.compare(object, objectArray[n]) >= 0; ++n) {
            }
            while (n2 < n6 && this.compare(object, objectArray2[n2]) >= 0) {
                ++n2;
            }
        }
        if (object2 != POSITIVE_INFINITY) {
            while (n < n5 && this.compare(object2, objectArray[n5 - 1]) <= 0) {
                --n5;
            }
            while (n2 < n6 && this.compare(object2, objectArray2[n6 - 1]) <= 0) {
                --n6;
            }
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(n5 - n);
        ArrayList<Object> arrayList2 = new ArrayList<Object>(n5 - n);
        while (n < n5 && n2 < n6) {
            Object object3 = objectArray[n];
            Object object4 = objectArray2[n2];
            int n7 = this.compare(object3, object4);
            if (n7 < 0) {
                ++n;
                continue;
            }
            if (n7 > 0) {
                ++n2;
                continue;
            }
            if (FTreeMap.eql(object3, object4)) {
                arrayList.add(object3);
                arrayList2.add(objectArray[n + n3]);
            }
            ++n;
            ++n2;
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        arrayList.addAll(arrayList2);
        return arrayList.toArray();
    }

    private Object[] restrictedFrom2(Object[] objectArray, Object[] objectArray2, Object object, Object object2) {
        int n;
        int n2 = 0;
        int n3 = objectArray.length >> 1;
        int n4 = objectArray2.length;
        int n5 = n3;
        int n6 = n4;
        if (object != NEGATIVE_INFINITY) {
            for (n = 0; n < n5 && this.compare(object, objectArray[n]) >= 0; ++n) {
            }
            while (n2 < n6 && this.compare(object, objectArray2[n2]) >= 0) {
                ++n2;
            }
        }
        if (object2 != POSITIVE_INFINITY) {
            while (n < n5 && this.compare(object2, objectArray[n5 - 1]) <= 0) {
                --n5;
            }
            while (n2 < n6 && this.compare(object2, objectArray2[n6 - 1]) <= 0) {
                --n6;
            }
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(n5 - n);
        ArrayList<Object> arrayList2 = new ArrayList<Object>(n5 - n);
        while (n < n5 && n2 < n6) {
            Object object3 = objectArray[n];
            Object object4 = objectArray2[n2];
            int n7 = this.compare(object3, object4);
            if (n7 < 0) {
                arrayList.add(object3);
                arrayList2.add(objectArray[n + n3]);
                ++n;
                continue;
            }
            if (n7 > 0) {
                ++n2;
                continue;
            }
            if (!FTreeMap.eql(object3, object4)) {
                arrayList.add(object3);
                arrayList2.add(objectArray[n + n3]);
            }
            ++n;
            ++n2;
        }
        while (n < n5) {
            arrayList.add(objectArray[n]);
            arrayList2.add(objectArray[n + n3]);
            ++n;
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        arrayList.addAll(arrayList2);
        return arrayList.toArray();
    }

    private int binarySearch(Object[] objectArray, Object object) {
        int n = objectArray.length >> 1;
        int n2 = 0;
        int n3 = n - 1;
        while (n2 <= n3) {
            int n4 = (n2 + n3) / 2;
            Object object2 = objectArray[n4];
            int n5 = this.compare(object, object2);
            if (n5 == 0) {
                return n4 << 1 | 1;
            }
            if (n5 < 0) {
                n3 = n4 - 1;
                continue;
            }
            n2 = n4 + 1;
        }
        return n2 << 1 | 0;
    }

    private int binarySearchLo(Object[] objectArray, Object object) {
        int n = this.binarySearch(objectArray, object);
        int n2 = n >> 1;
        if ((n & 1) == 1) {
            return n2 + 1;
        }
        return n2;
    }

    private int binarySearchHi(Object[] objectArray, Object object) {
        int n = this.binarySearch(objectArray, object);
        return n >> 1;
    }

    private static boolean eql(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size());
        for (Map.Entry<Key, Val> entry : this) {
            Entry entry2 = (Entry)entry;
            objectOutputStream.writeObject(entry2.key);
            objectOutputStream.writeObject(entry2.value);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.hash_code = Integer.MIN_VALUE;
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        Object object = null;
        for (int i = 0; i < n; ++i) {
            Object object2 = objectInputStream.readObject();
            Object object3 = objectInputStream.readObject();
            object = this.with(object, object2, object3);
        }
        try {
            TreeField.set(this, object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("FTreeMap deserialization failed", illegalAccessException);
        }
    }

    static {
        try {
            TreeField = FTreeMap.class.getDeclaredField("tree");
            TreeField.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RuntimeException("Static initialization failed", noSuchFieldException);
        }
    }

    private static class FTMValueIterator<Val>
    implements Iterator<Val> {
        private FTMIterator<Object, Val> ftmIter;

        FTMValueIterator(Object object) {
            this.ftmIter = new FTMIterator(object);
        }

        @Override
        public boolean hasNext() {
            return this.ftmIter.hasNext();
        }

        @Override
        public Val next() {
            return (Val)this.ftmIter.next().getValue();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class FTMKeyIterator<Key>
    implements Iterator<Key> {
        private FTMIterator<Key, Object> ftmIter;

        FTMKeyIterator(Object object) {
            this.ftmIter = new FTMIterator(object);
        }

        @Override
        public boolean hasNext() {
            return this.ftmIter.hasNext();
        }

        @Override
        public Key next() {
            Object object;
            if (((FTMIterator)this.ftmIter).inode == null) {
                throw new NoSuchElementException();
            }
            if (!(((FTMIterator)this.ftmIter).inode.subtree instanceof Node)) {
                Object[] objectArray = (Object[])((FTMIterator)this.ftmIter).inode.subtree;
                object = objectArray[((FTMIterator)this.ftmIter).inode.index];
            } else {
                Node node = (Node)((FTMIterator)this.ftmIter).inode.subtree;
                if (node.key instanceof EquivalentMap) {
                    ArrayList<Entry> arrayList = ((EquivalentMap)node.key).contents;
                    object = arrayList.get((int)(((FTMIterator.IteratorNode)((FTMIterator)this.ftmIter).inode).index - 1)).key;
                } else {
                    object = node.key;
                }
            }
            ((FTMIterator)this.ftmIter).inode.index++;
            ((FTMIterator)this.ftmIter).canonicalize();
            return (Key)object;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class FTMIterator<Key, Val>
    implements Iterator<Map.Entry<Key, Val>> {
        private IteratorNode inode;

        private FTMIterator(Object object) {
            this.inode = new IteratorNode(object, 0, null);
            this.canonicalize();
        }

        private void canonicalize() {
            while (this.inode != null) {
                if (this.inode.subtree == null) {
                    this.inode = this.inode.parent;
                    if (this.inode == null) break;
                    ++this.inode.index;
                    continue;
                }
                if (!(this.inode.subtree instanceof Node)) {
                    if (this.inode.index < ((Object[])this.inode.subtree).length >> 1) break;
                    this.inode = this.inode.parent;
                    if (this.inode == null) break;
                    ++this.inode.index;
                    continue;
                }
                Node node = (Node)this.inode.subtree;
                if (this.inode.index == 0) {
                    this.inode = new IteratorNode(node.left, 0, this.inode);
                    continue;
                }
                if (this.inode.index != FTreeMap.keySize(node.key) + 1) break;
                this.inode = new IteratorNode(node.right, 0, this.inode.parent);
            }
        }

        @Override
        public boolean hasNext() {
            return this.inode != null;
        }

        @Override
        public Map.Entry<Key, Val> next() {
            Entry entry;
            if (this.inode == null) {
                throw new NoSuchElementException();
            }
            if (!(this.inode.subtree instanceof Node)) {
                Object[] objectArray = (Object[])this.inode.subtree;
                entry = new Entry(objectArray[this.inode.index], objectArray[this.inode.index + (objectArray.length >> 1)]);
            } else {
                Node node = (Node)this.inode.subtree;
                if (node.key instanceof EquivalentMap) {
                    ArrayList<Entry> arrayList = ((EquivalentMap)node.key).contents;
                    entry = arrayList.get(this.inode.index - 1);
                } else {
                    entry = node;
                }
            }
            this.inode.index++;
            this.canonicalize();
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private static final class IteratorNode {
            private final Object subtree;
            private int index;
            private final IteratorNode parent;

            IteratorNode(Object object, int n, IteratorNode iteratorNode) {
                this.subtree = object;
                this.index = n;
                this.parent = iteratorNode;
            }
        }
    }

    private static final class EquivalentMap {
        ArrayList<Entry> contents;

        EquivalentMap(ArrayList<Entry> arrayList) {
            this.contents = arrayList;
        }
    }

    private static final class RankTrimResult {
        Object subtree;
        int base;

        RankTrimResult(Object object, int n) {
            this.subtree = object;
            this.base = n;
        }
    }

    private static final class Node
    extends Entry {
        private final int size;
        private final Object left;
        private final Object right;

        Node(int n, Object object, Object object2, Object object3, Object object4) {
            super(object, object2);
            this.size = n;
            this.left = object3;
            this.right = object4;
        }
    }

    static class EntryComparator<Key>
    implements Comparator<Entry> {
        Comparator<Key> map_comp;

        EntryComparator(Comparator<Key> comparator) {
            this.map_comp = comparator;
        }

        @Override
        public int compare(Entry entry, Entry entry2) {
            int n = this.map_comp.compare(entry.key, entry2.key);
            if (n != 0) {
                return n;
            }
            return ((Comparable)entry.value).compareTo(entry2.value);
        }
    }

    static class Entry
    implements Map.Entry<Object, Object> {
        final Object key;
        final Object value;

        Entry(Object object, Object object2) {
            this.key = object;
            this.value = object2;
        }

        @Override
        public Object getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Object setValue(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public int compareTo(Object object) {
            if (object == this) {
                return 0;
            }
            if (object instanceof Entry) {
                Entry entry = (Entry)object;
                int n = ((Comparable)this.key).compareTo(entry.key);
                if (n != 0) {
                    return n;
                }
                return ((Comparable)this.value).compareTo(entry.value);
            }
            throw new ClassCastException();
        }

        @Override
        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return FTreeMap.eql(this.key, entry.getKey()) && FTreeMap.eql(this.value, entry.getValue());
        }
    }
}

