/*
 * Decompiled with CFR 0.152.
 */
package com.ergy.fset;

import com.ergy.fset.AbstractFSet;
import com.ergy.fset.FHashSet;
import com.ergy.fset.FList;
import com.ergy.fset.FTreeList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class FLinkedHashSet<Elt>
extends AbstractFSet<Elt>
implements Comparable<FLinkedHashSet<Elt>>,
Serializable {
    private static final FLinkedHashSet<?> EMPTY_INSTANCE = new FLinkedHashSet();
    final transient Object set_tree;
    private final transient Object list_tree;
    private transient int hash_code = Integer.MIN_VALUE;
    private static Field SetTreeField;
    private static Field ListTreeField;

    public static <Elt> FLinkedHashSet<Elt> emptySet() {
        return EMPTY_INSTANCE;
    }

    public FLinkedHashSet() {
        this.set_tree = null;
        this.list_tree = null;
    }

    public FLinkedHashSet(Elt Elt) {
        this.set_tree = FHashSet.with(null, Elt, 0);
        this.list_tree = FTreeList.insert(null, 0, Elt);
    }

    @Override
    public boolean isEmpty() {
        return this.set_tree == null;
    }

    @Override
    public int size() {
        return FHashSet.treeSize(this.set_tree);
    }

    public FList<Elt> toList() {
        return new FTreeList(this.list_tree, null);
    }

    @Override
    public Elt arb() {
        if (this.list_tree == null) {
            throw new NoSuchElementException();
        }
        return (Elt)FTreeList.get(this.list_tree, 0);
    }

    @Override
    public boolean contains(Object object) {
        return FHashSet.contains(this.set_tree, object, FLinkedHashSet.hashCode(object));
    }

    @Override
    public FLinkedHashSet<Elt> with(Elt Elt) {
        Object object = FHashSet.with(this.set_tree, Elt, FLinkedHashSet.hashCode(Elt));
        if (object == this.set_tree) {
            return this;
        }
        return new FLinkedHashSet<Elt>(object, FTreeList.insert(this.list_tree, FTreeList.treeSize(this.list_tree), Elt));
    }

    @Override
    public FLinkedHashSet<Elt> less(Elt Elt) {
        Object object = FHashSet.less(this.set_tree, Elt, FLinkedHashSet.hashCode(Elt));
        if (object == this.set_tree) {
            return this;
        }
        FTreeList.FTLIterator fTLIterator = new FTreeList.FTLIterator(this.list_tree);
        int n = 0;
        while (!FLinkedHashSet.eql(Elt, fTLIterator.next())) {
            ++n;
        }
        Object object2 = FTreeList.less(this.list_tree, n);
        return new FLinkedHashSet<Elt>(object, object2);
    }

    @Override
    public Iterator<Elt> iterator() {
        return new FTreeList.FTLIterator(this.list_tree);
    }

    @Override
    public FLinkedHashSet<Elt> union(Collection<? extends Elt> collection) {
        Object object = this.set_tree;
        Object object2 = this.list_tree;
        for (Elt Elt : collection) {
            Object object3 = object;
            if ((object = FHashSet.with(object, Elt, FLinkedHashSet.hashCode(Elt))) == object3) continue;
            object2 = FTreeList.insert(object2, FTreeList.treeSize(object2), Elt);
        }
        if (object == this.set_tree) {
            return this;
        }
        return new FLinkedHashSet<Elt>(object, object2);
    }

    @Override
    public FLinkedHashSet<Elt> intersection(Collection<? extends Elt> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FLinkedHashSet<Elt> difference(Collection<? extends Elt> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int compareTo(FLinkedHashSet<Elt> fLinkedHashSet) {
        return FHashSet.compareTo(this.set_tree, fLinkedHashSet.set_tree);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof FLinkedHashSet) {
            FLinkedHashSet fLinkedHashSet = (FLinkedHashSet)object;
            return FHashSet.equals(this.set_tree, fLinkedHashSet.set_tree);
        }
        if (object instanceof FHashSet) {
            FHashSet fHashSet = (FHashSet)object;
            return FHashSet.equals(this.set_tree, fHashSet.tree);
        }
        if (!(object instanceof Set)) {
            return false;
        }
        Set set = (Set)object;
        if (this.size() != set.size()) {
            return false;
        }
        for (Object e : set) {
            if (FHashSet.contains(this.set_tree, e, FLinkedHashSet.hashCode(e))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSubset(Collection<?> collection) {
        if (collection == this) {
            return true;
        }
        if (this.size() > collection.size()) {
            return false;
        }
        if (collection instanceof FLinkedHashSet) {
            FLinkedHashSet fLinkedHashSet = (FLinkedHashSet)collection;
            return FHashSet.isSubset(this.set_tree, fLinkedHashSet.set_tree);
        }
        if (collection instanceof FHashSet) {
            FHashSet fHashSet = (FHashSet)collection;
            return FHashSet.isSubset(this.set_tree, fHashSet.tree);
        }
        if (!(collection instanceof Set)) {
            return false;
        }
        for (Elt Elt : this) {
            if (collection.contains(Elt)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSuperset(Collection<?> collection) {
        if (collection == this) {
            return true;
        }
        if (this.size() < collection.size()) {
            return false;
        }
        if (collection instanceof FLinkedHashSet) {
            FLinkedHashSet fLinkedHashSet = (FLinkedHashSet)collection;
            return FHashSet.isSubset(fLinkedHashSet.set_tree, this.set_tree);
        }
        if (collection instanceof FHashSet) {
            FHashSet fHashSet = (FHashSet)collection;
            return FHashSet.isSubset(fHashSet.tree, this.set_tree);
        }
        if (!(collection instanceof Set)) {
            return false;
        }
        for (Object obj : collection) {
            if (FHashSet.contains(this.set_tree, obj, FLinkedHashSet.hashCode(obj))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this.hash_code == Integer.MIN_VALUE) {
            this.hash_code = FHashSet.myHashCode(this.set_tree);
        }
        return this.hash_code;
    }

    private FLinkedHashSet(Object object, Object object2) {
        this.set_tree = object;
        this.list_tree = object2;
    }

    private static boolean eql(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    private static int hashCode(Object object) {
        return FHashSet.hashCode(object);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size());
        for (Elt Elt : this) {
            objectOutputStream.writeObject(Elt);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.hash_code = Integer.MIN_VALUE;
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        Object object = null;
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            Object object2 = objectInputStream.readObject();
            object = FHashSet.with(object, object2, FLinkedHashSet.hashCode(object2));
            objectArray[i] = object2;
        }
        try {
            SetTreeField.set(this, object);
            ListTreeField.set(this, FTreeList.fromCollection(objectArray));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("FLinkedHashSet deserialization failed", illegalAccessException);
        }
    }

    static {
        try {
            SetTreeField = FLinkedHashSet.class.getDeclaredField("set_tree");
            ListTreeField = FLinkedHashSet.class.getDeclaredField("list_tree");
            SetTreeField.setAccessible(true);
            ListTreeField.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RuntimeException("Static initialization failed", noSuchFieldException);
        }
    }
}

