/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.frontend.nst;

public enum NSTOperators {
    Add{

        @Override
        public String prettyString() {
            return "+";
        }

        @Override
        public String nstString() {
            return ":+:";
        }
    }
    ,
    Subtract{

        @Override
        public String prettyString() {
            return "-";
        }

        @Override
        public String nstString() {
            return ":-:";
        }
    }
    ,
    Multiply{

        @Override
        public String prettyString() {
            return "*";
        }

        @Override
        public String nstString() {
            return ":*:";
        }
    }
    ,
    Divide{

        @Override
        public String prettyString() {
            return "/";
        }

        @Override
        public String nstString() {
            return ":/:";
        }
    }
    ,
    Mod{

        @Override
        public String prettyString() {
            return "%";
        }

        @Override
        public String nstString() {
            return ":%:";
        }
    }
    ,
    And{

        @Override
        public String prettyString() {
            return "&";
        }

        @Override
        public String nstString() {
            return ":&:";
        }
    }
    ,
    Or{

        @Override
        public String prettyString() {
            return "|";
        }

        @Override
        public String nstString() {
            return ":|:";
        }
    }
    ,
    Xor{

        @Override
        public String prettyString() {
            return "^";
        }

        @Override
        public String nstString() {
            return ":^:";
        }
    }
    ,
    Lshift{

        @Override
        public String prettyString() {
            return "<<";
        }

        @Override
        public String nstString() {
            return ":<<:";
        }
    }
    ,
    Rshift{

        @Override
        public String prettyString() {
            return ">>";
        }

        @Override
        public String nstString() {
            return ":>>:";
        }
    }
    ,
    Bwrshift{

        @Override
        public String prettyString() {
            return ">>>";
        }

        @Override
        public String nstString() {
            return ":>>>:";
        }
    }
    ,
    Equal{

        @Override
        public String prettyString() {
            return "==";
        }

        @Override
        public String nstString() {
            return ":==:";
        }
    }
    ,
    NotEqual{

        @Override
        public String prettyString() {
            return "!=";
        }

        @Override
        public String nstString() {
            return ":!=:";
        }
    }
    ,
    LessThan{

        @Override
        public String prettyString() {
            return "<";
        }

        @Override
        public String nstString() {
            return ":<:";
        }
    }
    ,
    GreaterThan{

        @Override
        public String prettyString() {
            return ">";
        }

        @Override
        public String nstString() {
            return ":>:";
        }
    }
    ,
    LessThanEqual{

        @Override
        public String prettyString() {
            return "<=";
        }

        @Override
        public String nstString() {
            return ":<=:";
        }
    }
    ,
    GreaterThanEqual{

        @Override
        public String prettyString() {
            return ">=";
        }

        @Override
        public String nstString() {
            return ":>=:";
        }
    }
    ,
    In{

        @Override
        public String prettyString() {
            return "in";
        }

        @Override
        public String nstString() {
            return ":==:";
        }
    }
    ,
    Between{

        @Override
        public String prettyString() {
            return "between";
        }

        @Override
        public String nstString() {
            return ":!=:";
        }
    }
    ,
    Like{

        @Override
        public String prettyString() {
            return "like";
        }

        @Override
        public String nstString() {
            return ":==:";
        }
    }
    ,
    Concatenate{

        @Override
        public String prettyString() {
            return "||";
        }

        @Override
        public String nstString() {
            return ":+:";
        }
    }
    ,
    Is{

        @Override
        public String prettyString() {
            return "is";
        }

        @Override
        public String nstString() {
            return ":is:";
        }
    }
    ,
    Exponent{

        @Override
        public String prettyString() {
            return "*";
        }

        @Override
        public String nstString() {
            return ":*:";
        }
    }
    ,
    Bwcomplement{

        @Override
        public boolean isUnary() {
            return true;
        }

        @Override
        public String prettyString() {
            return "~";
        }

        @Override
        public String nstString() {
            return ":~:";
        }
    }
    ,
    Ref{

        @Override
        public boolean isUnary() {
            return true;
        }

        @Override
        public String prettyString() {
            return "&";
        }

        @Override
        public String nstString() {
            return ":&:";
        }
    }
    ,
    Arraylen{

        @Override
        public boolean isUnary() {
            return true;
        }

        @Override
        public boolean isPostfix() {
            return true;
        }

        @Override
        public String prettyString() {
            return ".length";
        }

        @Override
        public String nstString() {
            return ":`:";
        }
    }
    ,
    Not{

        @Override
        public boolean isUnary() {
            return true;
        }

        @Override
        public String prettyString() {
            return "!";
        }

        @Override
        public String nstString() {
            return ":!:";
        }
    };


    public boolean isUnary() {
        return false;
    }

    public boolean isPostfix() {
        return false;
    }

    public String toString() {
        return this.prettyString();
    }

    public abstract String nstString();

    public abstract String prettyString();
}

