/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.prodsuite.licenses;

import com.lightbend.inkan.Decode;
import com.lightbend.prodsuite.licenses.EnterpriseSuiteLicense;
import com.lightbend.prodsuite.licenses.MalformedLicenseException;
import com.lightbend.prodsuite.licenses.MissingLicensePropertyException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class LicenseParser {
    public static EnterpriseSuiteLicense parse(String string2) {
        boolean bl;
        String string3 = LicenseParser.extractSignature(string2);
        String string4 = new String(Decode.decode(string3));
        Map<String, String> map = LicenseParser.parseLicenseProperties(string4);
        String string5 = LicenseParser.getLicenseProperty(map, "user");
        Optional<Integer> optional = Optional.ofNullable(map.get("max-conductr-agents")).map(Integer::new);
        Optional<Set<String>> optional2 = Optional.ofNullable(map.get("conductr-versions")).map(string -> {
            if (string.trim().isEmpty()) {
                return new TreeSet();
            }
            return new TreeSet(Arrays.asList(string.split(",")).stream().map(String::trim).collect(Collectors.toSet()));
        });
        Set set = Optional.ofNullable(map.get("grants")).map(string -> new TreeSet(Arrays.asList(string.split(",")).stream().map(String::trim).collect(Collectors.toSet()))).orElse(new TreeSet());
        Optional<ZonedDateTime> optional3 = Optional.ofNullable(map.get("expiry")).map(string -> ZonedDateTime.parse(string, EnterpriseSuiteLicense.EXPIRY_DATE_FORMAT));
        boolean bl2 = bl = !optional2.isPresent() || optional2.filter(Set::isEmpty).isPresent();
        if (bl && !optional3.isPresent()) {
            throw new MissingLicensePropertyException("expiry");
        }
        return new EnterpriseSuiteLicense(string5, optional2, optional, optional3, set);
    }

    private static String extractSignature(String string2) {
        return Optional.ofNullable(string2).map(string -> LicenseParser.extractSignature(Arrays.asList(string.split("\n")), new ArrayList<String>(), false)).map(list -> LicenseParser.mkString(list, "")).orElseThrow(() -> new MalformedLicenseException(string2 + " is not a valid license"));
    }

    private static List<String> extractSignature(List<String> list, List<String> list2, boolean bl) {
        boolean bl2;
        if (list.isEmpty()) {
            return list2;
        }
        String string = list.get(0);
        List<String> list3 = list.subList(1, list.size());
        boolean bl3 = bl2 = !string.isEmpty() && string.chars().allMatch(n -> n == 45);
        if (bl2 && bl) {
            return list2;
        }
        if (bl2) {
            return LicenseParser.extractSignature(list3, list2, true);
        }
        if (bl) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.addAll(list2);
            arrayList.add(string);
            return LicenseParser.extractSignature(list3, arrayList, bl);
        }
        return LicenseParser.extractSignature(list3, list2, bl);
    }

    private static Map<String, String> parseLicenseProperties(String string2) {
        return Optional.ofNullable(string2).map(string -> LicenseParser.parseLicenseProperties(Arrays.asList(string.split("\n")))).orElseThrow(() -> new MalformedLicenseException(string2 + " is not a valid license properties"));
    }

    private static Map<String, String> parseLicenseProperties(List<String> list) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (String string : list) {
            if (!string.contains(":")) continue;
            int n = string.indexOf(":");
            String string2 = string.substring(0, n).trim();
            String string3 = string.substring(n + 1).trim();
            linkedHashMap.put(string2, string3);
        }
        return linkedHashMap;
    }

    private static String mkString(List<String> list, String string) {
        return list.stream().reduce("", (string2, string3) -> string2 + string + string3);
    }

    private static String getLicenseProperty(Map<String, String> map, String string) {
        if (map.containsKey(string)) {
            return map.get(string);
        }
        throw new MissingLicensePropertyException(string);
    }
}

