/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.frontend.nst.nodes;

import com.ergy.fset.FList;
import com.ergy.fset.FTreeList;
import com.fortify.frontend.nst.SourceInfo;
import com.fortify.frontend.nst.nodes.STExpression;
import com.fortify.frontend.nst.nodes.STNode;
import com.fortify.frontend.nst.nodes.STType;
import com.fortify.frontend.nst.nodes.Visitor;

public class STAllocation
extends STExpression {
    private STType type;
    private FList<STExpression> indexes = new FTreeList<STExpression>();

    public void setIndexes(FList<STExpression> fList) {
        this.indexes = fList;
    }

    public STAllocation() {
    }

    public STAllocation(SourceInfo sourceInfo) {
        super(sourceInfo);
    }

    @Override
    public FList<STNode> getChildren() {
        FList<Object> fList = FTreeList.emptyList();
        fList = fList.withLast(this.type);
        fList = fList.concat(this.indexes);
        return fList;
    }

    public STType getType() {
        return this.type;
    }

    public void setType(STType sTType) {
        sTType.setParent(this);
        this.type = sTType;
    }

    public FList<STExpression> getIndexes() {
        return this.indexes;
    }

    public String toString() {
        return "new " + this.getType().toString();
    }

    @Override
    public STAllocation clone() {
        return this.clone(new STAllocation(this.getSourceInfo()));
    }

    @Override
    protected STAllocation clone(STNode sTNode) {
        STAllocation sTAllocation = (STAllocation)sTNode;
        super.clone(sTAllocation);
        if (this.getType() != null) {
            sTAllocation.setType(this.getType().clone());
        }
        for (STExpression sTExpression : this.getIndexes()) {
            sTAllocation.addIndex(sTExpression.clone());
        }
        return sTAllocation;
    }

    public void addIndex(STExpression sTExpression) {
        sTExpression.setParent(this);
        this.indexes = this.indexes.withLast(sTExpression);
    }

    @Override
    public <E> E accept(Visitor<E> visitor) {
        return visitor.visit(this);
    }
}

