/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.util.Normalizer;
import com.liferay.util.RSSThreadLocal;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedOutput;
import java.util.List;
import org.jdom.IllegalDataException;

public class RSSUtil {
    public static final String ATOM = "atom";
    public static final String DISPLAY_STYLE_ABSTRACT = "abstract";
    public static final String DISPLAY_STYLE_DEFAULT = RSSUtil._getDisplayStyleDefault();
    public static final String DISPLAY_STYLE_FULL_CONTENT = "full-content";
    public static final String DISPLAY_STYLE_TITLE = "title";
    public static final String[] DISPLAY_STYLES = new String[]{"abstract", "full-content", "title"};
    public static final String ENTRY_TYPE_DEFAULT = "html";
    public static final String FEED_TYPE_DEFAULT = RSSUtil._getFeedTypeDefault();
    public static final String[] FEED_TYPES = RSSUtil._getFeedTypes();
    public static final String FORMAT_DEFAULT;
    public static final String RSS = "rss";
    public static final String TYPE_DEFAULT;
    public static final double VERSION_DEFAULT;
    private static final String _REGEXP_STRIP = "[\\d\\w]";

    static {
        TYPE_DEFAULT = FORMAT_DEFAULT = RSSUtil.getFeedTypeFormat(FEED_TYPE_DEFAULT);
        VERSION_DEFAULT = RSSUtil.getFeedTypeVersion(FEED_TYPE_DEFAULT);
    }

    public static String export(SyndFeed feed) throws FeedException {
        RSSThreadLocal.setExportRSS(true);
        feed.setEncoding("UTF-8");
        SyndFeedOutput output = new SyndFeedOutput();
        try {
            return output.outputString(feed);
        }
        catch (IllegalDataException illegalDataException) {
            RSSUtil._regexpStrip(feed);
            return output.outputString(feed);
        }
    }

    public static String getFeedType(String type, double version) {
        return String.valueOf(type) + "_" + version;
    }

    public static String getFeedTypeFormat(String feedType) {
        String[] parts;
        if (Validator.isNotNull((String)feedType) && (parts = StringUtil.split((String)feedType, (String)"_")).length == 2) {
            return GetterUtil.getString((String)parts[0], (String)FORMAT_DEFAULT);
        }
        return FORMAT_DEFAULT;
    }

    public static String getFeedTypeName(String feedType) {
        String type = RSSUtil.getFeedTypeFormat(feedType);
        if (type.equals(ATOM)) {
            type = "Atom";
        } else if (type.equals(RSS)) {
            type = "RSS";
        }
        double version = RSSUtil.getFeedTypeVersion(feedType);
        return String.valueOf(type) + " " + version;
    }

    public static double getFeedTypeVersion(String feedType) {
        String[] parts;
        if (Validator.isNotNull((String)feedType) && (parts = StringUtil.split((String)feedType, (String)"_")).length == 2) {
            return GetterUtil.getDouble((String)parts[1], (double)VERSION_DEFAULT);
        }
        return VERSION_DEFAULT;
    }

    public static String getFormatType(String format) {
        if (format == null) {
            return FORMAT_DEFAULT;
        }
        int x = format.indexOf(ATOM);
        if (x >= 0) {
            return ATOM;
        }
        int y = format.indexOf(RSS);
        if (y >= 0) {
            return RSS;
        }
        return FORMAT_DEFAULT;
    }

    public static double getFormatVersion(String format) {
        if (format == null) {
            return VERSION_DEFAULT;
        }
        int x = format.indexOf("10");
        if (x >= 0) {
            return 1.0;
        }
        int y = format.indexOf("20");
        if (y >= 0) {
            return 2.0;
        }
        return VERSION_DEFAULT;
    }

    private static String _getDisplayStyleDefault() {
        return GetterUtil.getString((String)PropsUtil.get((String)"rss.feed.display.style.default"), (String)DISPLAY_STYLE_FULL_CONTENT);
    }

    private static String _getFeedTypeDefault() {
        return GetterUtil.getString((String)PropsUtil.get((String)"rss.feed.type.default"), (String)RSSUtil.getFeedType(ATOM, 1.0));
    }

    private static String[] _getFeedTypes() {
        return GetterUtil.getStringValues((Object[])PropsUtil.getArray((String)"rss.feed.types"), (String[])new String[]{FEED_TYPE_DEFAULT});
    }

    private static String _regexpStrip(String text) {
        text = Normalizer.normalizeToAscii(text);
        char[] array = text.toCharArray();
        int i = 0;
        while (i < array.length) {
            String s = String.valueOf(array[i]);
            if (!s.matches(_REGEXP_STRIP)) {
                array[i] = 32;
            }
            ++i;
        }
        return new String(array);
    }

    private static void _regexpStrip(SyndFeed syndFeed) {
        syndFeed.setTitle(RSSUtil._regexpStrip(syndFeed.getTitle()));
        syndFeed.setDescription(RSSUtil._regexpStrip(syndFeed.getDescription()));
        List syndEntries = syndFeed.getEntries();
        for (SyndEntry syndEntry : syndEntries) {
            syndEntry.setTitle(RSSUtil._regexpStrip(syndEntry.getTitle()));
            SyndContent syndContent = syndEntry.getDescription();
            syndContent.setValue(RSSUtil._regexpStrip(syndContent.getValue()));
        }
    }
}

