/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.ant.bnd;

import aQute.bnd.build.Project;
import aQute.bnd.build.ProjectBuilder;
import aQute.bnd.differ.Baseline;
import aQute.bnd.differ.DiffPluginImpl;
import aQute.bnd.osgi.Builder;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Processor;
import aQute.bnd.service.diff.Delta;
import aQute.bnd.service.diff.Diff;
import aQute.bnd.service.diff.Differ;
import aQute.bnd.version.Version;
import aQute.service.reporter.Reporter;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.util.ant.bnd.BaseBndTask;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.types.Path;

public class BaselineJarTask
extends BaseBndTask {
    private static final String _BASELINE_REPORTS_DIR = "baseline-reports";
    private final String[] _BUILD_DEFAULTS = new String[]{"-plugin: aQute.bnd.deployer.obr.LocalOBR;name=baselinerepo;mode=build;local=${workspace}/.bnd/baselinerepo", "-pluginpath: ${workspace}/osgi/lib/plugin/bnd-repository.jar", "-baseline: ${ant.project.name}", "-baselinerepo: baselinerepo", "-releaserepo: baselinerepo"};
    private String _baselineResportsDirName;
    private File _bndDir;
    private Path _classpath;
    private List<File> _classpathFiles = new ArrayList<File>();
    private DiffPluginImpl _diffPluginImpl = new DiffPluginImpl();
    private File _file;
    private boolean _headerPrinted;
    private File _logFile;
    private File _outputPath;
    private PrintWriter _printWriter;
    private String _reportLevel;
    private boolean _reportLevelIsDiff;
    private boolean _reportLevelIsOff = true;
    private boolean _reportLevelIsPersist;
    private boolean _reportLevelIsStandard;
    private File _sourcePath;

    public void addClasspath(Path classpath) {
        this._classpath = classpath;
    }

    public void setFile(File file) {
        this._file = file;
    }

    public void setOutputPath(File outputPath) {
        this._outputPath = outputPath;
    }

    public void setSourcePath(File sourcePath) {
        this._sourcePath = sourcePath;
    }

    public void trace(String format, Object ... args) {
    }

    protected void doBaselineJar(Jar jar, File output, Project bndProject) throws Exception {
        if (this._reportLevelIsOff) {
            return;
        }
        ProjectBuilder projectBuilder = new ProjectBuilder(bndProject);
        Jar baselineJar = projectBuilder.getBaselineJar();
        try {
            if (baselineJar == null) {
                String name = bndProject.getProperty("-baselinerepo");
                bndProject.deploy(name, output);
                return;
            }
            Baseline baseline = new Baseline((Reporter)this, (Differ)this._diffPluginImpl);
            Set infos = baseline.baseline(jar, baselineJar, null);
            if (infos.isEmpty()) {
                return;
            }
            Baseline.BundleInfo bundleInfo = baseline.getBundleInfo();
            Baseline.Info[] infosArray = infos.toArray(new Baseline.Info[infos.size()]);
            Arrays.sort(infosArray, new Comparator<Baseline.Info>(){

                @Override
                public int compare(Baseline.Info info1, Baseline.Info info2) {
                    return info1.packageName.compareTo(info2.packageName);
                }
            });
            Baseline.Info[] infoArray = infosArray;
            int n = infosArray.length;
            int n2 = 0;
            while (n2 < n) {
                block24: {
                    Diff packageDiff;
                    Delta delta;
                    String warnings;
                    Baseline.Info info;
                    block23: {
                        Version suggestedVersion;
                        Version newerVersion;
                        block22: {
                            info = infoArray[n2];
                            warnings = "-";
                            newerVersion = info.newerVersion;
                            suggestedVersion = info.suggestedVersion;
                            if (suggestedVersion != null) {
                                if (newerVersion.compareTo(suggestedVersion) > 0) {
                                    warnings = "EXCESSIVE VERSION INCREASE";
                                } else if (newerVersion.compareTo(suggestedVersion) < 0) {
                                    warnings = "VERSION INCREASE REQUIRED";
                                }
                            }
                            if ((delta = (packageDiff = info.packageDiff).getDelta()) != Delta.REMOVED) break block22;
                            warnings = "PACKAGE REMOVED";
                            break block23;
                        }
                        if (delta != Delta.UNCHANGED) break block23;
                        boolean newVersionSuggested = false;
                        if (suggestedVersion.getMajor() != newerVersion.getMajor() || suggestedVersion.getMicro() != newerVersion.getMicro() || suggestedVersion.getMinor() != newerVersion.getMinor()) {
                            warnings = "VERSION INCREASE SUGGESTED";
                            newVersionSuggested = true;
                        }
                        if (!newVersionSuggested && !info.mismatch) break block24;
                    }
                    if (!this._reportLevelIsStandard || !warnings.equals("-")) {
                        this.doInfo(bundleInfo, info, warnings);
                        if (this._reportLevelIsDiff && delta != Delta.REMOVED) {
                            this.doPackageDiff(packageDiff);
                        }
                    }
                }
                ++n2;
            }
        }
        finally {
            if (baselineJar != null) {
                baselineJar.close();
            }
            if (this._printWriter != null) {
                this._printWriter.close();
            }
            projectBuilder.close();
        }
    }

    @Override
    protected void doBeforeExecute() throws Exception {
        super.doBeforeExecute();
        File bndRootFile = this.getBndRootFile();
        File rootDir = bndRootFile.getParentFile();
        if (this._classpath == null) {
            throw new BuildException("classpath is null");
        }
        if (this._file == null || !this._file.exists() || this._file.isDirectory()) {
            if (this._file != null) {
                this.project.log("file is either missing or is a directory " + this._file.getAbsolutePath(), 0);
            }
            throw new BuildException("file is invalid");
        }
        if (this._outputPath == null || !this._outputPath.exists() || !this._outputPath.isDirectory()) {
            if (this._outputPath != null) {
                this.project.log("outputPath is either missing or is not a directory " + this._outputPath.getAbsolutePath(), 0);
            }
            throw new BuildException("outputPath is invalid");
        }
        this._reportLevel = this.project.getProperty("baseline.jar.report.level");
        this._reportLevelIsDiff = Validator.equals((Object)this._reportLevel, (Object)"diff");
        this._reportLevelIsOff = Validator.equals((Object)this._reportLevel, (Object)"off");
        this._reportLevelIsPersist = Validator.equals((Object)this._reportLevel, (Object)"persist");
        this._reportLevelIsStandard = Validator.equals((Object)this._reportLevel, (Object)"standard");
        if (this._reportLevelIsPersist) {
            this._reportLevelIsDiff = true;
            File baselineReportsDir = new File(rootDir, this.getBaselineResportsDirName());
            if (!baselineReportsDir.exists() && !baselineReportsDir.mkdir()) {
                throw new BuildException("Unable tocreate " + baselineReportsDir.getName());
            }
            this._logFile = new File(baselineReportsDir, String.valueOf(this._outputPath.getName()) + ".log");
            if (this._logFile.exists()) {
                this._logFile.delete();
            }
        }
        if (this._sourcePath == null || !this._sourcePath.exists() || !this._sourcePath.isDirectory()) {
            if (this._sourcePath != null) {
                this.project.log("sourcePath is either missing or is not a directory " + this._sourcePath.getAbsolutePath(), 0);
            }
            throw new BuildException("sourcePath is not set correctly");
        }
        String[] stringArray = this._classpath.list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            this._classpathFiles.add(new File(fileName.replace('\\', '/')));
            ++n2;
        }
        this._bndDir = new File(rootDir, this.getBndDirName());
        if (!rootDir.canWrite()) {
            return;
        }
        File buildFile = new File(this._bndDir, "build.bnd");
        if (!this._bndDir.exists() && !this._bndDir.mkdir()) {
            return;
        }
        if (buildFile.exists() || !this._bndDir.canWrite()) {
            return;
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(buildFile));
        String[] stringArray2 = this._BUILD_DEFAULTS;
        int n3 = this._BUILD_DEFAULTS.length;
        int n4 = 0;
        while (n4 < n3) {
            String line = stringArray2[n4];
            bufferedWriter.write(line);
            bufferedWriter.newLine();
            ++n4;
        }
        bufferedWriter.close();
        File baselineRepoDir = new File(this._bndDir, "baselinerepo");
        if (!baselineRepoDir.exists()) {
            baselineRepoDir.mkdir();
        }
    }

    protected void doDiff(Diff diff, StringBuffer sb) {
        String output = String.format("%s%-3s %-10s %s", sb, this.getShortDelta(diff.getDelta()), StringUtil.toLowerCase((String)String.valueOf(diff.getType())), diff.getName());
        this.project.log(output, 1);
        if (this._printWriter != null) {
            this._printWriter.println(output);
        }
        sb.append("\t");
        for (Diff curDiff : diff.getChildren()) {
            if (curDiff.getDelta() == Delta.UNCHANGED) continue;
            this.doDiff(curDiff, sb);
        }
        sb.deleteCharAt(sb.length() - 1);
    }

    @Override
    protected void doExecute() throws Exception {
        Project bndProject = this.getBndProject();
        Builder builder = new Builder((Processor)bndProject);
        builder.setClasspath(this._classpathFiles.toArray(new File[this._classpathFiles.size()]));
        builder.setPedantic(this.isPedantic());
        builder.setProperties(this._file);
        builder.setSourcepath(new File[]{this._sourcePath});
        Jar[] jars = builder.builds();
        boolean taskFailed = this.report();
        boolean bndFailed = this.report((Reporter)builder);
        if (taskFailed || bndFailed) {
            throw new BuildException("bnd failed", new Location(this._file.getAbsolutePath()));
        }
        Jar[] jarArray = jars;
        int n = jars.length;
        int n2 = 0;
        while (n2 < n) {
            Map resources;
            Jar jar = jarArray[n2];
            String bsn = jar.getName();
            File outputFile = this._outputPath;
            String path = builder.getProperty("-output");
            outputFile = path == null ? BaselineJarTask.getFile((File)this._outputPath, (String)(String.valueOf(bsn) + ".jar")) : BaselineJarTask.getFile((File)this._outputPath, (String)path);
            if (!outputFile.exists() || outputFile.lastModified() <= jar.lastModified()) {
                jar.write(outputFile);
                resources = jar.getResources();
                this.log(String.valueOf(jar.getName()) + " (" + outputFile.getName() + ") " + resources.size());
                this.doBaselineJar(jar, outputFile, bndProject);
            } else {
                resources = jar.getResources();
                this.log(String.valueOf(jar.getName()) + " (" + outputFile.getName() + ") " + resources.size() + " (not modified)");
            }
            this.report();
            jar.close();
            ++n2;
        }
        builder.close();
    }

    protected void doHeader(Baseline.BundleInfo bundleInfo) {
        if (this._headerPrinted) {
            return;
        }
        this._headerPrinted = true;
        this.project.log("[Baseline Report] Mode: " + this._reportLevel, 1);
        if (bundleInfo.mismatch) {
            this.project.log("[Baseline Warning] Bundle Version Change Recommended: " + bundleInfo.suggestedVersion, 1);
        }
        this.reportLog(" ", "PACKAGE_NAME", "DELTA", "CUR_VER", "BASE_VER", "REC_VER", "WARNINGS", "ATTRIBUTES");
        this.reportLog("=", "==================================================", "==========", "==========", "==========", "==========", "==========", "==========");
    }

    protected void doInfo(Baseline.BundleInfo bundleInfo, Baseline.Info info, String warnings) {
        this.doHeader(bundleInfo);
        this.reportLog(String.valueOf(info.mismatch ? (char)'*' : ' '), info.packageName, String.valueOf(info.packageDiff.getDelta()), String.valueOf(info.newerVersion), String.valueOf(info.olderVersion), String.valueOf(info.suggestedVersion == null ? "-" : info.suggestedVersion), warnings, String.valueOf(info.attributes));
    }

    protected void doPackageDiff(Diff diff) {
        StringBuffer sb = new StringBuffer();
        sb.append("\t");
        for (Diff curDiff : diff.getChildren()) {
            if (curDiff.getDelta() == Delta.UNCHANGED) continue;
            this.doDiff(curDiff, sb);
        }
    }

    protected String getBaselineResportsDirName() {
        if (this._baselineResportsDirName != null) {
            return this._baselineResportsDirName;
        }
        this._baselineResportsDirName = this.project.getProperty("baseline.jar.reports.dir.name");
        if (this._baselineResportsDirName == null) {
            this._baselineResportsDirName = _BASELINE_REPORTS_DIR;
        }
        return this._baselineResportsDirName;
    }

    protected String getShortDelta(Delta delta) {
        if (delta == Delta.ADDED) {
            return "+";
        }
        if (delta == Delta.CHANGED) {
            return "~";
        }
        if (delta == Delta.MAJOR) {
            return ">";
        }
        if (delta == Delta.MICRO) {
            return "0xB5";
        }
        if (delta == Delta.MINOR) {
            return "<";
        }
        if (delta == Delta.REMOVED) {
            return "-";
        }
        String deltaString = delta.toString();
        return String.valueOf(deltaString.charAt(0));
    }

    protected void reportLog(String string1, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        String output = String.format("%s %-50s %-10s %-10s %-10s %-10s %-10s", string1, string2, string3, string4, string5, string6, string7);
        this.project.log(output, 1);
        if (this._reportLevelIsPersist) {
            try {
                if (this._printWriter == null) {
                    this._logFile.createNewFile();
                    this._printWriter = new PrintWriter(this._logFile);
                }
                this._printWriter.println(output);
            }
            catch (IOException ioe) {
                throw new BuildException((Throwable)ioe);
            }
        }
    }
}

